package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

import java.util.Map;

@DWRestfulService
public interface IPresetCollectionService extends DWService {

    @AllowAnonymous
    @DWRequestMapping(path = "/presetCollection", method = {DWRequestMethod.PUT})
    void put(String name) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/presetCollection", method = {DWRequestMethod.DELETE})
    void delete(String name) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/presetCollection/list", method = {DWRequestMethod.GET})
    Object getList(String name, Map<String, Object> conditions, int limit) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/presetCollection/list", method = {DWRequestMethod.GET})
    Object getList(String name, Map<String, Object> conditions, int limit, String... indexes) throws Exception;
}
