package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.kg.dto.TBBReportReplacer;
import com.digiwin.athena.kg.activity.Activity;

import java.util.List;
import java.util.Map;

@DWRestfulService
public interface IRecordService  extends DWService {


    /**
     * 根据产品code更新TBB报表数据
     * @param reportReplacer
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/tenantTBBReportsByProductCode", method = {DWRequestMethod.POST})
    Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception;

    /**
     * 根据mode类型和productCode获取报表
     * @param mode mode类型
     * @param productCode 产品code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/tBBReports", method = {DWRequestMethod.GET})
    Object getTBBReports(String mode, String productCode) throws Exception;

    /**
     * 获取公共基础资料
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/baseDataApplication", method = {DWRequestMethod.GET})
    Object getBaseDataApplication() throws Exception;

    /**
     * 根据类型获取报表/基础资料/手动创建项目
     * @param pattern
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/activitiesByPattern", method = {DWRequestMethod.GET})
    Object getActivitiesByPattern(String pattern) throws Exception;

    /**
     * 获取报表/基础资料/手动创建项目
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/activitiesInfoByPattern", method = {DWRequestMethod.GET})
    Object getActivitiesInfoByPattern() throws Exception;

    /**
     * 根据类型,应用code获取报表/基础资料/手动创建项目
     * @param pattern
     * @param appCode
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/activitiesByPatternAndAppCode", method = {DWRequestMethod.GET})
    Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception;

    /**
     * 根据类型获取报表/基础资料/手动创建项目并排序
     * @param pattern
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/activitiesAndSortByPattern", method = {DWRequestMethod.GET})
    Object getActivitiesAndSortByPattern(String pattern) throws Exception;

    /**
     * 根据任务code获取任务，包含页面设计数据和租户级配置数据
     * 替换至接口：/restful/service/datamap/task/activityDefinition
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/record/activityDefinition", method = {DWRequestMethod.GET})
    Object getActivityDefinition(String activityId, String pageCode) throws Exception;

    @DWRequestMapping(path = "/record/activityDefinitionBasic", method = {DWRequestMethod.GET})
    Object getActivityDefinitionBasic(String activityId, String pageCode) throws Exception;


    @DWRequestMapping(path = "/record/statements", method = {DWRequestMethod.GET})
    Object getStatements(String effect) throws Exception;

    @DWRequestMapping(path = "/record/entries", method = {DWRequestMethod.GET})
    Object getEntries(String effect) throws Exception;

    @DWRequestMapping(path = "/record/patterns", method = {DWRequestMethod.GET})
    Object getPatterns(String effect,String pattern) throws Exception;

    @DWRequestMapping(path = "/record/activityNames", method = {DWRequestMethod.POST})
    List<Activity> postActivityNames(Map<String,Object> query) throws DWBusinessException;


}
