package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.kg.dto.queryCondition.ReportConditionSetting;

/**
 * ABI报表服务
 * @author lzw
 * @date 2024/7/29
 * @description:
 * @javadoc
 **/
@DWRestfulService
public interface IReportConditionService extends DWService {

    /**
     * 查询查询条件设置
     * @param code 报表code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/reportCondition/queryConditionSetting", method = {DWRequestMethod.GET})
    Object getQueryConditionSetting(String code) throws Exception;

    /**
     * 保存查询条件设置
     * @param setting 查询条件设置
     * @throws Exception
     */
    @DWRequestMapping(path = "/reportCondition/saveConditionSetting", method = {DWRequestMethod.POST})
    void postSaveConditionSetting(ReportConditionSetting setting) throws Exception;

    /**
     * 清除查询条件设置
     * @param code 报表code
     * @throws Exception
     */
    @DWRequestMapping(path = "/reportCondition/resetConditionSetting", method = {DWRequestMethod.POST})
    void postResetConditionSetting(String code) throws Exception;









}
