package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.kg.dto.StatementQueryConditionDTO;
import com.digiwin.athena.kg.statement.StatementFormMatcher;

import java.util.List;

/**
 * 报表相关服务
 * @ClassName StatementService
 * @Description 报表相关服务
 * @Author zhuangli
 * @Date 2022/2/16 14:27
 * @Version 1.0
 * @javadoc
 **/
@DWRestfulService
public interface IStatementService extends DWService {

    /**
     * 根据查询条件匹配对应的报表id
     * @param queryObject 查询条件
     * @return
     */
    @DWRequestMapping(path = "/statement/resId", method = {DWRequestMethod.POST})
    Object postResId(StatementQueryConditionDTO queryObject);

    /**
     * 根据租户id和报表id获取元数据
     * @param tenantId 租户id
     * @param statementCode 报表code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/statement/dataCharacteristic", method = {DWRequestMethod.GET})
    Object getDataCharacteristic(String tenantId, String statementCode) throws Exception;

    /**
     * 更新报表样式
     * @param tenantId 租户id
     * @param date 日期
     * @param resId
     * @param statementCode 报表code
     * @return
     */
    @DWRequestMapping(path = "/statement/editStyle", method = {DWRequestMethod.POST})
    Object postEditStyle(String tenantId, String date, String resId, String statementCode) throws DWBusinessException;

    /**
     * 复制报表样式
     * @param tenantId 租户id
     * @param workName 工作簿名称
     * @param resId
     * @param statementCode 报表code
     * @param lang 多语言
     * @return
     */
    @DWRequestMapping(path = "/statement/copyStyle", method = {DWRequestMethod.POST})
    Object postCopyStyle(String tenantId, String workName, String resId, String statementCode, String lang) throws DWBusinessException;

    /**
     * 删除报表样式
     * @param tenantId 租户id
     * @param resId
     * @param statementCode 报表code
     * @return
     */
    @DWRequestMapping(path = "/statement/deleteStyle", method = {DWRequestMethod.POST})
    Object postDeleteStyle(String tenantId, String resId, String statementCode) throws DWBusinessException;

    /**
     * 根据租户id和报表code获取样式
     * @param tenantId 租户id
     * @param statementCode 报表code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/statement/styleList", method = {DWRequestMethod.GET})
    Object getStyleList(String tenantId, String statementCode) throws Exception;

    /**
     * 发布样式
     * @param tenantId 租户id
     * @param workName 工作簿名称
     * @param resId
     * @param statementCode 报表code
     * @param lang 多语言
     * @param items 报表形式集合
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/statement/stylePublish", method = {DWRequestMethod.POST})
    Object postStylePublish(String tenantId, String workName, String resId, String statementCode, String lang, List<StatementFormMatcher> items) throws Exception;

    /**
     * 取消样式发布
     * @param tenantId 租户id
     * @param resId
     * @param statementCode 报表code
     * @return
     */
    @DWRequestMapping(path = "/statement/styleUnPublish", method = {DWRequestMethod.POST})
    Object postStyleUnPublish(String tenantId, String resId, String statementCode);

    /**
     * 获取abi报表用户
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/statement/aBIReportUser", method = {DWRequestMethod.GET})
    Object getABIReportUser(String startDate, String endDate) throws DWBusinessException;

}
