package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.relation.Api;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.povo.UriRequest;
import com.digiwin.athena.datamap.service.IConfigService;
import com.digiwin.athena.datamap.service.inner.SelectService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.definition.EocUnit;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import lombok.extern.slf4j.Slf4j;

import org.neo4j.driver.summary.Plan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@MyExceptionHandler
@Slf4j
@Service
public class ConfigService implements IConfigService {

    private static final String prefix = "config://";

    protected static final Map<String, Class<?>> configMap = new HashMap<>();
    {
        configMap.put("data", DataDescription.class);
        configMap.put("project", Project.class);
        configMap.put("plan", Plan.class);
        configMap.put("task", Task.class);
        configMap.put("activity", Activity.class);
        configMap.put("flow", FlowGraph.class);
        configMap.put("api", Api.class);
        // configMap.put("applicationProjectRelation", ApplicationProjectRelation.class);
        // configMap.put("projectPlanRelation", ProjectPlanRelation.class);
        // configMap.put("tenantApplicationRelation", TenantApplicationRelation.class);

        configMap.put("eocUnit", EocUnit.class);
    }

    @Autowired
    SelectService selectService;

    @Override
    public Object postConfig(UriRequest request) throws DWException {
        Assert.notNull(request.getUri(), "uri is null");
        String uri = request.getUri();
        if (!uri.startsWith(prefix)) {
            throw new DWArgumentException(uri, I18nUtils.getValue("datamap.config.uriError"));
        }
        URI uri0 = URI.create(uri);
        String table = uri0.getHost();
        String path = uri0.getPath();
        Class c = configMap.get(table);
        if (null == c) {
            return null;
        }
        if (null != path) {
            path = path.replaceAll("/", ".");
        } else {
            path = ".";
        }
        path = "$" + path;
        String query = uri0.getQuery();
        Map<String, Object> q = qtm(query);
        request.setQuery(q);
        List matched = selectService.allMatched(q, c, table);
        Object root = null;
        if (request.isAllMatch()) {
            root = matched;
        } else {
            if (matched.size() > 0) {
                root = matched.get(0);
            }
        }
        Object value = JSONPath.eval(root, path);
        return value;
    }

    @Override
    public Map<String, Object> postConfigBatch(UriRequest request) throws DWException {
        Map<String, Object> results = new HashMap<>();
        request.getUris().forEach((k, v) -> {
            request.setUri(v);
            try {
                Object value = postConfig(request);
                results.put(k, value);
            } catch (DWException e) {
                log.error(e.toString());
            }
        });

        return results;
    }

    public static void main(String[] args) {
        String uri = "config://task/name/axf/sfs?id=123&type=2";
        URI uri0 = URI.create(uri);
        System.out.println(uri0.getHost());
        System.out.println(uri0.getPath());
        System.out.println(uri0.getQuery());
        System.out.println(qtm(uri0.getQuery()));
        System.out.println(uri0.getPath().replaceAll("/", "."));

    }

    public static Map<String, Object> qtm(String query) {
        Map<String, Object> m = new HashMap<>();
        if (null != query) {
            String[] items = query.split("&");
            for (String item : items) {
                String[] kv = item.split("=");
                if (kv.length > 1) {
                    m.put(kv[0], kv[1]);
                }
            }
        }
        return m;
    }
}
