package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionHandler;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.datamap.kg.ActionMetadataDTOConvertor;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.datamap.service.IActionService;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 15:31
 **/
@MyExceptionHandler
@Service
@Slf4j
public class DataMapActionService implements IActionService {

    @Autowired
    List<ActionHandler> actionHandlers;

    @Autowired
    IMechanismService mechanismService;

    @Autowired
    KmService kmService;

    @Autowired
    ActionMetadataManager actionMetadataManager;

    @Autowired
    ProductNameResolver productNameResolver;

    @Override
    public ActionResp postProcess(ActionReq req) throws DWException {
        ActionResp resp = new ActionResp();
        ActionHandler handler = null;
        for (ActionHandler handler1 : actionHandlers) {
            if (handler1.accept(req)) {
                handler = handler1;
                break;
            }
        }
        if (null == handler) {
            throw new DWBusinessException("cant find ActionHandler by actionId:" + req.getActionId());
        }
        ActionContext context = new ActionContext();
        context.setActionReq(req);
        HttpServletRequest httpRequest = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", null);
        String token = httpRequest.getHeader("token");
        if (null == token) {
            token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
        }
        context.setTenantId(tenantId);
        context.setToken(token);
        String locale = httpRequest.getHeader("locale");
        context.setLocale(locale);
        try {
            resp = handler.handler(context);
        } catch (Exception e) {
            Map<String, Object> rows = new HashMap<>();
            rows.put("rows", new JSONArray[0]);
            resp.setData(rows);
            resp.setSuccess(Boolean.FALSE);
            log.error("req.getActionId():{},e:{}", req.getActionId(), e);
        }

        return resp;
    }

    @Override
    public ActionResp postProcess2(ActionReq req) throws DWException {
        return postProcess(req);
    }

    @Override
    public ActionResp judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        log.info("ActionService.judgeBusinessCondition beginning，入参有：{}", apiInfoDTO);
        ActionResp actionResp = new ActionResp();
        actionResp.setData(mechanismService.judgeBusinessCondition(apiInfoDTO));
        return actionResp;
    }


    @Override
    public Object getMetadata(String actionId) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        String tenantVersion = kmService.tenantVersion();
//        actionId = compositeExchangeActionService.getRealActionId(actionId);

        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();

        EspActionMetadataDTO responseDTO = this.actionMetadataManager.getActionMetadata(actionId, tenantId, tenantVersion);
        GetActionLocaleResponseDTO localeResponseDTO = ActionMetadataDTOConvertor.convertToGetActionLocaleResponseDTO(responseDTO);
        ProductNameGetter productNameGetter = null;
        if (actionId.startsWith("esp_")) {
            productNameGetter = new ProductNameGetter.MdcProductNameGetter(this.productNameResolver, actionId.substring(4), tenantId);
        }
        //给requestApiFieldMetadata多语言重新赋值，租户产品字段精度赋值
        MetadataTranslator.translateField(localeResponseDTO, responseDTO, localeStr, productNameGetter);

//        Object result =  DWServiceResultBuilder.build(localeResponseDTO);
//        return result;
        return localeResponseDTO;
    }

}
