package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.IBusinessService;

import com.digiwin.athena.domain.common.Constants;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kmservice.service.DataPickService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xuhx
 * @date 2024/10/21
 */
@Service
@Slf4j
public class DataMapBusinessService implements IBusinessService {

    @Autowired
    DataPickService dataPickService;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public List<Project> postProjectExcludeMainlineByAppCode(String appCode) throws DWBusinessException {
        String version = dataPickService.tenantVersion();
        Query query = new Query();
        Criteria criteria = Criteria.where("application").is(appCode);
        query.addCriteria(criteria);
        query.addCriteria(Criteria.where("executeType").ne("mainline")
                .and("tenantId").is(Constants.defaultTenantId)
                .and("version").is(version));
        return mongoTemplate.find(query, Project.class);
    }
}
