package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.datamap.service.IDictService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.utils.LanguageUtil;
import com.digiwin.athena.kg.dict.Dictionary;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Lang
@Service
@Slf4j
public class DataMapDictService implements IDictService {

    @Autowired
    @Qualifier("kgSystem")
    private MongoTemplate sysMongoTemplate;
    @Autowired
    KmService kmService;

    @Override
    public Object getDictByKey(String key) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKey locale:{}",locale);
        Query query = new Query();
        query.addCriteria(Criteria.where("key").is(key).and("version").is(tenantVersion));
        query.with(Sort.by(Sort.Order.asc("code")));
        List<Dictionary> dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
        try {
            LanguageUtil.processLocaleLanguage(dicts, locale);
        } catch (Exception e) {
            log.error(e.toString());
        }
        return dicts;
    }

    @Override
    public Object getDictByKeyAndCode(String key, String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKeyAndCode locale:{}",locale);
        Query query = new Query();
        query.addCriteria(Criteria.where("key").is(key).and("code").is(code).and("version").is(tenantVersion));
        Dictionary dict = this.sysMongoTemplate.findOne(query, Dictionary.class, "dictionary");
        try {
            LanguageUtil.processLocaleLanguage(dict, locale);
        } catch (Exception e) {
            log.error(e.toString());
        }
        return dict;
    }

    @Override
    public Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        if(CollectionUtils.isEmpty(keyList)){
            return null;
        }
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKeyList locale:{}",locale);
        Query query = new Query();
        query.addCriteria(Criteria.where("key").in(keyList).and("version").is(tenantVersion));
        query.with(Sort.by(Sort.Order.asc("key"), Sort.Order.asc("code")));
        List<Dictionary> dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
        if(CollectionUtils.isEmpty(dicts)){
            log.info("getDictByKeyList is null keys:{}",keyList);
            return null;
        }
        try {
            LanguageUtil.processLocaleLanguage(dicts, locale);
        } catch (Exception e) {
            log.error(e.toString());
        }
        Map<String, List<Dictionary>> collect = dicts.stream().collect(Collectors.groupingBy(Dictionary::getKey));

        return collect;
    }


}
