package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.config.BusinessLogicBasic;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
//import com.digiwin.athena.datamap.config.BusinessLogicBasic;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.view.EmailView;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.service.IEmailService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.view.EmailView;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-26 15:03
 **/
@Lang
@MyExceptionHandler
@Service
public class DataMapEmailService implements IEmailService {

    @Autowired
    DataPickService pickService;

    @Autowired
    DataMapViewService dataMapViewService;

    @Override
    public Object postEmails(ViewRequest request) throws DWException {
        if (null != request.getEmailTemplateCode()) {
            return dataMapViewService.postEmails(request);
        }
        if (null != request.getTaskCode()) {
            String templateCode = (String) postEmailTemplateCode(request);
            request.setEmailTemplateCode(templateCode);
            return dataMapViewService.postEmails(request);
        }
        return null;
    }

    @Override
    public Object postEmailTemplateCode(ViewRequest request) throws DWException {
        if (null != request.getTaskCode()) {
            Task task = pickService.findByCode(request.getTaskCode(), Task.class);
            if (null != task && null != task.getConfig().get("businessLogic")) {
                List<BusinessLogicBasic> logics = JSON.parseArray(JSON.toJSONString(task.getConfig().get("businessLogic")), BusinessLogicBasic.class);
                for (BusinessLogicBasic logic : logics) {
                    if (BusinessLogicBasic.emailTemplateKey.equalsIgnoreCase(logic.getKey())) {
                        return logic.getTemplateCode();
                    }
                }
            }
        }
        return null;
    }

    @Deprecated
    @Override
    public Object postEmailUpdate(EmailView request) throws DWException {
        return null;
    }
}
