package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.HealthCheckComponent;
import com.digiwin.athena.datamap.service.IHealthcheckService;
import com.digiwin.athena.domain.core.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-09-22 08:59
 **/
@Service
public class DataMapHealthcheckService implements IHealthcheckService {

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public Object post(String type) throws DWException {
        Map<String, Map<String, HealthCheckComponent>> checkResult = new HashMap<>();
        if ("function".equals(type)) {
            Map<String, HealthCheckComponent> components = new HashMap<>();
            Map<String, HealthCheckComponent> functions = new HashMap<>();
            checkResult.put("component", components);
            checkResult.put("function", functions);

            // component
            try {
                mongoTemplate.collectionExists(Task.class);
                components.put("mongodb", HealthCheckComponent.newOne("UP", ""));
            } catch (Exception e) {
                components.put("mongodb", HealthCheckComponent.newOne("DOWN", e.getMessage()));
            }

            // function
            functions.put("serviceCallback", HealthCheckComponent.newOne("UP", ""));
            functions.put("servicePool", HealthCheckComponent.newOne("UP", ""));

        }

        return checkResult;
    }

    @Override
    public Object get() throws Exception {
        // WordCategory wordCategory = new WordCategory();
        // wordCategory.setCode("code02");
        // wordCategory.setName("cate2");
        // wordCategoryDao.insert(wordCategory);

        return null;
    }

    @Override
    public Object getTest1() throws Exception {
        System.out.println("enter test1...........");
        // Thread.sleep(10000);

        System.out.println("leave test1...........");
        return "ok";
    }

    @Override
    public Object getTest2() throws Exception {

        BlockingQueue queue = new LinkedBlockingQueue();
        queue.poll(10, TimeUnit.SECONDS);

        // throw new DWRuntimeException("101","DWRuntimeException...");
        return "ok";
    }

    @Override
    public Object getLogDetail(Boolean log) throws Exception {

        return null;
    }
}
