package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.service.ILevelService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.kmservice.locale.Lang;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Lang
@Slf4j
@Service
public class DataMapLevelService implements ILevelService {

    @Value("${iamApToken}")
    String appToken;

    @Autowired
    DatamapEocService datamapEocService;

    @Override
    public void syncDefaultLevel(String token) throws Exception {
        List<Map> levelList;
        String levelJson = "[{\n" +
                "    \"levelId\":\"Level_1\",\n" +
                "    \"levelName\":\"董事长\", \n" +
                "    \"sequence\":\"1\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_2\",\n" +
                "    \"levelName\":\"副董\", \n" +
                "    \"sequence\":\"2\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_3\",\n" +
                "    \"levelName\":\"总经理\", \n" +
                "    \"sequence\":\"3\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_4\",\n" +
                "    \"levelName\":\"副总\", \n" +
                "    \"sequence\":\"4\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_5\",\n" +
                "    \"levelName\":\"总监\", \n" +
                "    \"sequence\":\"5\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_6\",\n" +
                "    \"levelName\":\"经理\", \n" +
                "    \"sequence\":\"6\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_7\",\n" +
                "    \"levelName\":\"副理\", \n" +
                "    \"sequence\":\"7\"\n" +
                "},\n" +
                "{\n" +
                "    \"levelId\":\"Level_8\",\n" +
                "    \"levelName\":\"一般员工\", \n" +
                "    \"sequence\":\"9999\"\n" +
                "}]";
        levelList = JSON.parseArray(levelJson, Map.class);
        for (Map level : levelList) {
            try {
        //        String resp = AthenaUtils.postEoc("/api/eoc/v2/emp/level", null, JSON.toJSONString(level), token, appToken);
                datamapEocService.synclevel(level);
            } catch (Exception e) {
                log.error("同步level失败", e);
            }
        }
    }

}
