package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.datamap.report.DataMapReportManager;
import com.digiwin.athena.datamap.service.IStatementService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.DataMapHttpUtil;
import com.digiwin.athena.datamap.utils.JsonUtil;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.dto.StatementQueryConditionDTO;
import com.digiwin.athena.kg.statement.StatementDynamicCondition;
import com.digiwin.athena.kg.statement.StatementFormAdapter;
import com.digiwin.athena.kg.statement.StatementFormAdapterSystem;
import com.digiwin.athena.kg.statement.StatementFormMatcher;
import com.digiwin.athena.kg.statement.exception.StatementMatchException;
import com.digiwin.athena.kmservice.locale.Lang;

import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;
import com.digiwin.athena.kg.dict.Dictionary;

/**
 * @ClassName StatementService
 * @Description TODO
 * @Author zhuangli
 * @Date 2022/2/16 14:32
 * @Version 1.0
 **/
@Lang
@Service
@Slf4j
@MyExceptionHandler
public class DataMapStatementService implements IStatementService {


    @Autowired
    @Qualifier("kgSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("kgTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapReportManager dataMapReportManager;
    @Autowired
    KmService kmService;
    @Autowired
    DataMapActionService dataMapActionService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;

    public static final String COPY_CUSTOMIZE = "/abi/copy.rpt.customize";
    public static final String DELETE_CUSTOMIZE = "/abi/delete.customize";
    public static final String EDIT_WORKNAME_CUSTOMIZE = "/abi/update.rptname.customize";

    public static final String REPORT_KEY = "reportKey";
//    public String dapUri = "http://10.40.42.5:18301";
    @Value("${abiUrl}")
    private String dapUri;
    @Autowired
    private DataMapDictService dataMapDictService;

    /**
     * @Author zhuangli
     * @Description 根据查询条件匹配对应的报表id
     * @Date 16:19 2022/2/16
     * @Param
     * @return
     **/
    @Override
    public Object postResId(StatementQueryConditionDTO queryObject) {
        //根据tenantId和获取租户自定义报表配置
        Query query = Query.query(Criteria.where("statementCode").is(queryObject.getStatementCode())
                .and("tenantId").is(queryObject.getTenantId()));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(query, StatementFormAdapter.class, "statementFormAdapter");
        Map<String, String> resIdMap = new HashMap<>();
        if (null != statementFormAdapter) {
            //根据StatementFormAdapter
            List<StatementDynamicCondition> conditions = statementFormAdapter.getDynamicConditions();
            //新条件匹配
            Map<String, String> resIdMapNew = matchConditionNew(queryObject.getCondition(), conditions);
            if(!CollectionUtils.isEmpty(resIdMapNew)) {
                return resIdMapNew;
            }
            //遍历conditions找到匹配的条件
            resIdMap = matchCondition(queryObject.getCondition(), conditions);
        }
        if (CollectionUtils.isEmpty(resIdMap)) {
            //匹配系统级报表配置
            resIdMap = postSystemResId(queryObject.getStatementCode(), queryObject.getCondition(), queryObject.getTenantId());
        }
        return resIdMap;
    }

    private Map<String, String> postSystemResId(String statementCode, Map<String, Object> condition, String tenantId) {
        String tenantVersion = kmService.tenantVersion(tenantId);
        Query query = Query.query(Criteria.where("statementCode").is(statementCode).and("version").is(tenantVersion));
        StatementFormAdapterSystem statementFormAdapter = mongoTemplate.findOne(query, StatementFormAdapterSystem.class, "statementFormAdapter");
        if (null == statementFormAdapter) {
            return Collections.EMPTY_MAP;
        }
        //根据StatementFormAdapter
        List<StatementDynamicCondition> conditions = statementFormAdapter.getDynamicConditions();
        //新条件匹配
        Map<String, String> resIdMapNew = matchConditionSystem(condition, conditions);
        if(!CollectionUtils.isEmpty(resIdMapNew)) {
            return resIdMapNew;
        }
        //遍历conditions找到匹配的条件
        Map<String, String> resIdMap = matchCondition(condition, conditions);
        return resIdMap;
    }

    @Override
    public Object getDataCharacteristic(String tenantId, String statementCode) throws Exception {
        JSONArray jsonArray = getDataCharacteristicArray(statementCode);
        if (CollectionUtils.isEmpty(jsonArray)) {
            return returnObj(-1, I18nUtils.getValue("knowledgegraph.dataNotFound"), null);
        }
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),jsonArray);
    }

    @Override
    public Object postEditStyle(String tenantId, String date, String resId, String statementCode) throws DWBusinessException {
        String appCode = getAppCodeByStatementCode(statementCode);
        if (StringUtils.isEmpty(appCode)) {
            return returnObj(-1,I18nUtils.getValue("knowledgegraph.appCodeNotFound"),null);
        }
        //查询客制报表
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> customList = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : customList) {
            String existResId = statementDynamicCondition.getResId();
            if (resId.equals(existResId)) {
                statementDynamicCondition.setLastUpdateUserName(tenantId);
                statementDynamicCondition.setLastUpdateTime(date);
            }
        }
        Update update = new Update();
        update.set("dynamicConditions",customList);
        mongoTemplateUser.upsert(queryCustom,update,"statementFormAdapter");
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),null);
    }

    @Override
    public Object postCopyStyle(String tenantId, String workName, String resId, String statementCode, String lang) throws DWBusinessException {
        String appCode = getAppCodeByStatementCode(statementCode);
        log.info("dapUri:{}", dapUri);
        if (StringUtils.isEmpty(appCode)) {
            return returnObj(-1,I18nUtils.getValue("knowledgegraph.appCodeNotFound"),null);
        }
//        getUserName();
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid",resId);
        paramBody.put("rptname",workName);
        paramBody.put("program_id",statementCode);
        paramBody.put("app_id",appCode);
        String url = dapUri + COPY_CUSTOMIZE + "?@routerKey=" + getTenant();
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        url = addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
        String token = request.getHeader("token");
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-middleware-auth-user",token);
        String response = DataMapHttpUtil.post(url,paramBody.toJSONString(),headers);
        log.info("response---"+response);
        JSONObject responseJson = JSONObject.parseObject(response);
        if (responseJson == null) {
            return returnObj(-1,I18nUtils.getValue("knowledgegraph.copyStatementError"),null);
        }
        if (200 != responseJson.getInteger("status")) {
            return returnObj(responseJson.getInteger("status"),responseJson.getString("message"),null);
        }
        String newResId = responseJson.getString("data");
//        String newResId = UUID.randomUUID().toString();
        //查询客制报表
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        if (statementFormAdapter == null) {
            statementFormAdapter = new StatementFormAdapter();
            statementFormAdapter.setTenantId(tenantId);
            statementFormAdapter.setStatementCode(statementCode);
        }
        List<StatementDynamicCondition> customList = statementFormAdapter.getDynamicConditions();
        if (CollectionUtils.isEmpty(customList)) {
            customList = new ArrayList<>();
        }
        StatementDynamicCondition statementDynamicCondition = new StatementDynamicCondition();
        statementDynamicCondition.setType(1);
        statementDynamicCondition.setStatus(0);
        statementDynamicCondition.setResId(newResId);
        statementDynamicCondition.setLang(lang);
        statementDynamicCondition.setWorkName(workName);
        statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate(new Date(), DateUtils.PATTERN_RFC1123));
        statementDynamicCondition.setLastUpdateUserName(getUserName());
        statementDynamicCondition.setAppCode(appCode);
        customList.add(statementDynamicCondition);
        Update update = new Update();
        update.set("tenantId",tenantId);
        update.set("statementCode",statementCode);
        update.set("dynamicConditions",customList);
        mongoTemplateUser.upsert(queryCustom,update,"statementFormAdapter");
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),null);
    }

    @Override
    public Object postDeleteStyle(String tenantId, String resId, String statementCode) throws DWBusinessException {
        String appCode = getAppCodeByStatementCode(statementCode);
        if (StringUtils.isEmpty(appCode)) {
            return returnObj(-1,I18nUtils.getValue("knowledgegraph.appCodeNotFound"),null);
        }
        JSONObject paramBody = new JSONObject();
        paramBody.put("resid",resId);
        paramBody.put("program_id",statementCode);
        paramBody.put("app_id",appCode);
        String url = dapUri + DELETE_CUSTOMIZE + "?@routerKey=" + getTenant();
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        url = addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
        String token = request.getHeader("token");
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-middleware-auth-user",token);
        String response = DataMapHttpUtil.post(url,paramBody.toJSONString(),headers);
        log.info("response---"+response);
        JSONObject responseJson = JSONObject.parseObject(response);
        if (responseJson == null) {
            return returnObj(-1,I18nUtils.getValue("knowledgegraph.deleteStatementError"),null);
        }
        if (200 != responseJson.getInteger("status")) {
            return returnObj(responseJson.getInteger("status"),responseJson.getString("message"),null);
        }
        //查询客制报表
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> customList = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : customList) {
            String existResId = statementDynamicCondition.getResId();
            if (resId.equals(existResId)) {
                customList.remove(statementDynamicCondition);
                break;
            }
        }
        Update update = new Update();
        update.set("dynamicConditions",customList);
        mongoTemplateUser.upsert(queryCustom,update,"statementFormAdapter");
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),null);
    }

    @Override
    public Object getStyleList(String tenantId, String statementCode) throws Exception {
        String locale = AthenaUtils.getCurrentLocale();
        String version = kmService.tenantVersion();
        //根据statementCode和获取租户自定义报表配置
        Query queryPreinstall = Query.query(Criteria.where("code").is(statementCode).and("version").is(version));
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        //查询预设报表
        Activity tenantActivity = mongoTemplate.findOne(queryPreinstall, Activity.class,"activityConfigs");
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        Activity activityNeo4j = dataPickService.chooseOneWithSameCode(dataMapActivityDAO.getActivityByCodeAndVersion(statementCode, tenantVersion, tenantId));
        /*activityOld = new ActivityOld();
        activityOld.setCode("budgeReviewQuery");
        activityOld.setName("预算检讨");
        Map<String, Map<String, String>> hashMap = new HashMap();
        Map<String, String> nameLang = new HashMap<>();
        nameLang.put("zh_TW","預算檢討");
        nameLang.put("en_US","Budget Review Query");
        hashMap.put("name", nameLang);
        activityOld.setLang(hashMap);*/
        List<StatementDynamicCondition> preinstallList = getPreinstallList(tenantActivity, activityNeo4j, locale);
        if (CollectionUtils.isEmpty(preinstallList)) {
            return returnObj(-1, I18nUtils.getValue("knowledgegraph.statementStyleNotFound"), null);
        }
        //查询带条件的预设
        Query queryConditionalPreinstall = Query.query(Criteria.where("statementCode")
                .is(statementCode).and("version").is(tenantVersion));
        StatementFormAdapter conditionalPreinstallStatementFormAdapter = mongoTemplate.findOne(queryConditionalPreinstall, StatementFormAdapter.class, "statementFormAdapter");
        if (null != conditionalPreinstallStatementFormAdapter) {
            List<StatementDynamicCondition> conditionalPreinstallList = conditionalPreinstallStatementFormAdapter.getDynamicConditions();
            if (!CollectionUtils.isEmpty(conditionalPreinstallList)) {
                conditionalPreinstallList.forEach(item -> item.setType(0));
                preinstallList.addAll(conditionalPreinstallList);
            }
        }
        String appCode = getAppCodeByStatementCode(statementCode);
        //查询客制报表
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> customList = getCustomList(statementFormAdapter);
        if (!CollectionUtils.isEmpty(customList)) {
            preinstallList.addAll(customList);
        }
        JSONArray jsonArray = getDataCharacteristicArray(statementCode);
        renderDescription(preinstallList, jsonArray);
        return returnObj(200, I18nUtils.getValue("knowledgegraph.success"), preinstallList);
    }

    private void renderDescription(List<StatementDynamicCondition> preinstallList, JSONArray jsonArray) {
        if (!CollectionUtils.isEmpty(preinstallList)) {
            List<JSONObject> jsonObjectList = jsonArray.toJavaList(JSONObject.class);
            Map<String, String> map = new HashMap<>();
            if (!CollectionUtils.isEmpty(jsonObjectList)) {
                map = jsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("paramPath"), item -> item.getString("description")));
            }
            Map<String, String> finalMap = map;
            preinstallList.forEach(dynamicCondition -> {
                List<StatementFormMatcher> items = dynamicCondition.getItems();
                if (!(CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(finalMap))) {
                    items.forEach(item -> item.setDescription(finalMap.get(item.getParamPath())));
                }
            });
        }
    }

    @Override
    public Object postStylePublish(String tenantId, String workName, String resId, String statementCode, String lang, List<StatementFormMatcher> items) throws Exception {
        boolean isEditWorkName = false;
        //查询客制报表
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            if(resId.equals(statementDynamicCondition.getResId())) {
                if (statementDynamicCondition.getStatus() == 1) {
                    return returnObj(-1,I18nUtils.getValue("knowledgegraph.styleIspublished"),null);
                }
                if (!workName.equals(statementDynamicCondition.getWorkName())) {
                    isEditWorkName = true;
                }
                statementDynamicCondition.setStatus(1);
                statementDynamicCondition.setWorkName(workName);
                statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate(new Date(), DateUtils.PATTERN_RFC1123));
                statementDynamicCondition.setLastUpdateUserName(getUserName());
                if(!CollectionUtils.isEmpty(items)){
                    JSONArray dataCharacteristicArray =  getDataCharacteristicArray(statementCode);
                    Map<String, String> dataCharacteristicMap = dataCharacteristicArray2Map(dataCharacteristicArray);
                    for (StatementFormMatcher item : items) {
                        item.setDescription(dataCharacteristicMap.get(item.getParamPath()));
                    }
                }
                statementDynamicCondition.setItems(items);
            } else if (statementDynamicCondition.getStatus() == null || statementDynamicCondition.getLang() == null || statementDynamicCondition.getItems() == null) {
                continue;
            } else {
                if (statementDynamicCondition.getStatus() == 1 && lang.equals(statementDynamicCondition.getLang()) && compareItems(statementDynamicCondition.getItems(), items)) {
                    return returnObj(-1, I18nUtils.getValue("knowledgegraph.styleRepet"), null);
                }
            }
        }
        if (isEditWorkName) {
            String appCode = getAppCodeByStatementCode(statementCode);
            if (StringUtils.isEmpty(appCode)) {
                return returnObj(-1,I18nUtils.getValue("knowledgegraph.appCodeNotFound"),null);
            }
            JSONObject paramBody = new JSONObject();
            paramBody.put("resid",resId);
            paramBody.put("program_id",statementCode);
            paramBody.put("app_id",appCode);
            paramBody.put("rptname",workName);
            String url = dapUri + EDIT_WORKNAME_CUSTOMIZE + "?@routerKey=" + getTenant();
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            url = addUrlParamFromHeader(request, url, "@ReportKey", REPORT_KEY);
            String token = request.getHeader("token");
            Map<String, String> headers = new HashMap<>();
            headers.put("digi-middleware-auth-user",token);
            String response = DataMapHttpUtil.post(url,paramBody.toJSONString(),headers);
            log.info("response---"+response);
            JSONObject responseJson = JSONObject.parseObject(response);
            if (responseJson == null) {
                return returnObj(-1,I18nUtils.getValue("knowledgegraph.publishStatementError"),null);
            }
            if (200 != responseJson.getInteger("status")) {
                return returnObj(responseJson.getInteger("status"),responseJson.getString("message"),null);
            }
        }
        Update update = new Update();
        update.set("dynamicConditions",statementDynamicConditions);
        mongoTemplateUser.upsert(queryCustom,update,"statementFormAdapter");
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),null);
    }

    @SuppressWarnings("findsecbugs:CRLF_INJECTION_LOGS")
    private String addUrlParamFromHeader(HttpServletRequest request, String url, String urlParamKey, String headerKey) {
        String value = request.getHeader(headerKey);
        log.info("获取请求头参数headerKey：{}，value：{}", headerKey, value); //NOSONAR
        if (StringUtils.isNotEmpty(value)) {
            url += "&" + urlParamKey + "=" + value;
        }
        log.info("获取请求头参数url：{}", url); //NOSONAR
        return url;
    }

    @Override
    public Object postStyleUnPublish(String tenantId, String resId, String statementCode) {
        //查询客制报表
        Query queryCustom = Query.query(Criteria.where("statementCode").is(statementCode)
                .and("tenantId").is(tenantId));
        StatementFormAdapter statementFormAdapter = mongoTemplateUser.findOne(queryCustom, StatementFormAdapter.class, "statementFormAdapter");
        List<StatementDynamicCondition> statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            if(resId.equals(statementDynamicCondition.getResId())) {
                if (statementDynamicCondition.getStatus() != 1) {
                    return returnObj(-1,I18nUtils.getValue("knowledgegraph.styleIsUnPublish"),null);
                }
                statementDynamicCondition.setStatus(2);
                statementDynamicCondition.setLastUpdateTime(DateUtils.formatDate(new Date(), DateUtils.PATTERN_RFC1123));
                statementDynamicCondition.setLastUpdateUserName(getUserName());
            }
        }
        Update update = new Update();
        update.set("dynamicConditions",statementDynamicConditions);
        mongoTemplateUser.upsert(queryCustom,update,"statementFormAdapter");
        return returnObj(200,I18nUtils.getValue("knowledgegraph.success"),null);
    }

    /**
     * @Author yueyc
     * @Description 根据条件和现有匹配条件一一比对,返回匹配的匹配条件对应的resId Map(新)
     * @Date 15:28 2022/7/18
     * @Param
     * @return
     **/
    private Map<String, String> matchConditionNew(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        Map<String, String> resIdMap = new HashMap<>();
        for (int i = 0; i < conditions.size(); i++) {
            StatementDynamicCondition statementDynamicCondition = conditions.get(i);
            //只返回状态是发布中的
            if(statementDynamicCondition.getStatus() == null || statementDynamicCondition.getStatus() !=1) {
                continue;
            }
            List<StatementFormMatcher> matchers = statementDynamicCondition.getItems();
            if (CollectionUtils.isEmpty(matchers)) {
                resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
            } else {
                int count = 0;
                for (int j = 0; j < matchers.size(); j++) {
                    if (matchNew(matchers.get(j), condition)) {
                        count++;
                    } else {
                        break;
                    }
                }
                if (count == matchers.size() || matchers.size() == 0) {
                    resIdMap.put("resId_"+statementDynamicCondition.getLang(),statementDynamicCondition.getResId());
                }
            }
        }
        return resIdMap;
    }

    private Map<String, String> matchConditionSystem(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        Map<String, String> resIdMap = new HashMap<>();
        for (int i = 0; i < conditions.size(); i++) {
            StatementDynamicCondition statementDynamicCondition = conditions.get(i);
            List<StatementFormMatcher> matchers = statementDynamicCondition.getItems();
            if (CollectionUtils.isEmpty(matchers)) {
                resIdMap.put("resId_" + statementDynamicCondition.getLang(), statementDynamicCondition.getResId());
            } else {
                int count = 0;
                for (int j = 0; j < matchers.size(); j++) {
                    if (matchNew(matchers.get(j), condition)) {
                        count++;
                    } else {
                        break;
                    }
                }
                if (count == matchers.size() || matchers.size() == 0) {
                    resIdMap.put("resId_"+statementDynamicCondition.getLang(),statementDynamicCondition.getResId());
                }
            }
        }
        return resIdMap;
    }

    /**
     * @Author zhuangli
     * @Description 根据条件和现有匹配条件一一比对,返回匹配的匹配条件对应的resId Map
     * @Date 11:28 2022/2/17
     * @Param
     * @return
     **/
    private Map<String, String> matchCondition(Map<String, Object> condition, List<StatementDynamicCondition> conditions) {
        for (int i = 0; i < conditions.size(); i++) {
            List<StatementFormMatcher> matchers = conditions.get(i).getItems();
            if (CollectionUtils.isEmpty(matchers)) {
                return conditions.get(i).getResIdMap();
            }
            int count = 0;
            for (int j = 0; j < matchers.size(); j++) {
                if (match(matchers.get(j), condition)) {
                    count++;
                } else {
                    break;
                }
            }
            if (count == matchers.size() || matchers.size() == 0) {
                return conditions.get(i).getResIdMap();
            }
        }
        return Collections.EMPTY_MAP;
    }


    /**
     * @Author yueyc
     * @Description 匹配一个条件
     * @Date 16:03 2022/7/18
     * @Param
     * @return
     **/
    private boolean matchNew(StatementFormMatcher statementFormMatcher, Map<String, Object> condition) {
        //根据当前matcher的操作符做相应处理
        String operator = statementFormMatcher.getOperator();
        String valueType = statementFormMatcher.getValueType().toUpperCase();
        String value = statementFormMatcher.getValue();
        String param;
        try {
            param = JsonPath.read(condition, statementFormMatcher.getParamPath());
        } catch (Exception e) {
            log.warn("获取请求参数错误:{}", statementFormMatcher.getParamPath());
            return false;
        }
        switch (operator) {
            case "EQUAL":
                switch (valueType) {
                    case "STRING":
                        return value.equals(param);
                    case "INTEGER":
                        return Integer.parseInt(value) == Integer.parseInt(param);
                    case "LONG":
                        return Long.parseLong(value) == Long.parseLong(param);
                    case "DOUBLE":
                        return Double.parseDouble(value) == Double.parseDouble(param);
                    default:
                        throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + valueType);
                }
            case "START_WITH":
                switch (valueType) {
                    case "STRING":
                        return param.startsWith(value);
                    default:
                        throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + valueType);
                }
            default:
                throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + operator);
        }
    }

    private boolean compareItems(List<StatementFormMatcher> list1, List<StatementFormMatcher> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int count = 0;
        for (StatementFormMatcher statementFormMatcher1 : list1) {
            String paramPath1 = statementFormMatcher1.getParamPath();
            String value1 = statementFormMatcher1.getValue();
            for (StatementFormMatcher statementFormMatcher2 : list2) {
                String paramPath2 = statementFormMatcher2.getParamPath();
                String value2 = statementFormMatcher2.getValue();
                if (paramPath2.equals(paramPath1) && value2.equals(value1)) {
                    count ++;
                }
            }
        }
        if (list1.size() == count) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @Author zhuangli
     * @Description 匹配一个条件
     * @Date 11:29 2022/2/17
     * @Param
     * @return
     **/
    private boolean match(StatementFormMatcher statementFormMatcher, Map<String, Object> condition) {
        //根据当前matcher的操作符做相应处理
        String operator = statementFormMatcher.getOperator();
        String valueType = statementFormMatcher.getValueType().toUpperCase();
        String value = statementFormMatcher.getValue();
        String param;
        try {
            param = JsonPath.read(condition, statementFormMatcher.getParamPath());
        } catch (PathNotFoundException pathNotFoundException) {
            log.warn("pathNotFoundException for paramPath:{}", statementFormMatcher.getParamPath());
            return false;
        }
        catch (ClassCastException classCastException) {
            log.error("classCastException for paramPath:{}, condition:{}", statementFormMatcher.getParamPath(), JsonUtil.toJsonString(condition));
            return false;
        }
        catch (Exception exception) {
            log.error("exception for paramPath:{}, condition:{}", statementFormMatcher.getParamPath(), JsonUtil.toJsonString(condition));
            return false;
        }
        switch (operator) {
            case "EQUAL":
                switch (valueType) {
                    case "STRING":
                        return value.equals(param);
                    case "INTEGER":
                        return Integer.parseInt(value) == Integer.parseInt(param);
                    case "LONG":
                        return Long.parseLong(value) == Long.parseLong(param);
                    case "DOUBLE":
                        return Double.parseDouble(value) == Double.parseDouble(param);
                    default:
                        throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + valueType);
                }
            case "START_WITH":
                switch (valueType) {
                    case "STRING":
                        return param.startsWith(value);
                    default:
                        throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + valueType);
                }
            default:
                throw new StatementMatchException(I18nUtils.getValue("knowledgegraph.dataTypeNotSupport") + operator);
        }
    }

    private List<StatementDynamicCondition> getPreinstallList(Activity activity, Activity activityNeo4j, String locale) {
        if (activity == null || null == activityNeo4j) {
            return Collections.emptyList();
        }
        Map<String, Object> pages = activity.getPages();
        if (pages == null) {
            return Collections.emptyList();
        }
        JSONObject pagesJson = new JSONObject(pages);
        JSONObject detailJson = pagesJson.getJSONObject("condition-detail");
        if (detailJson == null) {
            return Collections.emptyList();
        }
        JSONObject extendedFields = detailJson.getJSONObject("extendedFields");
        if (extendedFields == null) {
            return Collections.emptyList();
        }
        List<StatementDynamicCondition> statementDynamicConditions = new ArrayList<>();
        for (String key : extendedFields.keySet()) {
            StatementDynamicCondition statementDynamicCondition = new StatementDynamicCondition();
            Map<String, String> nameLang = CollectionUtils.isEmpty(activity.getLang()) ? Collections.EMPTY_MAP : activity.getLang().get("name");
            if (key.contains("zh_CN")) {
                statementDynamicCondition.setLang("zh_CN");
            }else if (key.contains("zh_TW")) {
                statementDynamicCondition.setLang("zh_TW");
            }else if (key.contains("en_US")) {
                statementDynamicCondition.setLang("en_US");
            }else {
                continue;
            }
            statementDynamicCondition.setResId(extendedFields.getString(key));
            statementDynamicCondition.setStatus(1);
            statementDynamicCondition.setType(0);
            statementDynamicCondition.setWorkName(StringUtils.isEmpty(nameLang.get(locale)) ? activity.getName() : nameLang.get(locale));
            statementDynamicConditions.add(statementDynamicCondition);
        }
        return statementDynamicConditions;
    }

    private List<StatementDynamicCondition> getCustomList(StatementFormAdapter statementFormAdapter) {
        Date now = new Date();
        if (statementFormAdapter == null) {
            return null;
        }
        List<StatementDynamicCondition> statementDynamicConditions = statementFormAdapter.getDynamicConditions();
        List<StatementDynamicCondition> returnStatementDynamicConditions = statementDynamicConditions.stream().filter(
                s -> !StringUtils.isEmpty(s.getResId())).collect(Collectors.toList()
        );
        returnStatementDynamicConditions.stream().forEach(s -> {
            if ((now.getTime() - DateUtils.parseDate(s.getLastUpdateTime()).getTime()) < 3000) {
                s.setHighLight(true);
            }
            s.setLastUpdateTime(DateUtils.formatDate(DateUtils.parseDate(s.getLastUpdateTime()),"yyyy/MM/dd"));
        }
        );
        return sortCustomList(returnStatementDynamicConditions);
    }

    private List<StatementDynamicCondition> sortCustomList(List<StatementDynamicCondition> statementDynamicConditions) {
        Map<String, List<StatementDynamicCondition>> map = new LinkedHashMap<>();
        for (StatementDynamicCondition statementDynamicCondition : statementDynamicConditions) {
            String workName = statementDynamicCondition.getWorkName();
            if (map.containsKey(workName)) {
                List<StatementDynamicCondition> statementDynamicConditionsExist = map.get(workName);
                statementDynamicConditionsExist.add(statementDynamicCondition);
                map.put(workName,statementDynamicConditionsExist);
            } else {
                List<StatementDynamicCondition> statementDynamicConditionsNotExist = new ArrayList<>();
                statementDynamicConditionsNotExist.add(statementDynamicCondition);
                map.put(workName,statementDynamicConditionsNotExist);
            }
        }
        List<StatementDynamicCondition> newStatementDynamicConditions = new ArrayList<>();
        for (String workName : map.keySet()) {
            newStatementDynamicConditions.addAll(map.get(workName));
        }
        return newStatementDynamicConditions;
    }

    private String getAppCodeByStatementCode(String statementCode) throws DWBusinessException {
        ApplicationRelation applicationRelation = dataPickService.findOneByCondition(Criteria.where("code").is(statementCode), ApplicationRelation.class, "applicationRelation");
        if (applicationRelation != null) {
            return applicationRelation.getAppCode();
        } else {
            return null;
        }
    }

    private List<String> getActionIdsByActivity(Activity activity) {
        if (activity == null) {
            return null;
        }
        Map<String, Object> pages = activity.getPages();
        if (pages == null) {
            return null;
        }
        JSONObject pagesJson = new JSONObject(pages);
        JSONObject detailJson = pagesJson.getJSONObject("condition-detail");
        if (detailJson == null) {
            return null;
        }
        JSONArray submitActions = detailJson.getJSONArray("submitActions");
        if (submitActions == null) {
            return null;
        }
        List<String> actionIds = new ArrayList<>();
        for (int i=0; i<submitActions.size(); i++) {
            JSONObject action = submitActions.getJSONObject(i);
            String actionId = action.getString("actionId");
            actionIds.add(actionId);
        }
        return actionIds;
    }

    private Map<String, String> dataCharacteristicArray2Map(JSONArray jsonArray) {
        Map<String, String> map = new HashMap<>();
        for (int i=0;i<jsonArray.size();i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            map.put(jsonObject.getString("paramPath"),jsonObject.getString("description"));
        }
        return map;
    }

    private String getUserName(){
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        return  (String) profile.getOrDefault("userName", "");
    }

    private String getTenant(){
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        return  (String) profile.getOrDefault("tenantId", "");
    }

    private JSONArray getDataCharacteristicArray(String statementCode) throws Exception {
        String version = kmService.tenantVersion();
        //根据statementCode和获取租户自定义报表配置
        Query queryPreinstall = Query.query(Criteria.where("code").is(statementCode).and("version").is(version));
        //查询预设报表
        Activity tenantActivity = mongoTemplate.findOne(queryPreinstall, Activity.class,"activityConfigs");
        List<String> actionIds = getActionIdsByActivity(tenantActivity);
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtils.isEmpty(actionIds)) {
            return jsonArray;
        }
        for (String actionId : actionIds) {
            GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO) dataMapActionService.getMetadata(actionId);
            List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS = actionLocaleResponseDTO.getRequest().getParameters();
            for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO : apiDataFieldLocaleMetadataDTOS) {
                List<ApiDataFieldLocaleMetadataDTO> apiDataFieldLocaleMetadataDTOS1 = apiDataFieldLocaleMetadataDTO.getField();
                if (CollectionUtils.isEmpty(apiDataFieldLocaleMetadataDTOS1)) {
                    continue;
                }
                //批量查询出字典值
                List<String> enumKeys = apiDataFieldLocaleMetadataDTOS1.stream().map(ApiDataFieldLocaleMetadataDTO::getEnum_key).filter(StringUtils::isNoneBlank).collect(Collectors.toList());
                Map<String, List<Map<String,String>>> dictMaps = getDictsByEnumkeys(enumKeys);
                for (ApiDataFieldLocaleMetadataDTO apiDataFieldLocaleMetadataDTO1 : apiDataFieldLocaleMetadataDTOS1) {
                    JSONObject jsonObject = new JSONObject();
                    String paramPath = apiDataFieldLocaleMetadataDTO1.getData_name();
                    String description = apiDataFieldLocaleMetadataDTO1.getDescription();
                    String enumKey = apiDataFieldLocaleMetadataDTO1.getEnum_key();
                    jsonObject.put("paramPath",paramPath);
                    jsonObject.put("description",description);
                    jsonArray.add(jsonObject);
                    //组装字典值
                    Optional.ofNullable(enumKey).map(dictMaps::get).ifPresent(options->{
                        jsonObject.put("options",options);
                    });
                }
            }
        }
        return jsonArray;
    }

    private Object returnObj(Integer code, String message, Object object) {
        Map<String, Object> result = new HashMap<>();
        result.put("code",code);
        result.put("message",message);
        result.put("list",object);
        return result;
    }

    public static void main(String[] args) {
    }

    @Override
    public Object getABIReportUser(String startDate, String endDate) throws DWBusinessException {

        return this.dataMapReportManager.getABIReportUserStatistics(startDate, endDate);
    }

    /**
     * 批量查询出字典值
     * @param enumKeys
     * @return  Map<String, List<Dictionary>>
     * @throws DWBusinessException
     */
    private Map<String, List<Map<String,String>>> getDictsByEnumkeys(List<String> enumKeys) throws DWBusinessException {
        if (CollectionUtils.isEmpty(enumKeys)) {
            return Maps.newHashMap();
        }
        Object dict = dataMapDictService.postFindDictByKeyList(enumKeys);
        if (null == dict) {
            return Maps.newHashMap();
        }
        return ((Map<String, List<Dictionary>>) dict).entrySet().stream()
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        e -> e.getValue().stream()
                                .map(t -> ImmutableMap.of(
                                        "value", t.getCode(),
                                        "title", t.getValue(),
                                        "desc", t.getDesc(),
                                        "key", t.getKey()
                                )).collect(Collectors.toList())
                ));
    }
}
