package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.datamap.service.IWorkbenchSettingService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 15:31
 **/
@MyExceptionHandler
@Service
@Slf4j
public class DataMapWorkbenchSettingService implements IWorkbenchSettingService {

    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;

    @Autowired
    private DataMapTaskFieldService dataMapTaskFieldService;

    @Autowired
    private DataPickService dataPickService;

    @Autowired
    private DataMapViewService dataMapViewService;

    @Autowired
    private KmGeneralService kmGeneralService;

    @Autowired
    private DatamapCacService datamapCacService;

    @Override
    public WorkbenchSettingVO getWorkbenchSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) throws DWException {
        WorkbenchSettingVO workbenchSettingVO;
        String tenantId = ServiceUtils.getTenantId();
        if (pageCode == WSPageCode.task && configType == WSConfigType.groups) {
            workbenchSettingVO = new WorkbenchSettingVO();
            workbenchSettingVO.setTenantId(tenantId);
            workbenchSettingVO.setPageCode(pageCode);
            workbenchSettingVO.setConfigType(configType);
            ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
            List<WSConditionVO> defaultCondition;
            CardGroup cardGroup = knowledgeGraphService.findOne(Filters.eq("tenantId", tenantId), CardGroup.class, "cardGroup", KnowledgeGraphDb.TENANT);
            if (null == cardGroup) {
                List<CardGroupGroup> cardGroupGroups = dataMapTaskFieldService.sysCardGroups(tenantId);
                if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                    List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(cardGroupGroups);
                    wsConditionVOS.addAll(sysConditions);
                }
                if (Boolean.TRUE.equals(appCondition)) {

                    String tenantVersion = dataPickService.tenantVersion(tenantId);
                    // 获取租户所有应用的任务
                    List<String> authApps = datamapCacService.getAuthorizationsApplication(tenantId);
                    List<ApplicationRelation> taskRelations = knowledgeGraphService.find(
                            Filters.and(Filters.in("appCode", authApps),
                                    Filters.eq("type", "activity"),
                                    Filters.eq("version", tenantVersion)),
                            ApplicationRelation.class, "applicationRelation", KnowledgeGraphDb.SYSTEM);
                    List<String> taskCodes = taskRelations.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
                    Map<String, ApplicationRelation> taskRelationsMap = new HashMap<>();
                    taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), applicationRelation));
                    ViewRequest viewRequest = new ViewRequest();
                    viewRequest.setQuery(MapUtil.of("code", taskCodes));
                    List<WSConditionDTO> appConditions = dataMapViewService.postNewCardConfig(viewRequest);
                    if (CollectionUtil.isNotEmpty(appConditions)) {
                        Map<String, List<WSConditionDTO>> conditionMap = appConditions.stream().collect(Collectors.groupingBy(WSConditionDTO::getAliasCode));
                        for (Map.Entry<String, List<WSConditionDTO>> entry : conditionMap.entrySet()) {
                            List<WSConditionDTO> conditionVOS = entry.getValue();
                            WSConditionDTO wsConditionVO = conditionVOS.stream().min(Comparator.comparing(WSConditionDTO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).get();
                            wsConditionVO.setAppCode(taskRelationsMap.get(wsConditionVO.getTaskCode()).getAppCode());
                            List<ConditionScopeDTO> scopeVOList = conditionVOS.stream()
                                    .flatMap(v -> v.getConditionScope().stream())
                                    .distinct()
                                    .sorted(Comparator.comparing(ConditionScopeDTO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeDTO::getId,
                                            Comparator.nullsLast(Comparator.naturalOrder())))
                                    .collect(Collectors.toList());
                            for (ConditionScopeDTO conditionScopeVO : scopeVOList) {
                                ApplicationRelation applicationRelation = taskRelationsMap.get(conditionScopeVO.getCode());
                                if (applicationRelation != null) {
                                    conditionScopeVO.setAppName(applicationRelation.getAppName());
                                    conditionScopeVO.setAppCode(applicationRelation.getAppCode());
                                }
                            }
                            kmGeneralService.handleLang(scopeVOList);
                            wsConditionVO.setConditionScope(scopeVOList);
                            wsConditionVOS.add(dataPickService.convert(wsConditionVO, WSConditionVO.class));
                        }
                    }
                }
                defaultCondition = wsConditionVOS.stream()
                        .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                        .map(v -> {
                            WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                            if (wsConditionVO.getSourceType() == SourceType.customer) {
                                wsConditionVO.setEnable(false);
                            }
                            return wsConditionVO;
                        })
                        .collect(Collectors.toList());
                workbenchSettingVO.setCondition(wsConditionVOS);
                workbenchSettingVO.setDefaultCondition(defaultCondition);
            } else {
                workbenchSettingVO = dataMapTaskFieldService.cardGroupToWSConditionVO(cardGroup);
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                Map<String, Map<String, String>> lang = wsConditionVO.getLang();
                if (lang != null) {
                    Map<String, String> aliasName = lang.get("aliasName");
                    if (aliasName == null) {
                        wsConditionVO.setLang(MapUtil.of("aliasName", wsConditionVO.getLang().get("name")));
                    }
                }
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getDefaultCondition()) {
                Map<String, Map<String, String>> lang = wsConditionVO.getLang();
                if (lang != null) {
                    Map<String, String> aliasName = lang.get("aliasName");
                    if (aliasName == null) {
                        wsConditionVO.setLang(MapUtil.of("aliasName", wsConditionVO.getLang().get("name")));
                    }
                }
            }
            kmGeneralService.handleLang(workbenchSettingVO.getCondition());
            kmGeneralService.handleLang(workbenchSettingVO.getDefaultCondition());
        } else {
            WorkbenchSetting workbenchSetting = knowledgeGraphService.findOne(
                    Filters.and(
                            Filters.eq("tenantId", tenantId),
                            Filters.eq("pageCode", pageCode.name()),
                            Filters.eq("configType", configType.name())),
                    WorkbenchSetting.class, "workbenchSetting", KnowledgeGraphDb.TENANT);
            if (workbenchSetting == null) {
                workbenchSettingVO = getCardSetting(pageCode, configType, appCondition);
            } else {
                workbenchSettingVO = JSON.parseObject(JSON.toJSONString(workbenchSetting), WorkbenchSettingVO.class);

            }
            kmGeneralService.handleLang(workbenchSettingVO.getCondition());
            kmGeneralService.handleLang(workbenchSettingVO.getDefaultCondition());
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                kmGeneralService.handleLang(wsConditionVO.getConditionScope());
            }
        }
        return workbenchSettingVO;
    }

    /**
     * 调用dataMap查询开发平台配置的条件
     * @param pageCode
     * @param configType
     * @param appCondition 是否查应用级别配置
     * @return
     */
    public WorkbenchSettingVO getCardSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) throws DWException {
        String tenantId;
        List<String> authApps;
        try {
            tenantId = ServiceUtils.getTenantId();
            authApps = datamapCacService.getAuthorizationsApplication(tenantId);
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setConfigType(configType);
        workbenchSettingVO.setPageCode(pageCode);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
        String tenantVersion = dataPickService.tenantVersion(tenantId);
        // 查询系统级的条件配置
        if (WSPageCode.task == pageCode) {
            if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskOrderWSConditionVO);
            }
        } else if (WSPageCode.project == pageCode) {
            if (WSConfigType.groups == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectGroupWSConditionVO);
            } else if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectOrderWSConditionVO);
            }
        }
        if (Boolean.TRUE.equals(appCondition)) {
            String type = null;
            if (WSPageCode.task == pageCode) {
                type = "activity";
            } else if (WSPageCode.project == pageCode) {
                type = "task";
            }
            List<ApplicationRelation> taskRelations = knowledgeGraphService.find(
                    Filters.and(
                            Filters.in("appCode", authApps),
                            Filters.eq("type", type),
                            Filters.eq("version", tenantVersion)),
                    Projections.include("code", "appName"),
                    ApplicationRelation.class, "applicationRelation", KnowledgeGraphDb.SYSTEM);
            if (CollectionUtil.isNotEmpty(taskRelations)) {
                Map<String, ApplicationRelation> applicationNameMap = new HashMap<>();
                taskRelations.forEach(applicationRelation -> {
                    applicationNameMap.put(applicationRelation.getCode(), applicationRelation);
                });
                List<String> codeList = taskRelations.stream().map(v -> v.getCode()).distinct().collect(Collectors.toList());
                WorkbenchSettingRequest request = new WorkbenchSettingRequest();
                request.setCode(codeList);
                request.setConfigType(configType);
                request.setPageCode(pageCode);
                List<WSConditionDTO> customerConditionVOS = dataMapViewService.postWorkbenchSetting(request);
                if (!customerConditionVOS.isEmpty()) {
                    Map<String, List<WSConditionDTO>> conditionMap = customerConditionVOS.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                    for (Map.Entry<String, List<WSConditionDTO>> entry : conditionMap.entrySet()) {
                        WSConditionDTO wsConditionVO;
                        List<WSConditionDTO> wsConditionDTOS = entry.getValue();
                        if (wsConditionDTOS.size() > 1) {
                            wsConditionVO = wsConditionDTOS.stream().sorted(Comparator.comparing(WSConditionDTO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                            wsConditionVO.setConditionScope(wsConditionDTOS.stream()
                                    .flatMap(v -> v.getConditionScope().stream())
                                    .distinct()
                                    .sorted(Comparator.comparing(ConditionScopeDTO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeDTO::getId,
                                            Comparator.nullsLast(Comparator.naturalOrder())))
                                    .collect(Collectors.toList()));
                            String dataType = null;
                            for (String s : Arrays.asList("boolean", "date", "select", "string", "number")) {
                                if (wsConditionDTOS.stream().anyMatch(v -> s.equals(v.getDataType()))) {
                                    dataType = s;
                                    break;
                                }
                            }
                            if (dataType != null) {
                                wsConditionVO.setDataType(dataType);
                            }
                        } else {
                            wsConditionVO = wsConditionDTOS.get(0);
                        }
                        for (ConditionScopeDTO conditionScopeVO : wsConditionVO.getConditionScope()) {
                            ApplicationRelation applicationRelation = applicationNameMap.get(conditionScopeVO.getCode());
                            if (applicationRelation != null) {
                                conditionScopeVO.setAppCode(applicationRelation.getAppCode());
                                conditionScopeVO.setAppName(applicationRelation.getAppName());
                            }
                        }
                        wsConditionVOS.add(dataPickService.convert(wsConditionVO, WSConditionVO.class));
                    }

                }
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream()
                .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                .map(v -> {
                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                    if (wsConditionVO.getSourceType() == SourceType.customer) {
                        wsConditionVO.setEnable(false);
                    }
                    return wsConditionVO;
                })
                .collect(Collectors.toList());
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        workbenchSettingVO.setCondition(wsConditionVOS);
        return workbenchSettingVO;
    }
}
