package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.ErpAdapter;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;

//import com.digiwin.athena.datamap.domain.app.AppRelation2;
//import com.digiwin.athena.datamap.domain.core.*;
//import com.digiwin.athena.datamap.domain.erp.*;
//import com.digiwin.athena.datamap.domain.flow.FlowGraph;
//import com.digiwin.athena.datamap.domain.view.PageView;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.datamap.service.IErpService;
import com.digiwin.athena.datamap.service.inner.DataMapHelpService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.*;
import com.digiwin.athena.datamap.utils.CommonUtils;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.idrive.neo4j.Neo4j1Config;
import com.digiwin.athena.idrive.neo4j.Neo4j2Config;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.datamap.utils.DataMapUtils;
//import com.digiwin.athena.knowlegegraph.entity.ApplicationRelation;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.approve.ApproveDecision;
import com.digiwin.athena.domain.core.approve.ApproveDecisionVariable;
import com.digiwin.athena.domain.core.approve.ApproveInfo;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.erp.*;
import com.digiwin.athena.dto.AppRelation2;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.common.AttachmentType;
import com.google.gson.Gson;
import io.seata.common.util.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.bson.Document;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-06-13 14:35
 **/
@Lang
@MyExceptionHandler
@Service
@Slf4j
public class ErpService implements IErpService {

    public static final String applicationTemplate = "DDSM";
    public static final String uibootcachePattern = "uibot:cache:*";
    public static final String separator = "-";

    @Autowired(required = false)
    @Qualifier("dataMapTenant")
    private MongoTemplate mongoTemplate;

    @Autowired
    PluginService pluginService;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired(required = false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactory1;

    @Autowired(required = false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactory2;

    @Autowired
    DataMapTagSystemService dataMapTagSystemService;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    DataMapHelpService dataMapHelpService;

    @Autowired
    MdcService mdcService;

    @Autowired
    private List<ErpAdapter> erpAdapters;

    @Autowired
    DdsmService ddsmService;

    @Autowired
    GenericService genericService;

    @Autowired
    DataMapActionService dataMapActionService;
    
    @Autowired
    KmService kmService;

    @Autowired
    DatamapAppService datamapAppService;

    private static final String ICD = "ICD";

    @Override
    public Object postSync(ErpSyncBill bill) throws DWException {
        Map<String, Object> resp = new HashMap<>();
        if (log.isInfoEnabled()) {
            log.info("begin to sync erp config bill:{}", bill);
        }
        String tenantId = ServiceUtils.getTenantId();
        // String uid = bill.getProgram_id()+separator+bill.getDoc_type()+separator+bill.getOrg_type()+separator+bill.getOrg_code();
        // uid = uid.replaceAll("\\.","");
        String uid = bill.getProjectCode();
        if (null == uid) {
            throw new DWArgumentException("projectCode", I18nUtils.getValue("datamap.erp.projectEmpty"));
        }
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("recordId").is(uid));
        ErpSyncRecord event = mongoTemplate.findOne(query, ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
        initBill(bill, event);
        if (event == null) {
            event = new ErpSyncRecord();
            event.setRecordId(uid);
            event.setPluginId(uid);
            event.setTenantId(tenantId);
            event.setCreateTime(System.currentTimeMillis());
            event.setBill(bill);
            event.setStatus(1);
            event.setProjectCode(uid);
            event.setApproveTaskCode(uid + "_Approve");
            event.setTaskActionId(uid + "_taskQueryDataAction"); // 只能固定死后缀了，不然也无法区分哪个是task的哪个是action的
            event.setProjectActionId(uid + "_projectQueryDataAction");
            createData(event);
        } else {
            updateData(event, bill);
            // 更新的时候发现没有应用关系就创建
            List<String> codes = kmService.getCodeByTypeAndAppCode("task", "EAS");
            if (CollectionUtils.isEmpty(codes) || (CollectionUtils.isNotEmpty(codes) && !codes.contains(event.getProjectCode()))) {
                List<AppRelation2> applicationRelationList = new ArrayList<>();
                saveDdsmApplicationRelation(applicationRelationList, event.getProjectCode(), "task");
                saveDdsmApplicationRelation(applicationRelationList, event.getApproveTaskCode(), "activity");
                if (CollectionUtils.isNotEmpty(applicationRelationList)) {
                    AppRelationBatchPo po= new AppRelationBatchPo();
                    List<ApplicationRelation> list2 = JSON.parseArray(JSON.toJSONString(applicationRelationList),ApplicationRelation.class);
                    po.setList(list2);
                    datamapAppService.postApplicationRelationByDDSM(po);
                }
            }
        }
        checkPrimaryDetail(event);
        event.setStatus(1);
        event.setFormData(fillFormData(bill));
        mongoTemplate.save(event, tenantCol(ErpSyncRecord.class));

        updateApprove(event);

        updateActions(event);

        updateTags(event);

        if (log.isInfoEnabled()) {
            log.info("sync success");
        }
        resp.put("projectCode", event.getProjectCode());
        resp.put("recordId", uid);
        resp.put("success", true);

        mongoTemplate.updateFirst(query, Update.update("status", 2), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));

        return resp;
    }

    /**
     * 该接口用于刷新mongo库中历史数据
     * @return
     * @throws DWException
     */
    @Override
    public Object postUpdatePageView(List<String> list) throws DWException {
        // 定义每批次的大小
        int batchSize = 100;
        // 定义查询条件（这里我们查询所有文档，可以根据需要添加条件）
        Query query = new Query();
        // 如果list有值，则给query再加查询条件:projectCode=list里的值
        if (list != null && !list.isEmpty()) {
            Criteria criteria = Criteria.where("projectCode").in(list);
            query.addCriteria(criteria);
        }
        // 初始化分页参数
        int page = 0;
        boolean hasMoreData = true;

        // 循环直到所有数据都被处理
        while (hasMoreData) {
            // 创建分页请求
            Pageable pageable = PageRequest.of(page, batchSize);
            query.with(pageable);
            // 执行查询
            List<ErpSyncRecord> batch = mongoTemplate.find(query, ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
            // 检查是否还有更多的数据
            hasMoreData = batch.size() == batchSize;
            // 处理当前批次的数据
            processBatch(batch);
            // 增加页码
            page++;
        }
        return null;
    }

    /**
     * 处理每批次文档的逻辑
     * @param batch
     */
    private void processBatch(List<ErpSyncRecord> batch) {
        // 逻辑处理
        log.warn("Processing batch with " + batch.size() + " documents");
        for (ErpSyncRecord event : batch) {
            // 添加逻辑处理代码
            if (null == event || StringUtils.isEmpty(event.getProjectCode()) || null == event.getBill() || null == event.getBill().getEntity() || event.getBill().getEntity().getDetail().isEmpty()) {
                continue;
            }
            String projectCode = event.getProjectCode();
            Query query = Query.query(Criteria.where("code").is(projectCode + "_Approve"));
            List<Document> pageViews = mongoTemplate.find(query, Document.class, tenantCol(PageView.class));
            if (CollectionUtils.isNotEmpty(pageViews)) {
                List<ErpEntity> detail = event.getBill().getEntity().getDetail();
                List<Map<String, Object>> taskGridSettings = new ArrayList<>(); // 任务详情gridsetting
                List<Map<String, Object>> projectGridSettings = new ArrayList(); // 项目详情gridsetting
                for (ErpEntity entity : detail) {
                    Map<String, Object> taskGridsettingObj = new HashMap<>();
                    Map<String, Object> projectGridsettingObj = new HashMap();
                    taskGridsettingObj.put("gridPath", "task_query_data");
                    taskGridsettingObj.put("gridSchema", entity.getEntity_key());
                    taskGridsettingObj.put("height", "220");
                    taskGridSettings.add(taskGridsettingObj);
                    projectGridsettingObj.put("gridPath", "project_query_data");
                    projectGridsettingObj.put("gridSchema", entity.getEntity_key());
                    projectGridsettingObj.put("height", "220");
                    projectGridSettings.add(projectGridsettingObj);
                }
                for (Document document : pageViews) {
                    try {
                        Map pagesMap = MapUtils.getMap(document, "pages", null);
                        if (null != pagesMap) {
                            Map taskDetailMap = MapUtils.getMap(pagesMap, "task-detail", null);
                            Map projectDetailMap = MapUtils.getMap(pagesMap, "project-detail", null);
                            if (MapUtils.isNotEmpty(taskDetailMap)) {
                                // task-detail添加组装参数
                                buildGridsettings(taskDetailMap, taskGridSettings);
                            }
                            if (MapUtils.isNotEmpty(projectDetailMap)) {
                                // project-detail添加组装参数
                                buildGridsettings(projectDetailMap, projectGridSettings);
                            }
                        }
                        mongoTemplate.save(document, tenantCol(PageView.class));
                    } catch (Exception e) {
                        String code = MapUtils.getString(document, "code", null);
                        log.warn("updatePageView fail,code:{},error:{}", code, e);
                    }
                }
            }
        }
    }

    private String tenantCol(Class c) {
        return dataPickService.tenantCol(c);
    }

    private void buildGridsettings(Map taskDetailMap, List<Map<String, Object>> gridSettings) {
        // Object dataStatesObj = MapUtils.getObject(taskDetailMap,"dataStates",null);
        List<Map<String, Object>> dataStates = (List<Map<String, Object>>) taskDetailMap.getOrDefault("dataStates", null);
        if (null != dataStates) {
            dataStates.forEach(dataState -> dataState.put("gridSettings", gridSettings));
        }
    }

    @Override
    public Object postUpdate(ErpSyncRecord record) throws DWException {

        Map<String, Object> resp = new HashMap<>();

        String locale = ServiceUtils.getCurrentLocale();
        if (null == locale) {
            locale = "zh_CN";
        }

        checkPrimaryDetail(record);

        updateApprove(record);

        updateActions(record);

        updateTags(record);

        updatePageViewByRecord(record, locale);

        record.setUpdateTime(System.currentTimeMillis());
        mongoTemplate.save(record, tenantCol(ErpSyncRecord.class));

        Map<String, Object> ddsmParam = new HashMap<>();
        Map<String, Object> projectParam = new HashMap<>();
        projectParam.put("projectCode", record.getProjectCode());
        ddsmParam.put("project", projectParam);
        ddsmService.ddsmSync(ddsmParam);

        return resp;
    }

    @Override
    public List getRecords() throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        List<ErpSyncRecord> records =
                mongoTemplate.find(Query.query(Criteria.where("tenantId").is(tenantId)).with(Sort.by(Sort.Direction.ASC, "bill.program_id")), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
        return records;
    }

    @Override
    public Object getRecord(String code) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        ErpSyncRecord record = mongoTemplate.findOne(Query.query(Criteria.where("tenantId").is(tenantId).and("projectCode").is(code)), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
        return record;
    }

    @Override
    public Object postClean(ErpClean clean) throws DWException {
        List<String> pluginIds = clean.getPluginIds();
        String tenantId = ServiceUtils.getTenantId();
        if (CollectionUtils.isEmpty(pluginIds)) {
            List<ErpSyncRecord> records = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(tenantId)), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
            records.forEach(r -> {
                pluginIds.add(r.getPluginId());
            });
        }
        if (pluginIds.size() > 0) {
            Query queryDelete = Query.query(Criteria.where("tenantId").is(tenantId).and("pluginId").in(pluginIds));
            mongoTemplate.remove(queryDelete, DataDescription.class, tenantCol(DataDescription.class));
            mongoTemplate.remove(queryDelete, DataState.class, tenantCol(DataState.class));
            mongoTemplate.remove(queryDelete, Project.class, tenantCol(Project.class));
            mongoTemplate.remove(queryDelete, Task.class, tenantCol(Task.class));
            mongoTemplate.remove(queryDelete, FlowGraph.class, tenantCol(FlowGraph.class));
            mongoTemplate.remove(queryDelete, Activity.class, tenantCol(Activity.class));
            mongoTemplate.remove(queryDelete, PageView.class, tenantCol(PageView.class));
            mongoTemplate.remove(queryDelete, ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));

            Map<String, Object> param = new HashMap<>();
            param.put("tenantId", tenantId);
            param.put("pluginIds", pluginIds);
            if (null != sessionFactory1) {
                Session session1 = sessionFactory1.openSession();
                session1.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId in $pluginIds detach delete a ", param);
            }
            if (null != sessionFactory2) {
                Session session2 = sessionFactory2.openSession();
                session2.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId in $pluginIds detach delete a ", param);
            }

            dataMapTagSystemService.cleanTags(param);

        }

        return pluginIds;
    }

    protected void initBill(ErpSyncBill bill, ErpSyncRecord event) {
        if (null != bill && null != bill.getEntity() && CollectionUtils.isNotEmpty(bill.getEntity().getFields())) {
            bill.getEntity().getFields().forEach(f -> {
                if (ErpField.type_Number.equalsIgnoreCase(f.getType())) {
                    f.setAsApproveVariable(true);
                }
                if (null != event && !StringUtils.isEmpty(event.getTemplate())) {
                    f.setVisible(false);
                }
            });

            // 支持子单身数据也默认不显示
            if (null != event && null != event.getTemplate() && CollectionUtils.isNotEmpty(bill.getEntity().getDetail())) {
                for (ErpEntity entity : bill.getEntity().getDetail()) {
                    for (ErpField field : entity.getFields()) {
                        field.setVisible(false);
                    }
                    if (CollectionUtils.isNotEmpty(entity.getDetail())) {
                        for (ErpEntity detail2 : entity.getDetail()) {
                            for (ErpField field : detail2.getFields()) {
                                field.setVisible(false);
                            }
                        }
                    }
                }
            }

            // 加入action，用以前端获取当前流程时送审还是撤审
            // 判断ICD
            if (null != event && null != event.getTemplate()) {
                ErpField action = new ErpField();
                action.setId("action");
                action.setType("string");
                // action.setEnum_key("ddsm_action");
                Map<String, String> name = new HashMap<>();
                name.put("zh_cn", "签核类型");
                name.put("zh_tw", "簽核類型");
                name.put("en_us", "action");
                action.setName(name);
                action.setVisible(false);
                bill.getEntity().getFields().add(action);
            }
        }

    }

    // todo 更新原有保存记录，这里先直接删除重建
    private void createData(ErpSyncRecord event) {
        updateDTDs(event);
    }

    private void updateData(ErpSyncRecord event, ErpSyncBill bill) {
        ErpSyncBill oldBill = event.getBill();
        // 保留之前的修改记录和顺序
        if (null != oldBill.getEntity() && null != bill.getEntity()) {
            List<ErpField> summary = mergeEntity(oldBill.getEntity().getFields(), bill.getEntity().getFields());
            bill.getEntity().setFields(summary);
            if (null != oldBill.getEntity().getDetail() && null != bill.getEntity().getDetail()) {
                Map<String, ErpEntity> oldEntities = new HashMap<>();
                oldBill.getEntity().getDetail().forEach(old -> {
                    oldEntities.put(old.getEntity_key(), old);
                });
                for (ErpEntity entity : bill.getEntity().getDetail()) {
                    ErpEntity old = oldEntities.get(entity.getEntity_key());
                    if (null != old) {
                        List<ErpField> detailFields = mergeEntity(old.getFields(), entity.getFields());
                        entity.setFields(detailFields);
                    }
                }
            }
        }
        event.setBill(bill);
    }

    private List<ErpField> mergeEntity(List<ErpField> oldFields, List<ErpField> newFields) {
        if (null == oldFields || null == newFields) {
            return newFields;
        }
        Map<String, ErpField> maps = new HashMap<>();
        newFields.forEach(f -> {
            maps.put(f.getId(), f);
        });
        List<ErpField> merged = new ArrayList<>();
        for (ErpField f : oldFields) {
            if (maps.containsKey(f.getId())) {
                ErpField newOne = maps.get(f.getId());
                newOne.setAsApproveVariable(f.getAsApproveVariable());
                newOne.setVisible(f.getVisible());
                merged.add(newOne);
            }
        }
        for (ErpField f : newFields) {
            if (!merged.contains(f)) {
                merged.add(f);
            }
        }

        return merged;
    }

    // 主单身需要放在最前面
    private void checkPrimaryDetail(ErpSyncRecord event) {
        ErpSyncBill bill = event.getBill();
        if (null != bill && null != bill.getEntity() && CollectionUtils.isNotEmpty(bill.getEntity().getDetail())) {
            ErpEntity primaryDetail = null;
            for (int i = 0; i < bill.getEntity().getDetail().size(); i++) {
                ErpEntity detail = bill.getEntity().getDetail().get(i);
                if (Boolean.TRUE.equals(detail.getPrimaryEntity())) {
                    primaryDetail = detail;
                    break;
                }
            }
            if (null != primaryDetail) {
                bill.getEntity().getDetail().remove(primaryDetail);
                bill.getEntity().getDetail().add(0, primaryDetail);
            } else {
                bill.getEntity().getDetail().get(0).setPrimaryEntity(true);
            }
        }
    }

    public void updateDTDs(ErpSyncRecord event) {
        List<AppRelation2> applicationRelationList = new ArrayList<>();
        boolean stardard = false;
        if (null != event.getTemplate()) {
            stardard = true;
        }

        String locale = ServiceUtils.getCurrentLocale();
        if (null == locale) {
            locale = "zh_CN";
        }
        Query queryDelete = Query.query(Criteria.where("tenantId").is(event.getTenantId()).and("pluginId").is(event.getPluginId()));
        mongoTemplate.remove(queryDelete, DataDescription.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, DataState.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, Project.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, Task.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, FlowGraph.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, Activity.class, tenantCol(ErpSyncRecord.class));
        mongoTemplate.remove(queryDelete, PageView.class, tenantCol(ErpSyncRecord.class));

        List<DataDescription> entities1 = entities(event, DataDescription.class);
        entities1.forEach(p -> {
            mongoTemplate.save(p, tenantCol(DataDescription.class));
        });

        List<DataState> entities2 = entities(event, DataState.class);
        entities2.forEach(p -> {
            mongoTemplate.save(p, tenantCol(DataState.class));
        });

        List<Project> entities3 = entities(event, Project.class);
        String finalLocale = locale;
        entities3.forEach(p -> {
            if ("user".equalsIgnoreCase(p.getExecuteType())) {
                if (null != event.getBill() && null != event.getBill().getProgram_name()) {
                    p.getLang().put("name", event.getBill().getProgram_name());
                    p.setName(event.getBill().getProgram_name().get(finalLocale));
                }
                event.setProjectCode(p.getCode());
                event.setName(p.getName());
                event.setLang(p.getLang());
            }
            mongoTemplate.save(p, tenantCol(Project.class));
            saveDdsmApplicationRelation(applicationRelationList, p.getCode(), "task");
        });

        List<Task> entities4 = entities(event, Task.class);
        entities4.forEach(p -> {
            mongoTemplate.save(p, tenantCol(Task.class));
            saveDdsmApplicationRelation(applicationRelationList, p.getCode(), "activity");
            if ("approve".equalsIgnoreCase(p.getType())) {
                event.setApproveTaskCode(p.getCode());
            }
        });

        List<FlowGraph> entities5 = entities(event, FlowGraph.class);
        entities5.forEach(p -> {
            mongoTemplate.save(p, tenantCol(FlowGraph.class));
        });

        List<Activity> entities6 = entities(event, Activity.class);
        entities6.forEach(p -> {
            mongoTemplate.save(p, tenantCol(Activity.class));
        });

        List<PageView> entities7 = entities(event, PageView.class);

        Map<String, Object> settings = getNewSettings(event, locale);

        boolean finalStardard = stardard;
        entities7.forEach(p -> {
            Map<String, Object> page = p.getPages();
            if (!page.isEmpty() && !settings.isEmpty()) {
                JSONObject taskDatail = (JSONObject) page.get("task-detail");
                if (null != taskDatail) {
                    JSONArray dataStates = (JSONArray) taskDatail.get("dataStates");
                    if (null != dataStates) {
                        JSONObject state0 = dataStates.getJSONObject(0);
                        state0.put("settings", settings);
                    }
                }
            }
            JSONObject taskDatail = (JSONObject) page.get("task-detail");
            if (null != taskDatail) {
                JSONArray dataStates = (JSONArray) taskDatail.get("dataStates");
                if (null != dataStates) {
                    JSONObject state0 = dataStates.getJSONObject(0);
                    if (finalStardard && null != p.getPageType() && p.getPageType() == 2) {
                        addTabs(p, state0, event, "task_query_data");
                    }
                }
            }

            JSONObject projectDatail = (JSONObject) page.get("project-detail");
            if (null != projectDatail) {
                JSONArray dataStates = (JSONArray) projectDatail.get("dataStates");
                if (null != dataStates) {
                    JSONObject state0 = dataStates.getJSONObject(0);
                    if (finalStardard && null != p.getPageType() && p.getPageType() == 2) {
                        addTabs(p, state0, event, "project_query_data");
                    }
                }
            }

            mongoTemplate.save(p, tenantCol(PageView.class));
        });

        if (CollectionUtils.isNotEmpty(applicationRelationList)) {
            AppRelationBatchPo po= new AppRelationBatchPo();
            List<ApplicationRelation> list2 = JSON.parseArray(JSON.toJSONString(applicationRelationList),ApplicationRelation.class);
            po.setList(list2);
            try {
                datamapAppService.postApplicationRelationByDDSM(po);
            } catch (DWBusinessException e) {
                throw new RuntimeException(e);
            }
        }

    }

    // ddsm 创建应用关系
    private void saveDdsmApplicationRelation(List<AppRelation2> applicationRelationList, String code, String type) {
        AppRelation2 applicationRelation = new AppRelation2();
        applicationRelation.setAppName("ERP签核");
        applicationRelation.setAppCode("EAS");
        applicationRelation.setApplication("EAS");
        applicationRelation.setCode(code);
        applicationRelation.setType(type);
        applicationRelation.setVersion("2.0");
        applicationRelationList.add(applicationRelation);
    }

    /**
     * 单身以及子单身展示
     */
    protected void addTabs(PageView pageView, Map state0, ErpSyncRecord event, String prefix) {
        if (null == event.getBill().getEntity() || null == event.getBill().getEntity().getDetail()) {
            return;
        }
        String locale = ServiceUtils.getCurrentLocale();
        List operations = new ArrayList();
        List tabs = new ArrayList();
        List gridSettings = new ArrayList();
        String entity_key = event.getBill().getEntity().getEntity_key();

        for (ErpEntity detail : event.getBill().getEntity().getDetail()) {
            Map tab = new HashMap();
            Map operation = new HashMap();
            Map gridSetting = new HashMap();
            Map lang1 = new HashMap();
            String target = prefix + "." + detail.getEntity_key();
            Map<String, String> entityName = detail.getEntity_name();
            String title = entityName.get(locale.toLowerCase());
            lang1.put("title", entityName);

            tab.put("target", target);
            tab.put("title", title);
            tab.put("lang", lang1);
            tabs.add(tab);

            // 组装项目gridSetting
            gridSetting.put("gridPath", prefix);
            gridSetting.put("gridSchema", detail.getEntity_key());
            gridSetting.put("height", 220);
            gridSettings.add(gridSetting);

            operation.put("target", target);
            operation.put("title", title);
            operation.put("lang", lang1);
            operation.put("type", "DRAWER");
            operation.put("mode", "row");
            operation.put("switchData", true);
            List tabs2 = new ArrayList();
            if (null != detail.getDetail()) {
                for (ErpEntity detail2 : detail.getDetail()) {
                    Map tab2 = new HashMap();
                    Map lang2 = new HashMap();
                    String target2 = target + "." + detail2.getEntity_key();
                    Map<String, String> entityName2 = detail2.getEntity_name();
                    String title2 = entityName2.get(locale.toLowerCase());
                    lang2.put("title", entityName2);

                    tab2.put("target", target2);
                    tab2.put("title", title2);
                    tab2.put("lang", lang2);
                    tabs2.add(tab2);
                }
            }
            operation.put("tabs", tabs2);
            if (CollectionUtils.isNotEmpty(tabs2)) {
                operations.add(operation);
            }
        }

        state0.put("gridSettings", gridSettings);
        state0.put("operations", operations);
        state0.put("tabs", tabs);
    }

    /**
     　* @description: 获取Settings
     　* @param [event, locale]
     　* @return java.util.Map<java.lang.String,java.lang.Object>
     　* @throws
     　* @author linc
     　* @date 2023/3/22 16:19
     */
    public Map<String, Object> getNewSettings(ErpSyncRecord event, String locale) {
        Map<String, Object> settings = new HashMap<>();

        if (null == event || null == event.getBill() || null == event.getBill().getEntity() || event.getBill().getEntity().getDetail().isEmpty()) {
            return settings;
        }

        List<ErpEntity> details = event.getBill().getEntity().getDetail();

        if (CollectionUtils.isNotEmpty(details)) {
            for (ErpEntity detail : details.subList(1, details.size())) {
                Map<String, Object> map = new HashMap<>();
                map.put("tableTitle", detail.getEntity_name().get(locale.toLowerCase()));
                settings.put(detail.getEntity_key(), map);
            }
        }

        return settings;
    }

    public void updateApprove(ErpSyncRecord event) {
        if (null == event.getBill() || null == event.getBill().getEntity() || null == event.getBill().getEntity().getFields()) {
            return;
        }
        String locale = ServiceUtils.getCurrentLocale();
        Query query = Query.query(Criteria.where("tenantId").is(event.getTenantId()).and("pluginId").is(event.getPluginId()).and("type").is("approve"));
        List<Activity> approveActivities = mongoTemplate.find(query, Activity.class, tenantCol(Activity.class));
        approveActivities.forEach(activity -> {
            ApproveInfo approve = JSON.parseObject(JSON.toJSONString(activity.getConfig().get("approve")), ApproveInfo.class);
            if (null == approve) {
                approve = new ApproveInfo();

            }
            if (null == approve.getDecision()) {
                approve.setDecision(new ApproveDecision());
            }
            List<ApproveDecisionVariable> ruleVariables = new ArrayList<>();
            Set<String> keys = new HashSet<>();
            for (ErpField erpField : event.getBill().getEntity().getFields()) {
                if (Boolean.TRUE.equals(erpField.getAsApproveVariable())) {
                    ApproveDecisionVariable variable = new ApproveDecisionVariable();
                    variable.setKey(erpField.getId());
                    variable.setType(erpField.getType());
                    if (null != erpField.getName()) {
                        try {
                            variable.setName(erpField.getName().get(locale));
                            if (null == variable.getName()) {
                                variable.setName(erpField.getName().get(locale.toLowerCase()));
                            }
                            Map<String, Map<String, String>> lang = new HashMap<>();
                            lang.put("name", erpField.getName());
                            variable.setLang(lang);
                        } catch (Exception e) {
                            log.error(e.getMessage(), e);
                        }
                    }
                    ruleVariables.add(variable);
                    keys.add(variable.getKey());
                }
            }
            if (ruleVariables.size() > 0) {
                if (null == approve.getDecision().getRuleVariableKey() || !keys.contains(approve.getDecision().getRuleVariableKey())) {
                    approve.getDecision().setRuleVariableKey(ruleVariables.get(0).getKey());
                }
                approve.getDecision().setRuleVariables(ruleVariables);
                activity.getConfig().put("approve", approve);
                mongoTemplate.save(activity, tenantCol(Activity.class));
            }
        });

    }

    public void updateActions(ErpSyncRecord event) {
        if (null == event.getBill() || null == event.getBill().getEntity()) {
            return;
        }

        Session session1 = null;
        Session session2 = null;
        if (null != sessionFactory1) {
            session1 = sessionFactory1.openSession();
        }
        if (null != sessionFactory2) {
            session2 = sessionFactory2.openSession();
        }
        Map<String, Object> param = new HashMap<>();
        param.put("tenantId", event.getTenantId());
        param.put("pluginId", event.getPluginId());
        if (null != session1) {
            session1.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId=$pluginId detach delete a ", param);
        }
        if (null != session2) {
            session2.query("match(t:TenantEntity)-[:ACTION]->(a:Action) where t.tenantId=$tenantId and a.pluginId=$pluginId detach delete a ", param);
        }

        String cyhper = content(event, "action.cql");

        // 构建任务返回结构
        // 单头部分
        ErpEntity erpEntity = event.getBill().getEntity();
        EspField data = erpFields2EspFields(erpEntity);
        data.setData_name("data");
        // attachement部分
        List<EspField> attachment = entities(event, EspField.class);
        data.getField().addAll(attachment);
        // 单身部分
        EspField primaryEspDetail = null;
        if (CollectionUtils.isNotEmpty(erpEntity.getDetail())) {
            for (int i = 0; i < erpEntity.getDetail().size(); i++) {
                ErpEntity detail = erpEntity.getDetail().get(i);
                EspField espDetail = erpFields2EspFields(detail);
                if (espDetail == null) {
                    continue;
                }
                espDetail.setIs_array(true);
                data.getField().add(espDetail);
                if (Boolean.TRUE.equals(detail.getPrimaryEntity())) {
                    primaryEspDetail = espDetail;
                }

                if (CollectionUtils.isNotEmpty(detail.getDetail())) {
                    for (ErpEntity childDetail : detail.getDetail()) {
                        EspField espChildDetail = erpFields2EspFields(childDetail);
                        if (espChildDetail != null) {
                            espChildDetail.setIs_array(true);
                            espDetail.getField().add(espChildDetail);
                        }
                    }
                }
            }
        }

        Gson gson = new Gson();
        String task_response_object = gson.toJson(data).replaceAll("\"", "\\\\\"");

        // String task_response_object = JSON.toJSONString(data).replaceAll("\"","\\\\\"");
        // log.info(task_response_object);

        // 构建项目返回结构
        EspField data2 = erpFields2EspFields(erpEntity);
        data2.setData_name("data");
        data2.setIs_array(true);
        if (null != primaryEspDetail) {
            List<EspField> sorted = new ArrayList<>();
            sorted.addAll(primaryEspDetail.getField());
            sorted.addAll(data2.getField());
            data2.setField(sorted);
        }
        data2.getField().addAll(attachment);
        String project_response_object = gson.toJson(data2).replaceAll("\"", "\\\\\"");
        // String project_response_object =JSON.toJSONString(data2).replaceAll("\"","\\\\\"");

        // 生成最终cyhper
        cyhper = cyhper.replace("#task_response_object#", task_response_object).replace("#project_response_object#", project_response_object);
        String cypher2 = "match(t:TenantEntity) where t.tenantId=$tenantId match(action:Action) where action.pluginId=$pluginId create (t)-[:ACTION]->(action)";

        if (null != session1) {
            session1.query(cyhper, new HashMap<>());
            session1.query(cypher2, param);
        }
        if (null != session2) {
            session2.query(cyhper, new HashMap<>());
            session2.query(cypher2, param);
        }

        String actionIds = content(event, "actionIds.txt");
        String[] ids = StringUtils.delimitedListToStringArray(actionIds, "\n");
        String cypher3 = "match(t:TenantEntity) where t.tenantId=$tenantId match(action:Action) where action.actionId=$actionId merge (t)-[:ACTION]->(action)";
        for (String id : ids) {
            if (StringUtils.isEmpty(id)) {
                continue;
            }
            param.put("actionId", id);
            dataMapHelpService.executeCypher(cypher3, param);
        }

    }

    public void updateTags(ErpSyncRecord event) throws DWException {

        List<TagEntity> tagEntities = new ArrayList<>();
        List<TagEntity> staticEntities = entities(event, TagEntity.class);
        tagEntities.addAll(staticEntities);

        if (null != event.getBill() && null != event.getBill().getEntity()) {
            ErpEntity entity = event.getBill().getEntity();
            // 任务-头
            int taskOrder = 10;
            int projectOrder = 10;
            List<TagEntity> taskheader = erpEntity2TagFields(taskOrder, event, entity.getFields(), event.getTaskActionId(), "data", "performer__");
            tagEntities.addAll(taskheader);
            taskOrder = taskOrder + taskheader.size() * 10;
            // 任务-单身
            if (null != entity.getDetail()) {
                for (ErpEntity detail : entity.getDetail()) {
                    List<TagEntity> taskdetail = erpEntity2TagFields(taskOrder, event, detail.getFields(), event.getTaskActionId(), "data." + detail.getEntity_key(), "performer__");
                    tagEntities.addAll(taskdetail);
                    taskOrder = taskOrder + taskdetail.size() * 10;
                    // 为每个单身打特殊标签
                    TagEntity specEntity = new TagEntity();
                    specEntity.setResourceId(event.getTaskActionId());
                    specEntity.setResourceContent(event.getTaskActionId() + ".response.data." + detail.getEntity_key());
                    List<Tag> tags = new ArrayList<>();
                    Tag tag1 = new Tag();
                    tag1.setCategory("ROLE__ACTIVITY");
                    tag1.setCode("performer__" + event.getApproveTaskCode());
                    tags.add(tag1);
                    /*
                     * Tag tag2=new Tag(); tag2.setCategory("BUSINESS"); tag2.setCode("SPLIT_LAYOUT"); tags.add(tag2);
                     */
                    specEntity.setTags(tags);
                    tagEntities.add(specEntity);
                    // 子单身打order标签
                    int subDetailOrder = 10;
                    if (null != detail.getDetail() && detail.getDetail().size() > 0) {
                        for (ErpEntity subDetail : detail.getDetail()) {
                            List<TagEntity> subDetails = erpEntity2TagFields(subDetailOrder, event, subDetail.getFields(), event.getTaskActionId(),
                                    "data." + detail.getEntity_key() + "." + subDetail.getEntity_key(), "performer__");
                            tagEntities.addAll(subDetails);
                            subDetailOrder = subDetailOrder + subDetails.size() * 10;
                        }

                    }
                }
            }

            // 项目-头
            List<TagEntity> projectHeader = erpEntity2TagFields(projectOrder, event, entity.getFields(), event.getProjectActionId(), "data", "charge__");
            tagEntities.addAll(projectHeader);
            projectOrder = projectOrder + projectHeader.size() * 10;

            // 项目-主单身
            if (null != entity.getDetail()) {
                for (ErpEntity detail : entity.getDetail()) {
                    if (Boolean.TRUE.equals(detail.getPrimaryEntity())) {
                        List<TagEntity> taskdetail = erpEntity2TagFields(projectOrder, event, detail.getFields(), event.getProjectActionId(), "data", "charge__");
                        tagEntities.addAll(taskdetail);
                        break;
                    }
                }
            }
        }

        tagEntities.forEach(en -> {
            if (null != en.getResourceContent()) {
                String resourceContent = "{'response': '" + en.getResourceContent() + "'}";
                en.setResourceContent(resourceContent);
            }
        });

        Map<String, Object> param = new HashMap<>();
        param.put("pluginId", event.getPluginId());
        param.put("tagEntities", tagEntities);

        dataMapTagSystemService.syncTags(param);

        // 清空tag缓存
        // atmcService.cleanCache();
        GenericRequest request = new GenericRequest();
        request.setModule("tagsystem");
        request.setTenantId(ServiceUtils.getTenantId());
        genericService.postCleanCache(request);

    }

    private static <T> List<T> entities(ErpSyncRecord event, Class<T> c) {
        String replaced = content(event, c.getSimpleName() + ".json");
        List<T> entities = JSON.parseArray(replaced, c);
        return entities;
    }

    private static String content(ErpSyncRecord event, String name) {
        String template = applicationTemplate;
        if (null != event.getTemplate()) {
            template = "ddsmtemplates/" + event.getTemplate();
        }
        String files = CommonUtils.loadStream(template + "/" + name);
        String replaced = files.replaceAll("#template_prefix#", event.getRecordId()).replaceAll("#template_tenantId#", event.getTenantId());
        return replaced;
    }

    // entity的Fields内部子Fields不管
    private EspField erpFields2EspFields(ErpEntity erpEntity) {
        if (null == erpEntity) {
            return null;
        }
        EspField espEntity = new EspField();
        espEntity.setData_name(erpEntity.getEntity_key());
        espEntity.setData_type("object");
        espEntity.setDescription(erpEntity.getEntity_name());
        List<EspField> espFields = new ArrayList<>();
        espEntity.setField(espFields);
        if (null != erpEntity.getFields()) {
            erpEntity.getFields().forEach(erp -> {
                EspField esp = new EspField();
                esp.setData_name(erp.getId());
                esp.setData_type(erpType2EspType(erp.getType()));
                esp.setDescription(erp.getName());
                esp.setEnum_key(erp.getEnum_key());
                espFields.add(esp);
            });

        }
        // todo 下冲刺展开
        // List<EspField> espDetails = new ArrayList<>();
        // if(null!=erpEntity.getDetail()){
        // erpEntity.getDetail().forEach(detail->{
        // EspField detailEspEntity = erpFields2EspFields(detail);
        // detailEspEntity.setIs_array(true);
        // espDetails.add(detailEspEntity);
        //
        // });
        // }
        // espEntity.setDetail(espDetails);

        // espEntity.getField().addAll(espDetails);
        return espEntity;
    }

    private String erpType2EspType(String erpType) {
        return erpType;
    }

    List<TagEntity> erpEntity2TagFields(int order, ErpSyncRecord event, List<ErpField> erpFields, String actionId, String doc, String tagPrefix) {
        List<TagEntity> tagEntities = new ArrayList<>();
        if (null == erpFields) {
            return tagEntities;
        }
        int step = 10;
        // boolean containsFields = erpFields.stream().anyMatch(fields -> "currency_no".equals(fields.getId()));
        for (ErpField erpField : erpFields) {
            TagEntity tagEntity = new TagEntity();
            tagEntity.setResourceId(actionId);
            tagEntity.setResourceContent(actionId + ".response." + doc + "." + erpField.getId());
            tagEntity.setTags(new ArrayList<>());

            if (Boolean.TRUE.equals(erpField.getVisible())) {
                Tag tag1 = new Tag();
                tag1.setCode(tagPrefix + event.getApproveTaskCode());
                tag1.setCategory("ROLE__ACTIVITY");
                tagEntity.getTags().add(tag1);
                Tag tag2 = new Tag();
                tag2.setCode(tagPrefix + event.getApproveTaskCode() + "__ORDER_" + order);
                tag2.setCategory("ORDER");
                tagEntity.getTags().add(tag2);
                order = order + step;
            }
            // 针对number类型需要保持2位小数,理论上它应该是金额
            if (null != event && null != event.getTemplate()) {
                if ("Decimal".equalsIgnoreCase(erpField.getType())) {
                    Tag tag3 = new Tag();
                    tag3.setCode("BUSINESS_AMOUNT");
                    tag3.setCategory("DISPLAY");
                    tagEntity.getTags().add(tag3);
                    tagEntity.setExtendedInfo(getExtendedInfo(erpField.getId()));
                }
            }

            if (tagEntity.getTags().size() > 0) {
                tagEntities.add(tagEntity);
            }
        }

        return tagEntities;
    }

    @Override
    public Erp2FormInfo getErp2FormInfo() throws DWException {
        String erp = mdcService.getErp(ServiceUtils.getTenantId());
        if (null == erp) {
            throw new DWBusinessException("未找到当前租户的erp信息");
        }

        ActionReq req = new ActionReq();
        req.setActionId(ActionConstants.e10_oapi_easyflow_object_list_data_query_get);
        ActionResp actionResp = dataMapActionService.postProcess(req);
        if (Objects.equals(actionResp.getSuccess(), Boolean.FALSE)) {
            erp = ICD;
        }

        Erp2FormInfo info = dataPickService.findByCode(erp, Erp2FormInfo.class);

        // 下拉的处理动作和列表栏位做多语言
        String locale = ServiceUtils.getCurrentLocale();
        if (null != info && !StringUtils.isEmpty(locale)) {
            for (Erp2FormField field : info.getFields()) {
                field.setName(field.getLang().get("name").get(locale));
                if ("action".equalsIgnoreCase(field.getKey())) {
                    List<NameValue> options = field.getOptions();
                    for (NameValue option : options) {
                        option.setName(option.getLang().get("name").get(locale));
                    }
                }
            }
        }

        return info;
    }

    @Override
    public Object postCreate(Erp2FormDTO dto) throws DWException {
        Map<String, Object> resp = new HashMap<>();
        String tenantId = ServiceUtils.getTenantId();

        if (null == dto.getErp()) {
            throw new DWBusinessException("erp不能为空");
        }

        ErpAdapter erpAdapter = getErpAdapter(dto.getErp());
        String template = erpAdapter.erpTemplate(dto);
        if (null == template) {
            throw new DWBusinessException("没有找到合适的模板");
        }

        ErpSyncRecord record = searchSameRecord(tenantId, dto.getData());
        if (null != record) {
            throw new DWBusinessException("已存在相同记录");
        }

        ErpSyncBill bill = erpAdapter.getMeta(dto);

        String uid = DataMapUtils.uuid();

        ErpSyncRecord event = new ErpSyncRecord();
        event.setRecordId(uid);
        event.setPluginId(uid);
        event.setTenantId(tenantId);
        event.setCreateTime(System.currentTimeMillis());
        event.setFormData(dto.getData());
        event.setStatus(2);
        event.setProjectCode(uid);
        event.setApproveTaskCode(uid + "_Approve");
        event.setTaskActionId(uid + "_taskQueryDataAction"); // 只能固定死后缀了，不然也无法区分哪个是task的哪个是action的
        event.setProjectActionId(uid + "_projectQueryDataAction");
        event.setTemplate(template);
        initBill(bill, event);
        event.setBill(bill);
        if (log.isInfoEnabled()) {
            log.info("begin to sync erp config ErpSyncRecord:{}", event);
        }

        createData(event);

        checkPrimaryDetail(event);

        updateApprove(event);

        updateActions(event);

        updateTags(event);

        if (log.isInfoEnabled()) {
            log.info("sync success");
        }
        resp.put("projectCode", event.getProjectCode());
        resp.put("recordId", uid);
        resp.put("success", true);

        mongoTemplate.save(event, tenantCol(ErpSyncRecord.class));

        Map<String, Object> ddsmParam = new HashMap<>();
        Map<String, Object> projectParam = new HashMap<>();
        projectParam.put("projectCode", event.getProjectCode());
        ddsmParam.put("project", projectParam);
        ddsmService.ddsmSync(ddsmParam);

        return event;

    }

    @Override
    public Object postProjectByData(Erp2DataDTO dto) throws DWException {
        ActionResp actionResp = new ActionResp();
        String tenantId = ServiceUtils.getTenantId();
        String erp = dto.getErp();
        if (null == erp) {
            erp = mdcService.getErp(tenantId);
        }
        if (null == erp) {
            actionResp.setSuccess(false);
            actionResp.setMsg("erp不能为空");
            return actionResp;
        }
        ErpAdapter erpAdapter = getErpAdapter(erp);
        // 预估一个租户定义的流程不会太多，加载到内存中寻找合适的模板
        List<ErpSyncRecord> records = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(tenantId).and("status").is(2)), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
        if (records.isEmpty()) {
            actionResp.setSuccess(false);
            actionResp.setMsg("没有匹配到租户记录");
            return actionResp;
        }

        Erp2FormInfo erp2FormInfo = this.getErp2FormInfo();
        ErpSyncRecord record = erpAdapter.erpProject(dto, records, erp2FormInfo);
        if (null == record) {
            actionResp.setSuccess(false);
            actionResp.setMsg("没有匹配到记录");
            return actionResp;
        }
        Project project = dataPickService.findByCode(record.getProjectCode(), Project.class);

        updatePageView(record, dto);

        actionResp.setSuccess(true);
        Map<String, Object> data = new HashMap<>();
        data.put("project", project);
        data.put("record", record);
        actionResp.setData(data);

        return actionResp;
    }

    /**
     * 升级老版本数据一兼容新的格式
     * @return
     * @throws DWException
     */
    @Override
    public Object getUpgradeErp2() throws DWException {
        List<ErpSyncRecord> records = mongoTemplate.findAll(ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
        for (ErpSyncRecord record : records) {
            ErpSyncBill bill = record.getBill();
            if (null == bill) {
                continue;
            }
            // 老的数据没有template字段
            if (null == record.getTemplate()) {
                record.setFormData(fillFormData(bill));
                mongoTemplate.save(record, tenantCol(ErpSyncRecord.class));
            }
        }
        return null;
    }

    private Map<String, NameValue> fillFormData(ErpSyncBill bill) {
        Map<String, NameValue> formData = new HashMap<>();
        NameValue program_id = new NameValue();
        program_id.setValue(bill.getProgram_id());
        if (null != bill.getProgram_name()) {
            program_id.setName(bill.getProgram_name().get("zh_CN"));
        }
        formData.put("program_id", program_id);

        NameValue doc_type_no = new NameValue();
        doc_type_no.setName(bill.getDoc_type_name());
        doc_type_no.setValue(bill.getDoc_type());
        formData.put("doc_type_no", doc_type_no);

        NameValue source_doc_type = new NameValue();
        source_doc_type.setName(bill.getOrg_type_name());
        source_doc_type.setValue(bill.getOrg_type());
        formData.put("source_doc_type", source_doc_type);

        NameValue op_org_no = new NameValue();
        op_org_no.setName(bill.getOrg_name());
        op_org_no.setValue(bill.getOrg_code());
        formData.put("op_org_no", op_org_no);

        NameValue action = new NameValue();
        action.setName("审核");
        action.setValue("Do");
        formData.put("action", action);

        return formData;
    }

    ErpAdapter getErpAdapter(String erp) throws DWBusinessException {

        for (ErpAdapter adapter : erpAdapters) {
            if (adapter.support(erp)) {
                return adapter;
            }
        }
        throw new DWBusinessException("未找到对应的erp适配器：" + erp);
    }

    /**
     　* @description: 查找同一租户是否已设置相同数据
     　* @param [tenantId, formData]
     　* @return com.digiwin.athena.datamap.domain.erp.ErpSyncRecord
     　* @throws
     　* @author linc
     　* @date 2023/3/9 15:53
     */
    protected ErpSyncRecord searchSameRecord(String tenantId, Map<String, NameValue> formData) {
        if (formData.isEmpty()) {
            return null;
        }

        Criteria criteria = Criteria.where("tenantId").is(tenantId);
        for (Map.Entry<String, NameValue> m : formData.entrySet()) {
            criteria.and("formData." + m.getKey() + ".value").is(m.getValue().getValue());
        }

        return mongoTemplate.findOne(Query.query(criteria), ErpSyncRecord.class, tenantCol(ErpSyncRecord.class));
    }

    /**
     　* @description: 更新pageView添加type
     　* @param [record, dto]
     　* @return void
     　* @throws
     　* @author linc
     　* @date 2023/3/23 18:20
     */
    protected void updatePageView(ErpSyncRecord record, Erp2DataDTO dto) throws DWBusinessException {
        Map<String, Object> attachments = (Map<String, Object>) dto.getData().get("attachment");
        if (attachments.isEmpty() || StringUtils.isEmpty(attachments.get("upload_mode")) || CollectionUtils.isEmpty((Collection<?>) attachments.get("data"))) {
            return;
        }

        List attachmentData = (List) attachments.get("data");

        Map<String, Object> categoryMap = (Map<String, Object>) attachmentData.get(0);

        PageView pageView = dataPickService.findByCode(record.getApproveTaskCode(), PageView.class);
        if (null == pageView) {
            return;
        }

        Map<String, Object> attachment = (Map<String, Object>) pageView.getAttachment();
        if (attachment.isEmpty()) {
            return;
        }

        List configs = (List) attachment.get("configs");
        if (CollectionUtils.isEmpty(configs)) {
            return;
        }

        Map<String, Object> configsData = (Map<String, Object>) configs.get(0);
        if (configsData.isEmpty()) {
            return;
        }

        if (!categoryMap.isEmpty()) {
            Object category = categoryMap.get("category");
            if (null != category) {
                List readCategory = (List) configsData.get("readCategory");
                readCategory.add(category);
            }
        }

        configsData.put("type", AttachmentType.getValue(((Double) attachments.get("upload_mode")).intValue()));
        mongoTemplate.save(pageView, tenantCol(PageView.class));
    }

    /**
     　* @description: 更新PageView
     　* @param [record, locale]
     　* @return void
     　* @throws
     　* @author linc
     　* @date 2023/4/3 12:23
     */
    public void updatePageViewByRecord(ErpSyncRecord record, String locale) throws DWBusinessException {
        if (null == record || null == record.getBill() || null == record.getBill().getEntity() || null == record.getBill().getEntity().getDetail()) {
            return;
        }

        boolean stardard = false;
        if (null != record.getTemplate()) {
            stardard = true;
        }

        Map<String, Object> settings = new HashMap<>();
        for (ErpEntity detail : record.getBill().getEntity().getDetail()) {
            if (Boolean.FALSE.equals(detail.getPrimaryEntity())) {
                Map<String, Object> map = new HashMap<>();
                map.put("tableTitle", detail.getEntity_name().get(locale.toLowerCase()));
                settings.put(detail.getEntity_key(), map);
                break;
            }
        }

        /*
         * if (settings.isEmpty()) { return; }
         */

        PageView pageView = dataPickService.findByCode(record.getApproveTaskCode(), PageView.class);
        if (null == pageView) {
            return;
        }

        boolean finalStardard = stardard;
        Map<String, Object> page = pageView.getPages();
        if (!page.isEmpty()) {
            Map<String, Object> taskDatail = (Map<String, Object>) page.get("task-detail");
            if (null != taskDatail) {
                List dataStates = (List) taskDatail.get("dataStates");
                if (CollectionUtils.isNotEmpty(dataStates)) {
                    Map<String, Object> dataSetings = (Map<String, Object>) dataStates.get(0);
                    if (!settings.isEmpty()) {
                        dataSetings.put("settings", settings);
                    }
                    if (finalStardard) {
                        addTabs(pageView, dataSetings, record, "task_query_data");
                    }
                }
            }

            Map<String, Object> projectDatail = (Map<String, Object>) page.get("project-detail");
            if (null != projectDatail) {
                List dataStates = (List) projectDatail.get("dataStates");
                if (CollectionUtils.isNotEmpty(dataStates)) {
                    Map<String, Object> dataSetings = (Map<String, Object>) dataStates.get(0);
                    // dataSetings.put("settings",settings);
                    if (finalStardard) {
                        addTabs(pageView, dataSetings, record, "project_query_data");
                    }
                }
            }

        }
        mongoTemplate.save(pageView, tenantCol(PageView.class));
    }

    /**
     　* @description: tag封装extendedInfo
     　* @param
     　* @return
     　* @throws
     　* @author linc
     　* @date 2023/4/18 12:25
     */
    protected Map<String, Object> getExtendedInfo(String fieldName) {
        Map<String, Object> extendedInfo = new HashMap<>();
        Map<String, String> queryCurrencyApiReturnFields = new HashMap<>();
        queryCurrencyApiReturnFields.put("query_field", fieldName);
        queryCurrencyApiReturnFields.put("decimal_places_type", "decimal_places_type");
        queryCurrencyApiReturnFields.put("decimal_places", "unit_purchase_price_decimal_places");
        Map<String, Object> actionParam = new HashMap<>();
        actionParam.put("unAddFlag", false);
        actionParam.put("name", "currency_data.currency_no");
        actionParam.put("type", "RAW_ARRAY_PARAS");
        actionParam.put("value", fieldName);
        List<Map<String, Object>> actionParams = new ArrayList<>();
        actionParams.add(actionParam);
        Map<String, Object> tmAction = new HashMap<>();
        tmAction.put("actionParams", actionParams);
        tmAction.put("actionId", "esp_currency.parameter.data.get");
        tmAction.put("type", "ESP");
        tmAction.put("dispatchBPM", false);
        tmAction.put("sequence", 0.0);
        tmAction.put("defaultAction", false);
        tmAction.put("terminateProcess", false);
        Map<String, Object> queryCurrencyApi = new HashMap<>();
        queryCurrencyApi.put("tmAction", tmAction);
        extendedInfo.put("currencyField", "");
        extendedInfo.put("queryCurrencyApiReturnFields", queryCurrencyApiReturnFields);
        extendedInfo.put("queryCurrencyApi", queryCurrencyApi);
        extendedInfo.put("cutZero", true);
        return extendedInfo;
    }

}
