package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.povo.ExecutionReq;
import com.digiwin.athena.datamap.service.IExecutionService;
import com.digiwin.athena.datamap.service.inner.InnerExecutionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-09 14:44
 **/
@MyExceptionHandler
@Service
public class ExecutionService implements IExecutionService {

    @Autowired
    InnerExecutionService innerService;

    @Override
    public Object postEntityById(ExecutionReq request) throws DWException {
        return innerService.findByEntity(request);
    }

    @Override
    public Object postProjectDetail(ExecutionReq request) throws DWException {
        return innerService.projectDetail(request);
    }

    @Override
    public Object postTaskDetail(ExecutionReq request) throws DWException {
        return innerService.taskDetail(request);
    }

    @Override
    public Object postActivityDetail(ExecutionReq request) throws DWException {
        return innerService.activityDetail(request);
    }
}
