package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
//import com.digiwin.athena.datamap.common.FieldDescription;
//import com.digiwin.athena.datamap.domain.TenantObject;
//import com.digiwin.athena.datamap.domain.action.Action;
//import com.digiwin.athena.datamap.domain.app.AppEntity2;
//import com.digiwin.athena.datamap.domain.app.AppRelation2;
//import com.digiwin.athena.datamap.domain.core.DataDescription;
//import com.digiwin.athena.datamap.domain.core.DataState;
//import com.digiwin.athena.datamap.domain.core.Project;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.generic.MetaInfo;
//import com.digiwin.athena.datamap.domain.view.PageView;
//import com.digiwin.athena.datamap.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.datamap.povo.GenericRequest;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.kmservice.cache.old.RedisConf;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.datamap.service.IGenericService;
import com.digiwin.athena.datamap.spi.AtmcService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.AppEntity2;
import com.digiwin.athena.dto.AppRelation2;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.jayway.jsonpath.JsonPath;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
//import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.CrossOrigin;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-10 11:28
 **/

@Lang
@MyExceptionHandler
@CrossOrigin
@Service
@Slf4j
public class GenericService implements IGenericService {

    @Autowired
    RedisConf redisConf;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    ActionRepository actionRepository;

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired
    DatamapAppService kgService;

    @Autowired
    AtmcService atmcService;
    @Autowired
    DatamapEocService datamapEocService;

    @Override
    public Object postProjectMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        Project project = dataPickService.findByCode(code, Project.class);
        // 任务输入数据
        if (null != project && null != project.getInit()) {
            String stateCode = project.getInit().getCode();
            if (null != stateCode) {
                DataState state = dataPickService.findByCode(stateCode, DataState.class);
                if (null != state && null != state.getDataCode()) {
                    DataDescription dataDescription = dataPickService.findByCode(state.getDataCode(), DataDescription.class);
                    if (null != dataDescription && null != dataDescription.getDataStruct()) {
                        FieldDescription mainData = dataDescription.getDataStruct();
                        mainData.setKey("data");
                        mainData.setName(dataDescription.getName());
                        mainData.setDataType("ARRAY");
                        mainData.setComponentType("object");
                        ApiDataFieldMetadataDTO dto = fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
                        fields.add(dto);
                    }
                }
            }
        }
        return fields;
    }

    @Override
    public Object postTaskMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        return taskStruct(code);
    }

    @Override
    public Object postTaskPageMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        Task task = dataPickService.findByCode(code, Task.class);
        if (null == task) {
            return null;
        }
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();

        // 任务datasource数据
        if (null != task.getPageCode()) {
            PageView pageView = dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(pageFields(pageView));
        }

        return fields;
    }

    public Object postDecisionObjectList(GenericRequest request) throws DWException {
        String code = request.getCode();
        Task task = dataPickService.findByCode(code, Task.class);
        if (null == task) {
            return null;
        }
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        List<String> openWindowFeildList = new ArrayList<>();

        // 任务datasource数据
        if (null != task.getPageCode()) {
            PageView pageView = dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(pageFields(pageView));
            Map map = JSON.parseObject(JSON.toJSONString(pageView));
            // 获取开窗的字段
            Object obj = JsonPath.read(map, "$.pages.task-detail.dataStates[*].operations[*]");
            JSONArray openWindowArray = JSON.parseArray(obj.toString());
            List<String> applyToFields = openWindowArray.stream().map(v -> {
                JSONObject jsonObject = (JSONObject) v;
                return jsonObject.getString("applyToField");
            }).collect(Collectors.toList());
            openWindowFeildList.addAll(applyToFields);
        }

        if (ObjectUtils.isEmpty(fields)) {
            return null;
        }

        fields.stream().filter(v -> !ObjectUtils.isEmpty(v.getField())).forEach(v -> {
            v.getField().forEach(t -> {
                if (!ObjectUtils.isEmpty(t.getEnum_key())) {
                    t.setMetaFieldType(MechanismEnum.ComponentType.SELECTOR.getCode());
                } else if (!ObjectUtils.isEmpty(openWindowFeildList) && openWindowFeildList.contains(t.getData_name())) {
                    t.setMetaFieldType(MechanismEnum.ComponentType.OPEN_WINDOW.getCode());
                }
            });
            // List<ApiDataFieldMetadataDTO> fieldMetadataDTOS = v.getField().stream().filter(
            // t -> !ObjectUtils.isEmpty(t.getMetaFieldType())).collect(Collectors.toList());
            // v.setField(fieldMetadataDTOS);
        });
        return fields;
    }

    @Override
    public Object postProjectPageMeta(GenericRequest request) throws DWException {
        String code = request.getCode();

        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        // 查找页面数据
        Map<String, Object> query = new HashMap<>();
        query.put("project", code);
        query.put("pageType", 1);

        PageView pageView = dataPickService.findOne(BasicQuery.of(query, null), PageView.class);
        fields.addAll(pageFields(pageView));
        return fields;
    }

    /**
     * module 支持 datamap、kg、preset、tag
     * @param request
     * @return
     * @throws DWException
     */
    @Override
    public Object postCleanCache(GenericRequest request) throws DWException {

        StringBuilder kmPattern = new StringBuilder();
        if (null != request.getModule()) {
            kmPattern.append(request.getModule());
        } else {
            kmPattern.append("km");
        }
        // appID与租户ID中间有appCode层级
        kmPattern.append(":SYSTEM:");
        if (null != request.getTenantId()) {
            kmPattern.append(request.getTenantId()).append(":*");
        } else {
            kmPattern.append("*");
        }
        String pattern = kmPattern.toString();
        // 每次scan的key的数量
        int count = 2000;
        Long result = this.blurScanDelete(pattern, count);
        System.out.println(pattern);
        // 清空tag缓存
        atmcService.cleanCache();
        return result;
    }

    @Override
    public void delMatch(String pattern) {
        if (!redisConf.getUse()) {
            return;
        }
        int count = 2000;
        Long delete = this.blurScanDelete(pattern, count);
        log.info("delMatch delete size,{}", delete);
    }

    /**
     * scan方式模糊匹配清除Redis缓存 禁用keys
     *
     * @param matchKey  匹配的key
     * @param count     扫描数量
     * @return 删除key的数量
     */
    public Long blurScanDelete(String matchKey, int count) {
        return (Long) redisTemplate.execute((RedisCallback<Long>) connection -> {
            long keyCount = 0;
            try (Cursor<byte[]> cursor = connection.scan( ScanOptions.scanOptions().count(count).match(matchKey).build())) {
                long cursorId = cursor.getCursorId();
                Set<String> keys = new HashSet<>();
                while (cursor.hasNext()) {
                    keys.add(new String(cursor.next()));
                    if (cursorId != cursor.getCursorId()) {
                        keyCount += keys.size();
                        // 删除redis缓存
                        redisTemplate.delete(keys);
                        // 重置keys集合
                        keys = new HashSet<>();
                    }
                    cursorId = cursor.getCursorId();
                }
                // 处理最后一批数据或者唯一一批数据
                if (cursor.getCursorId() == 0 || CollectionUtils.isNotEmpty(keys)) {
                    keyCount += keys.size();
                    // 删除redis缓存
                    redisTemplate.delete(keys);
                }
            } catch (Exception e) {
                log.error("blurScanDelete failed,{}", e.toString());
            }
            return keyCount;
        });
    }

    @Override
    public Object postAppRelations(GenericRequest request) throws Exception {
        int batchSize = 1000;
        Map<String, Object> resp = new HashMap<>();
        String type = request.getType();
        List msg = new ArrayList();
        Set<String> codes = new HashSet<>();
        List<AppRelation2> list = new ArrayList<>();
        List<AppEntity2> relation2s = appEntitys();
        Map<String, AppEntity2> namespaceToCode = new HashMap<>();
        relation2s.forEach(appEntity2 -> {
            if (null != appEntity2.getNamespace()) {
                namespaceToCode.put(appEntity2.getNamespace(), appEntity2);
            }
        });
        List<? extends TenantObject> objects = null;
        String rType = null;
        if ("project".equalsIgnoreCase(type)) {
            objects = mongoTemplate.findAll(Project.class);
            rType = "task";
        } else if ("task".equalsIgnoreCase(type)) {
            objects = mongoTemplate.findAll(Task.class);
            rType = "activity";
        } else {
            return resp;
        }

        for (TenantObject p : objects) {
            if (null == p.getAthena_namespace()) {
                msg.add("code:" + p.getCode() + " application is null");
                continue;
            }
            if (codes.contains(p.getCode())) {
                continue;
            }
            codes.add(p.getCode());
            AppEntity2 appEntity2 = namespaceToCode.get(p.getAthena_namespace());
            if (null == appEntity2) {
                if (Boolean.TRUE.equals(request.getApplicationAsAppCodeWhenNull())) {
                    appEntity2 = new AppEntity2();
                    appEntity2.setName("appEntityNull");
                    appEntity2.setCode(p.getAthena_namespace());
                } else {
                    msg.add("code:" + p.getCode() + " can not get AppEntity by application:" + p.getAthena_namespace());
                    continue;
                }

            }
            AppRelation2 relation2 = new AppRelation2();
            relation2.setType(rType);
            relation2.setCode(p.getCode());
            relation2.setApplication(p.getAthena_namespace());
            relation2.setAppCode(appEntity2.getCode());
            relation2.setAppName(appEntity2.getName());
            relation2.setSource("datamap");
            relation2.setVersion(p.getVersion());
            list.add(relation2);
        }

        if (Boolean.TRUE.equals(request.getBatch())) {
            AppRelationBatchPo po = new AppRelationBatchPo();
            List<ApplicationRelation> list2 = JSON.parseArray(JSON.toJSONString(list),ApplicationRelation.class);
            po.setList(list2);
            kgService.postAppRelationUpdate(po);
        } else {
            resp.put("list", list);
        }

        resp.put("msg", msg);
        return resp;
    }

    @Override
    public Object getCorp() throws DWException {

        return datamapEocService.eocInfo();
    }

    public List<ApiDataFieldMetadataDTO> taskStruct(String taskCode) throws DWBusinessException {
        Task task = dataPickService.findByCode(taskCode, Task.class);
        if (null == task) {
            return null;
        }
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();

        // 任务输入数据
        if (null != task && task.getStateMaps().size() > 0) {
            String stateCode = task.getStateMaps().get(0).getInput();
            if (null != stateCode) {
                DataState state = dataPickService.findByCode(stateCode, DataState.class);
                if (null != state && null != state.getDataCode()) {
                    DataDescription dataDescription = dataPickService.findByCode(state.getDataCode(), DataDescription.class);
                    if (null != dataDescription && null != dataDescription.getDataStruct()) {
                        FieldDescription mainData = dataDescription.getDataStruct();
                        mainData.setKey("data");
                        mainData.setName(dataDescription.getName());
                        mainData.setDataType("ARRAY");
                        mainData.setComponentType("object");
                        ApiDataFieldMetadataDTO dto = fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
                        fields.add(dto);
                    }
                }
            }
        }

        return fields;
    }

    public List<ApiDataFieldMetadataDTO> pageStruct(String taskCode) throws DWBusinessException {
        Task task = dataPickService.findByCode(taskCode, Task.class);
        if (null == task) {
            return null;
        }
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();

        // 任务datasource数据
        if (null != task.getPageCode()) {
            PageView pageView = dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(pageFields(pageView));
        }

        return fields;
    }

    private List<ApiDataFieldMetadataDTO> pageFields(PageView pageView) {
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        ApiDataFieldMetadataDTO dto0 = pageField(pageView);
        if (null != dto0) {
            fields.add(dto0);
            return fields;
        }
        if (null != pageView && null != pageView.getDataSources()) {
            pageView.getDataSources().forEach((k, v) -> {
                try {
                    Map map = (Map) v;
                    String actionId = (String) map.get("actionId");
                    ApiDataFieldMetadataDTO dto = actionResponseDto(actionId);
                    if (null != dto) {
                        dto.setData_name(k);
                        // if(null==dto.getName() && null!= map.get("title")){
                        // dto.setName((String) map.get("title"));
                        // }
                        fields.add(dto);
                    }
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }

            });

        }

        return fields;
    }

    // 找到任务指定datasource
    public ApiDataFieldMetadataDTO pageField(PageView pageView) {

        if (null == pageView || null == pageView.getDataSources()) {
            return null;
        }
        // 新版结构
        Object dataSourceName = JSONPath.eval(pageView, "$.pages['task-detail'].dataStates[0].dataFilter.dataSourceNames[0]");
        if (null == dataSourceName) {
            // 老版结构
            dataSourceName = JSONPath.eval(pageView, "$.dataFilters[applyTo like '%task-detail%'].dataSourceNames[0][0]");
        }
        if (null == dataSourceName) {
            return null;
        }
        Map datasource = (Map) pageView.getDataSources().get(dataSourceName);
        if (null == datasource) {
            return null;
        }
        String actionId = (String) datasource.get("actionId");
        ApiDataFieldMetadataDTO dto = actionResponseDto(actionId);
        if (null != dto) {
            dto.setData_name((String) dataSourceName);
            return dto;
        }
        return dto;
    }

    public ApiDataFieldMetadataDTO actionResponseDto(String actionId) {
        try {
            String version = dataPickService.tenantVersion();
            log.info("GenericService.actionResponseDto，获取字段信息，actionIc={}, version={}", actionId, version);
            List<Action> actions = actionRepository.getActionByActionId(actionId, version);
            if (actions.size() == 0) {
                return null;
            }
            Action action = actions.get(0);
            if (StringUtils.isEmpty(action.getResponse_object())) {
                return null;
            }
            ApiDataFieldMetadataDTO dto = JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class);
            dto.setName(action.getActionName());
            apiFieldNameLocaleProcess(dto);
            return dto;
        } catch (DWBusinessException e) {
            log.error("GenericService.actionResponseDto 根据actionId获取字段信息失败，e={}", e);
        }
        return null;
    }

    public Map<String, ApiDataFieldMetadataDTO> actionResponseDtos(Set<String> actionIds) {
        Map<String, ApiDataFieldMetadataDTO> resp = new HashMap<>();
        List<Action> actions = actionRepository.getActionByActionIds(actionIds);
        for (Action action : actions) {
            if (StringUtils.isEmpty(action.getResponse_object())) {
                continue;
            }
            ApiDataFieldMetadataDTO dto = JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class);
            dto.setName(action.getActionName());
            apiFieldNameLocaleProcess(dto);
            resp.put(action.getActionId(), dto);
        }
        return resp;
    }

    private void apiFieldNameLocaleProcess(ApiDataFieldMetadataDTO dto) {
        String locale = ServiceUtils.getCurrentLocale();
        if (null == locale) {
            locale = "zh_CN";
        }
        if (null == dto.getName() && null != dto.getDescription()) {
            dto.setName(dto.getDescription().getZh_CN());
            if ("zh_TW".equalsIgnoreCase(locale)) {
                dto.setName(dto.getDescription().getZh_TW());
            } else if ("en_US".equalsIgnoreCase(locale)) {
                dto.setName(dto.getDescription().getEn_US());
            }
        }
        if (CollectionUtils.isNotEmpty(dto.getField())) {
            for (ApiDataFieldMetadataDTO d : dto.getField()) {
                apiFieldNameLocaleProcess(d);
            }
        }
        dto.setDescriptionLang(dto.getDescription());
    }

    public List<ApiDataFieldMetadataDTO> dataStruct(String dataCode) throws DWBusinessException {
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        DataDescription dataDescription = dataPickService.findByCode(dataCode, DataDescription.class);
        if (null != dataDescription && null != dataDescription.getDataStruct()) {
            FieldDescription mainData = dataDescription.getDataStruct();
            mainData.setKey("data");
            mainData.setName(dataDescription.getName());
            mainData.setDataType("ARRAY");
            mainData.setComponentType("object");
            ApiDataFieldMetadataDTO dto = fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
            fields.add(dto);
        }
        return fields;
    }

    public List<ApiDataFieldMetadataDTO> projectPageStruct(String projectCode) throws DWBusinessException {
        List<ApiDataFieldMetadataDTO> fields = new ArrayList<>();
        // 查找页面数据
        Map<String, Object> query = new HashMap<>();
        query.put("project", projectCode);
        query.put("pageType", 1);
        PageView pageView = dataPickService.findOne(BasicQuery.of(query, null), PageView.class);
        fields.addAll(pageFields(pageView));
        return fields;
    }

    public static ApiDataFieldMetadataDTO fd2ApiDataFieldMetadataDTO(FieldDescription fd) {
        if (null == fd) {
            return null;
        }
        ApiDataFieldMetadataDTO dto = new ApiDataFieldMetadataDTO();
        dto.setData_name(fd.getKey());
        dto.setName(fd.getName());
        // dto.setDescription();
        if ("ARRAY".equalsIgnoreCase(fd.getDataType())) {
            dto.setData_type(fd.getComponentType());
            dto.setIs_array(true);
        } else {
            dto.setData_type(fd.getDataType());
            dto.setIs_array(false);
        }
        if (null != fd.getRequired()) {
            dto.setRequired(fd.getRequired().toString());
        }
        if (null != fd.getFields()) {
            dto.setField(new ArrayList<>());
            for (FieldDescription fd2 : fd.getFields()) {
                ApiDataFieldMetadataDTO dto2 = fd2ApiDataFieldMetadataDTO(fd2);
                dto.getField().add(dto2);
            }
        }
        return dto;
    }

    public List<AppEntity2> appEntitys() {
        Session session = sessionFactory.openSession();
        Map<String, Object> param = new HashMap<>();
        Result result = session.query("match(a:AppEntity) return a.code as code,a.name as name,a.namespace as namespace", param);
        List<AppEntity2> list = new ArrayList<>();
        Iterator<Map<String, Object>> it = result.iterator();
        while (it.hasNext()) {
            Map<String, Object> map = it.next();
            if (null != map && map.size() > 0) {
                AppEntity2 entity2 = new AppEntity2();
                entity2.setCode((String) map.get("code"));
                entity2.setName((String) map.get("name"));
                entity2.setNamespace((String) map.get("namespace"));
                list.add(entity2);
            }
        }
        return list;
    }

}
