package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.configuration.DataMapModuleConfiguration;
import com.digiwin.athena.datamap.povo.meta.MetaRequest;
import com.digiwin.athena.datamap.povo.meta.MetaResponse;
import com.digiwin.athena.datamap.service.IMetaService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.common.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

@Service
public class MetaService implements IMetaService {

    @Autowired
    DataMapPickService dataPickService;

    @Override
    public <T extends TenantObject> MetaResponse postQuery(MetaRequest req) throws DWException {
        Class<? extends TenantObject> c = validateCode(req);
        List list = dataPickService.find(req,c);
        return MetaResponse.success(list);
    }

    @Override
    public <T extends TenantObject> MetaResponse postRemove(MetaRequest req) throws DWException {
        Class<? extends TenantObject> c = validateCode(req);
        long count = dataPickService.remove(req,c);
        return MetaResponse.success(count);
    }

    @Override
    public <T extends TenantObject> MetaResponse postUpdate(MetaRequest req) throws DWException {
        Class<? extends TenantObject> c = validateCode(req);
        long count = dataPickService.update(req,c);
        return MetaResponse.success(count);
    }

    @Override
    public <T extends TenantObject>  MetaResponse postSave(MetaRequest req) throws DWException {
        Class<T> c = validateCode(req);
        Map<String,Object> data = req.getData();
        if(null==data){return null;}
        T t = JSON.parseObject(JSON.toJSONString(data),c);
        dataPickService.save(t,c);
        return null;
    }


    private <T extends TenantObject>  Class<T> validateCode(MetaRequest request){
        Assert.notNull(request.getCode(),"code is null");
        Class<T>  clz = DataMapModuleConfiguration.codeToClass.get(request.getCode());
        Assert.notNull(clz,"code not registered code="+request.getCode());
        return clz;
    }
}
