package com.digiwin.athena.datamap.service.impl;

import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.service.IPresetCollectionService;
import com.digiwin.athena.datamap.spi.DbPresetService;
import com.digiwin.athena.kmservice.locale.Lang;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import static com.mongodb.client.model.Filters.*;
import static com.mongodb.client.model.Projections.excludeId;

@Lang
@Service
@MyExceptionHandler
public class PresetCollectionService implements IPresetCollectionService {

    @Autowired
    private DbPresetService dbPresetService;

    @Override
    public void put(String name) throws Exception {
        dbPresetService.getCollection(name);
    }

    @Override
    public void delete(String name) throws Exception {
        MongoCollection<Document> col = dbPresetService.getCollection(name);
        col.drop();
    }

    @Override
    public Object getList(String name, Map<String, Object> conditions, int limit) throws Exception {
        ArrayList<Map> re = new ArrayList<>();
        BasicDBObject sortObj = new BasicDBObject();
        sortObj.put("createDate", -1);

        MongoCursor<Document> cursor;
        MongoCollection<Document> col = dbPresetService.getCollection(name);

        if (CollectionUtils.isEmpty(conditions)) {
            if (limit > 0) {
                cursor = col.find().projection(excludeId()).sort(sortObj).limit(limit).iterator();
            }else {
                cursor = col.find().projection(excludeId()).sort(sortObj).iterator();
            }
        } else {
            //目前仅实现 and 连接条件
            ArrayList<Bson> con = new ArrayList<>();
            for (Map.Entry<String, Object> entry : conditions.entrySet()) {
                if(entry.getValue() instanceof Collection){
                    con.add(in(entry.getKey(), entry.getValue()));
                }else{
                    con.add(eq(entry.getKey(), entry.getValue()));
                }
            }
            if (limit > 0) {
                cursor = col.find(and(con.toArray(new Bson[0]))).projection(excludeId()).sort(sortObj).limit(limit).iterator();
            } else {
                cursor = col.find(and(con.toArray(new Bson[0]))).projection(excludeId()).sort(sortObj).iterator();
            }
        }

        try {
            while (cursor.hasNext()) {
                re.add(cursor.next());
            }
        } finally {
            cursor.close();
        }
        return re.toArray(new Map[0]);
    }

    @Override
    public Object getList(String name, Map<String, Object> conditions, int limit, String... indexes) throws Exception {
        ArrayList<Map> re = new ArrayList<>();
        BasicDBObject sortObj = new BasicDBObject();
        sortObj.put("createDate", -1);

        MongoCursor<Document> cursor;
        MongoCollection<Document> col = dbPresetService.getCollection(name, indexes);

        if (CollectionUtils.isEmpty(conditions)) {
            if (limit > 0) {
                cursor = col.find().projection(excludeId()).sort(sortObj).limit(limit).iterator();
            }else {
                cursor = col.find().projection(excludeId()).sort(sortObj).iterator();
            }
        } else {
            //目前仅实现 and 连接条件
            ArrayList<Bson> con = new ArrayList<>();
            for (Map.Entry<String, Object> entry : conditions.entrySet()) {
                if(entry.getValue() instanceof Collection){
                    con.add(in(entry.getKey(), ((Collection<?>) entry.getValue())));
                }else{
                    con.add(eq(entry.getKey(), entry.getValue()));
                }

            }
            if (limit > 0) {
                cursor = col.find(and(con.toArray(new Bson[0]))).projection(excludeId()).sort(sortObj).limit(limit).iterator();
            } else {
                cursor = col.find(and(con.toArray(new Bson[0]))).projection(excludeId()).sort(sortObj).iterator();
            }
        }

        try {
            while (cursor.hasNext()) {
                re.add(cursor.next());
            }
        } finally {
            cursor.close();
        }
        return re.toArray(new Map[0]);
    }
}
