package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-15 13:33
 **/
@Service
@Slf4j
@Primary
public class DataMapPickService extends DataPickService {

    @Autowired
    KmService kmService;
    @Autowired
    @Qualifier("dataMapSystem")
    protected MongoTemplate mongoTemplate;;
    @Autowired(required = false)
    @Qualifier("dataMapTenant")
    MongoTemplate mongoTemplateTenant;


    public static List<Class> tenantClasses = Arrays.asList(ErpSyncRecord.class, TaskSchedule.class,
            MechanismDecision.class, MechanismDecisionTarget.class, PluginRecord.class, PluginBinding.class);

    public static List<Class> sysClasses = Arrays.asList(Erp2FormInfo.class);

    @Override
    public MongoTemplate systemTemplate() {
        return mongoTemplate;
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return mongoTemplateTenant;
    }

    @Override
    public String tenantVersion(String tenantId) {
        return kmService.tenantVersion(tenantId);
    }

    @Override
    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        return kmService.getCodeByTypeAndAppCode(type,app);
    }

    @Override
    public boolean isTenantCol(Class c) {
        return tenantClasses.contains(c);
    }

    @Override
    public boolean isSystemCol(Class c) {
        return sysClasses.contains(c);
    }

}
