package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
//import com.digiwin.athena.datamap.domain.BaseEntity;
//import com.digiwin.athena.datamap.domain.core.Activity;
//import com.digiwin.athena.datamap.domain.core.Plan;
//import com.digiwin.athena.datamap.domain.core.Project;
//import com.digiwin.athena.datamap.domain.core.Task;
//import com.digiwin.athena.datamap.domain.flow.FlowGraph;
//import com.digiwin.athena.datamap.domain.relation.ProjectPlanRelation;
import com.digiwin.athena.datamap.povo.ExecutionReq;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-09 14:45
 **/
@Service
public class InnerExecutionService {

    @Autowired
    SelectService service;

    public BaseEntity findByEntity(ExecutionReq req) throws DWBusinessException {
        if (null == req.getEntityId() || req.getType() == null) {
            return null;
        }
        postProcessReq(req);
        Class c = DataMapHelpService.entityMap.get(req.getType().toLowerCase());
        BaseEntity entity = service.findByEntityId(req.getEntityId(), c);
        return entity;
    }

    public Project projectDetail(ExecutionReq req) throws DWException {
        if (null == req.getEntityId()) {
            return null;
        }
        Project entity = service.findByEntityId(req.getEntityId(), Project.class);

        return entity;
    }

    public Object taskDetail(ExecutionReq req) throws DWException {

        Map<String, Object> map = new HashMap<>();
        if (null == req.getEntityId()) {
            return map;
        }
        Task entity = service.findByEntityId(req.getEntityId(), Task.class);
        if (null != entity) {
            map.put("task", entity);
            if (null != entity.getFlowEntityId()) {
                FlowGraph flowGraph = service.findByEntityId(entity.getFlowEntityId(), FlowGraph.class);
                map.put("flow", flowGraph);
            }
        }
        return map;

    }

    public Object activityDetail(ExecutionReq req) throws DWException {
        if (null == req.getEntityId()) {
            return null;
        }
        Activity entity = service.findByEntityId(req.getEntityId(), Activity.class);

        return entity;
    }

    private void postProcessReq(ExecutionReq req) {
        if (null != req.getTenantId()) {
            ServiceUtils.setTenantId(req.getTenantId());
        }
        if (null != req.getEocId()) {
            ServiceUtils.setEoc(req.getEocId());
        }
    }

}
