package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.OperationUnit;
import com.digiwin.athena.datamap.povo.middleware.UserPermission;
import com.digiwin.athena.datamap.povo.middleware.UserPermissionItem;
import com.digiwin.athena.datamap.povo.rebuild.ComponentBO2;
import com.digiwin.athena.datamap.povo.rebuild.TenantAppComponentListBO2;
import com.digiwin.athena.datamap.povo.rebuild.UserComponentDto;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
public class KmService {

    public static Map<String, String> relationTypeToComponentType = new HashMap<>();

    public static Map<String, String> patternToSubType = new HashMap<>();

    static {
        relationTypeToComponentType.put("task", "Project");
        relationTypeToComponentType.put("activity", "Task");
        relationTypeToComponentType.put("Task", "Project");
        relationTypeToComponentType.put("Activity", "Task");
        relationTypeToComponentType.put("base_entry", "BaseDataEntry");
        relationTypeToComponentType.put("statement", "Report");

        patternToSubType.put("DATA_ENTRY", "base_entry");
        patternToSubType.put("STATEMENT", "statement");
    }



    @Autowired
    @Lazy
    DataMapPickService dataPickService;
    @Autowired
    @Lazy
    DataMapKgDataPickService dataMapKgDataPickService;

    @Autowired
    IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    DatamapCacService datamapCacService;
    @Autowired
    DataMapIamService dataMapIamService;
    @Autowired
    @Qualifier("kgSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    @Qualifier("kgTenant")
    private MongoTemplate mongoTemplateTenant;


    //返回资料code对应的权限
    public Map<String,String> userPermission(Set<String> appCodes,String effect0) throws DWBusinessException {
        Map<String,String> permissions = new HashMap<>();
        if(CollectionUtils.isEmpty(appCodes)){return permissions;}
        List<UserPermission> userPermissions = dataMapIamService.getUserPermission(appCodes,userId(),token(),effect0);//allow
        if(CollectionUtils.isNotEmpty(userPermissions)){
            for(UserPermission up:userPermissions){
                if(CollectionUtils.isNotEmpty(up.getPermissions())){
                    for(UserPermissionItem item: up.getPermissions()){
                        String target = item.getTarget();
                        String effect = item.getEffect();
                        Integer denyReason = item.getDenyReason();
                        //无权限的只要未授权的部分
                        if("deny".equals(effect) && null!=denyReason && 0!=denyReason){
                            continue;
                        }
                        if(null!=target && null!=effect){
                            try {
                                String[] strs = target.split(":");
                                String code = strs[strs.length-1];
                                permissions.put(code,effect);
                            }catch (Exception e){
                                e.printStackTrace();
                            }

                        }
                    }
                }
            }
        }
        return permissions;
    }

    public TenantEntity tenantEntity(String tenantId){
        if(null==tenantId){return null;}
        TenantEntity entity = mongoTemplateSys.findOne(Query.query(Criteria.where("tenantId").is(tenantId)),TenantEntity.class);
        return entity;
    }


    /*实际从数据库中获取租户id*/
    public String tenantVersion(String tenantId) {
        if(null==tenantId){
            tenantId = ServiceUtils.getTenantIdSilent();
        }
        String version = null;
        TenantEntity tenantEntity = tenantEntity(tenantId);
        if (null != tenantEntity && null != tenantEntity.getVersion()) {
            version = tenantEntity.getVersion();
        }
        if(StringUtils.isEmpty(version)){
            version = "2.0";
        }
        return version;
    }
    public String tenantVersion() throws DWBusinessException {
        return dataPickService.tenantVersion();
    }
    public String tenantId() throws DWBusinessException {
        return ServiceUtils.getTenantId();
    }
    public String userId() throws DWBusinessException {
        return ServiceUtils.getUserId();
    }
    public String token() throws DWBusinessException {
        return ServiceUtils.getToken();
    }

    /**
     * 用户授权的应用
     *
     * @return 用户授权的应用code
     * @throws DWBusinessException 获取授权应用失败
     */
    public List<String> userApps(String userId) throws DWBusinessException {
        return datamapCacService.getAppAuth(userId);
    }

    /**
     * 租户授权的应用信息
     * @param tenantId 租户id
     * @return 租户授权的应用
     */
    public Object authorizationsTenants(String tenantId) {
        return datamapCacService.authorizationsTenants(tenantId);
    }

    /**
     * 租户订购的应用
     *
     * @param tenantId 租户id
     * @return 租户授权的应用code
     */
    public List<String> tenantApps(String tenantId) {
        return datamapCacService.getAuthorizationsApplication(tenantId);
    }

    /**
     * 租户初始化过的应用
     *
     * @param tenantId 租户id
     * @return 初始化过的应用code
     */
    public List<String> tenantInitializedAppCodes(String tenantId) {
        List<TenantAppRelation> list = mongoTemplateSys.find(Query.query(Criteria.where("tenantId").is(tenantId)), TenantAppRelation.class);
        return list.stream().map(TenantAppRelation::getAppCode).distinct().collect(Collectors.toList());
    }


    /**
     * 租户初始化过的应用
     *
     * @param tenantId 租户id
     * @return 初始化过的应用
     */
    public List<TenantAppRelation> tenantInitializedApps(String tenantId) {
        return mongoTemplateSys.find(Query.query(Criteria.where("tenantId").is(tenantId)), TenantAppRelation.class);
    }

    public List<TenantAppRelation> getTenantAppRelationByAppCode(List<String> appCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(appCodes)) {
            return new ArrayList<>();
        }
        return mongoTemplateSys.find(Query.query(Criteria.where("appCode").in(appCodes)), TenantAppRelation.class);
    }

    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<>();
        try {
            List<ApplicationRelation> relations = knowledgeGraphService.relations(app, type);
            if (null != relations) {
                codes = relations.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
            }
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }
        return codes;
    }



    /**
     * 根据租户版本号获取公共应用
     *
     * @param version 版本号
     * @return 公共应用code
     */
    public List<String> commonAppCodes(String version) {
        List<Application> applications = mongoTemplateSys.find(Query.query(Criteria.where("commonApp").is(true).and("version").is(version)), Application.class);
        return applications.stream().map(Application::getCode).distinct().collect(Collectors.toList());
    }

    public List<String> getCodeByTypeAndAppCodeWithComponentList(String appCode, String type, String tenantId) {
        List<String> codes = getCodeByTypeAndAppCode(type, appCode);
        List<String> tenantDisableComponentCodes = tenantDisableComponentCodes(appCode, tenantId, type, codes);
        codes.removeAll(tenantDisableComponentCodes);
        return codes;
    }

    /**
     * 根据应用获取租户授权下已失效的组件
     * @param appCode 应用code
     * @param tenantId 租户id
     * @param type 类型
     * @return
     */
    public List<String> tenantDisableComponentCodes(String appCode, String tenantId, String type, List<String> fulllist) {
        String componentType = relationTypeToComponentType.get(type);
        Assert.notNull(componentType, "缺少relationType到ComponentType的映射,relation type=" + type);
        List<String> list = new ArrayList<>();
        Map<String, Object> q = new HashMap<>();
        q.put("appCode", appCode);
        q.put("tenantId", tenantId);
        TenantAppComponentListBO bos = knowledgeGraphService.findOne(BasicQuery.of(q, null), TenantAppComponentListBO.class, KnowledgeGraphDb.TENANT, "tenantAppComponentList");
        if (null == bos || CollectionUtils.isEmpty(bos.getComponents())) {
            return list;
        }
        List<String> componentList = new ArrayList<>();
        for (ComponentBO bo : bos.getComponents()) {
            if (bo.getType().name().equals(componentType)) {
                if (bo.isDisabled()) {
                    list.add(bo.getCode());
                } else {
                    componentList.add(bo.getCode());
                }
            }
        }
        if (!componentList.isEmpty()) {
            for (String code : fulllist) {
                if (!componentList.contains(code)) {
                    list.add(code);
                }
            }
        }
        return list;
    }

    public List<String> tenantDisableComponentCodes(List<String> appCodes, String tenantId, String type, Map<String, List<String>> appCodeCodes) {
        String componentType = relationTypeToComponentType.get(type);
        if(null==componentType){
            componentType = type;
        }
        List<String> list = new ArrayList<>();
        Map<String, Object> q = new HashMap<>();
        q.put("appCode", appCodes);
        q.put("tenantId", tenantId);
        List<TenantAppComponentListBO2> boss = knowledgeGraphService.find(BasicQuery.of(q, null), TenantAppComponentListBO2.class, KnowledgeGraphDb.TENANT, "tenantAppComponentList");

        for (TenantAppComponentListBO2 bos : boss) {
            List<String> componentList = new ArrayList<>();
            List<String> fulllist = appCodeCodes.get(bos.getAppCode());
            if (CollectionUtils.isEmpty(fulllist) || CollectionUtils.isEmpty(bos.getComponents())) {
                continue;
            }
            for (ComponentBO2 bo : bos.getComponents()) {
                if (bo.getType().name().equals(componentType)) {
                    if (bo.isDisabled()) {
                        list.add(bo.getCode());
                    } else {
                        componentList.add(bo.getCode());
                    }
                }
            }
            if (!componentList.isEmpty()) {
                for (String code : fulllist) {
                    if (!componentList.contains(code)) {
                        list.add(code);
                    }
                }
            }
        }

        return list;
    }

    /**
     * 根据组件code获取对应应用
     * @param code 组件code
     * @param type 版本号
     * @return
     * @throws DWBusinessException
     */
    public Application getAppByCodeAndType(String code, String type) throws DWBusinessException {
        Application application = null;
        ApplicationRelation relation = knowledgeGraphService.relation(code, type);
        if (null != relation) {
            application = knowledgeGraphService.application(relation.getAppCode());
        }
        return application;
    }

    public List<String> userAuthApps() throws DWBusinessException {

        return datamapCacService.getAppAuth(null);
    }

    public static Map<String, Object> ecoInfo(OperationUnit operationUnit) {
        Map<String, Object> ecoInfo = new HashMap<>();
        if (null == operationUnit) {
            return ecoInfo;
        }
        ecoInfo.put("eoc_company_id", operationUnit.getEoc_company_id());
        ecoInfo.put("eoc_site_id", operationUnit.getEoc_site_id());
        ecoInfo.put("eoc_region_id", operationUnit.getEoc_region_id());
        ecoInfo.put("operation_unit_v2", operationUnit.getOperation_unit_v2());
        return ecoInfo;
    }


    /**
     * 查询用户指定类型可访问的资料，
     *
     * @param type
     * @param subType
     * @param type
     * @param lang 语言
     * @return
     * @throws DWBusinessException
     */
    public UserComponentDto userComponents(String type,String subType, String lang) throws DWBusinessException {
        UserComponentDto dto = new UserComponentDto();
        String tenantId = tenantId();
        String version = tenantVersion();
        //用户授权应用
        List<String> appCodes = userAuthApps();
        List<ApplicationRelation> relations = knowledgeGraphService.applicationRelations(appCodes, type,subType);
        if (CollectionUtils.isEmpty(relations)) {
            return null;
        }
        //查询公共应用
        Map<String, Object> query1 = new HashMap<>();
        query1.put("code", appCodes);
        query1.put("commonApp", true);
        query1.put("version", version);
        List<Application> commonApps = knowledgeGraphService.find(BasicQuery.of(query1, null), Application.class, KnowledgeGraphDb.SYSTEM, "application");
        List<String> commonAppCodes = commonApps.stream().map(Application::getCode).collect(Collectors.toList());
        //查询公共应用搭售项目
    //    List<String> commonProjectCodes = iamService.appItems(commonAppCodes);
        // 根据应用code查询应用列表
        List<Application> applicationList = knowledgeGraphService.applications(appCodes);
        Map<String, Application> applicationMap = applicationList.stream().collect(Collectors.toMap(Application::getCode
                , Function.identity(), (a, b) -> b));
        Map<String, ApplicationRelation> codeRelations = new HashMap<>();
        Map<String, List<String>> appCodeCodes = new HashMap<>();
        for (ApplicationRelation relation : relations) {
            String appCode = relation.getAppCode();
            String code = relation.getCode();
            //过滤掉公共应用中为未搭售的项目
//            if(commonAppCodes.contains(appCode) && !commonProjectCodes.contains(code)){
//                continue;
//            }
            codeRelations.put(code, relation);
            appCodeCodes.computeIfAbsent(appCode, k -> new ArrayList<>()).add(code);
            Application application = applicationMap.get(appCode);
            if (application != null && application.getLang() != null) {
                Map nameLangMap = application.getLang().get("name");
                String language = (null == nameLangMap.get(lang)) ? application.getName() : (String) nameLangMap.get(lang);
                relation.setAppName(StringUtils.isEmpty(language) ? relation.getAppName() : language);
            }
        }
        //组件清单过滤
        String componentType = type;
        if(null!=subType){
            componentType = subType;
        }
        List<String> disableCodes = tenantDisableComponentCodes(appCodes, tenantId, componentType, appCodeCodes);
        Set<String> codesFiltered = new HashSet<>();
        codesFiltered.addAll(codeRelations.keySet());
        disableCodes.forEach(codesFiltered::remove);

        dto.setCodesFiltered(codesFiltered);
        dto.setCodeRelations(codeRelations);
        dto.setCommonAppCodes(commonAppCodes);

        return dto;
    }



}
