package com.digiwin.athena.datamap.spi;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Service
@Slf4j
public class DatamapGMCService {

    // TODO 增加到环境变量
    @Value("${gmcUrl}")
    private String gmcUrl;

    // TODO 这个 restTemplate 有 routerPlan 不过 kg 没有，需要确认
    @Autowired
    private RestTemplate restTemplate;

    public Object getCloudGood(String appId) {

        String requestUrl = gmcUrl + "/api/cloudgoods/" + appId;
        Object forObject = this.restTemplate.getForObject(requestUrl, Object.class);
        return forObject;
    }

    /**
     * 更新商品模组，不需要上下架即可生效
     * @param requestObj
     * @return
     * @throws DWBusinessException
     */
    public Object updateCloudGoodModules(Object requestObj) throws DWBusinessException {
        String requestUrl = gmcUrl + "/api/cloudgoods/modules";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, this.getGmcToken());

        HttpEntity httpEntity = new HttpEntity(requestObj, headers);
        ResponseEntity<Object> stringResponseEntity = this.restTemplate.postForEntity(requestUrl, httpEntity, Object.class);

        return stringResponseEntity.getBody();
    }

    private String getGmcToken() throws DWBusinessException {
        Map<String, Object> requestHeader = DWServiceContext.getContext().getRequestHeader();
        String token = requestHeader == null ? "" : (String) requestHeader.get("gmctoken");
        if (StringUtils.isEmpty(token)) {
            throw new DWBusinessException("调用gmc系统的token缺失");
        }
        return token;
    }
}