package com.digiwin.athena.datamap.spi;

import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DbPresetService implements IDbPresetService {

    @Autowired
    MongoConverter converter;
    @Autowired
    @Qualifier("dataMapSystem")
    private MongoTemplate mongoTemplate;

    private final String presetDbName = "preset";

    @Override
    public <T> T findOne(Bson filter, Class<T> entityClass, String collectionName) {
        return findOne(filter, null, entityClass, collectionName);
    }

    @Override
    public <T> T findOne(Bson filter, Bson projection, Class<T> entityClass, String collectionName) {
        FindIterable<Document> findIterable = mongoTemplate.getMongoDbFactory().getMongoDatabase(presetDbName).getCollection(collectionName).find(filter);
        if (projection != null) {
            findIterable.projection(projection);
        }
        findIterable.limit(1);
        Document document = findIterable.first();
        if (document == null) {
            return null;
        }
        return converter.read(entityClass, document);
    }

    @Override
    public <T> List<T> find(Bson filter, Class<T> entityClass, String collectionName) {
        return find(filter, null, entityClass, collectionName);
    }

    @Override
    public <T> List<T> find(Bson filter, Bson projection, Class<T> entityClass, String collectionName) {
        FindIterable<Document> findIterable = mongoTemplate.getMongoDbFactory().getMongoDatabase(presetDbName).getCollection(collectionName).find(filter, Document.class);
        if (projection != null) {
            findIterable.projection(projection);
        }
        List<T> list = new ArrayList<>();
        for (Document t : findIterable) {
            list.add(converter.read(entityClass, t));
        }
        return list;
    }

    public MongoCollection<Document> getCollection(String name, String... indexes) {
        MongoCollection<Document> col = mongoTemplate.getMongoDbFactory().getMongoDatabase(presetDbName).getCollection(name);
        boolean keyExisted = false;
        for (Document index : col.listIndexes()) {
            if (name.equals(index.get("name"))) {
                keyExisted = true;
                break;
            }
        }
        if (!keyExisted) {
            IndexOptions indexOptions = new IndexOptions().name(name).unique(false).background(true);
            col.createIndex(Indexes.ascending(indexes), indexOptions);
        }

        return col;
    }

    @Override
    public UpdateResult upsert(Bson filter, Bson update, String collectionName) {
        return mongoTemplate.getMongoDbFactory().getMongoDatabase(presetDbName).getCollection(collectionName).updateOne(filter, update);
    }

    @Override
    public DeleteResult remove(Bson filter, String collectionName) {
        return mongoTemplate.getMongoDbFactory().getMongoDatabase(presetDbName).getCollection(collectionName).deleteMany(filter);
    }

}
