package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.service.impl.RuleService;
import com.digiwin.athena.preset.Rule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class PresetLibraryService {

    @Autowired
    RuleService ruleService;

    protected static final String RULE_COLNAME = "rules";

    public Object saveRule(Rule rule) {
        try {
            return ruleService.postSave(rule);
        } catch (Exception e) {
            log.error("saveRule error", e);
            throw new RuntimeException(e);
        }
    }

    public Object cleanRule(String pluginId) {
        if (null == pluginId) {
            return null;
        }
        Rule rule = new Rule();
        rule.setPluginId(pluginId);
        try {
            return ruleService.postRemoveByPluginId(rule);
        } catch (Exception e) {
            log.error("cleanRule error", e);
            throw new RuntimeException(e);
        }
    }

    public Object queryRule(String taskCode) {
        try {
            int count = -1;
            return ruleService.postQuery(taskCode, count);
        } catch (Exception e) {
            log.error("queryRule error", e);
            throw new RuntimeException(e);
        }
    }

    public List<Rule> rules(String taskCode) {
        Map resp = (Map) queryRule(taskCode);
        if (null == resp) {
            return null;
        }
        List<Rule> rules = JSON.parseArray(JSON.toJSONString(resp.get("rules")), Rule.class);
        return rules;
    }

}
