package com.digiwin.athena.datamap.supports;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;

import java.util.Map;

public class EocInfoLocal {

    private static ThreadLocal<Map<String, Object>> local = new ThreadLocal<>();

    public static void setEocInfo(Map<String, Object> eocInfo) {
        local.set(eocInfo);
    }

    public static Map<String, Object> getEocInfo() {
        return local.get();
    }

    public static void removeEocInfo() {
        local.remove();
    }

    public static Criteria addEocInfoToCriteria(Map<String, Object> eocInfo, Criteria criteria) {
        String companyId = null;
        String siteId = null;
        String regionId = null;

        if (eocInfo != null) {
            companyId = MapUtils.getString(eocInfo, "eoc_company_id");
            siteId = MapUtils.getString(eocInfo, "eoc_site_id");
            regionId = MapUtils.getString(eocInfo, "eoc_region_id");
        }

        if (StringUtils.isNotEmpty(companyId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_company_id").is(companyId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_company_id").is(null));
        }
        if (StringUtils.isNotEmpty(siteId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_site_id").is(siteId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_site_id").is(null));
        }
        if (StringUtils.isNotEmpty(regionId)) {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_region_id").is(regionId));
        } else {
            criteria = new Criteria().andOperator(criteria, Criteria.where("eocInfo.eoc_region_id").is(null));
        }

        return criteria;
    }

}
