package com.digiwin.athena.datamap.supports;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 13:55
 **/
@Data
public class EspRequest {

    private String serviceName;
    private String productName;
    private String token;
    private String tenantId;
    private String locale;
    private String routerKey;
    private String hostProd = "Athena";
    // AgileInteraction
    private String hostId;
    private Map<String, String> headers;
    private Map<String, Object> params;
    private Map<String, Object> eocMap;

    public static EspRequest of(String sn, String pn, Map<String, Object> pms, Map<String, String> headers) {
        EspRequest request = new EspRequest();
        request.setServiceName(sn);
        request.setProductName(pn);
        request.setParams(pms);
        request.setHeaders(headers);
        return request;
    }

    public String jsonBody() {
        if (null == params) {
            params = new HashMap<>();
        }
        Map<String, Object> body = new HashMap<>();
        Map<String, Object> stdData = new HashMap<>();
        body.put("std_data", stdData);
        stdData.put("parameter", params);
        return JSON.toJSONString(body);
    }

}
