package com.digiwin.athena.datamap.supports;

import com.digiwin.athena.datamap.povo.DataRequest;

import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-08-27 17:08
 **/
@Data
public class ParseContext2 {

    private DataRequest request;
    private Project project;
    private int maxDepth = 10;
    // private List<TaskStep> steps = new ArrayList<>();
    private Set<String> parsedStates = new HashSet<>();
    private List<Task> tasks = new ArrayList<>();
    private Set<String> taskCodes = new HashSet<>();
    private List<Task> firstTasks = new ArrayList<>();

    public boolean parsed(String state) {
        return parsedStates.contains(state);
    }

    public void addParsed(String state) {
        parsedStates.add(state);
    }

    public void addParsed(Task task) {
        tasks.add(task);
        taskCodes.add(task.getCode());
    }

}
