package com.digiwin.athena.datamap.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.luhuiguo.chinese.ChineseUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @title: TranslateUtils
 * @projectName: hfgo
 * @description: TranslateUtils
 * @author: linc
 * @date 2023/7/11 14:45
 * @version: 1.0
 */
@Slf4j
@Service
public class DataMapTranslateUtils {

    @Autowired
    RestTemplate restTemplate;

    @Value("${translateUrl}/restful/service/translater/IDWTranslateService/translateCustom")
    private String requestUrl;

    @Value("${translateUrl}/restful/service/translater/IDWTranslateCustomService/km")
    private String requestKmUrl;  // 如果已经翻译则不再翻译

    private static final String REQUEST_URL = "https://translation.digiwincloud.com/restful/service/translater/IDWTranslateService/translateCustom";

    private static final String KEY = "key";

    @Autowired
    private DWHttpClient dwHttpClient;

    // 将内容转换为繁体
    /*public String translateContentToTw(Object content)  {
        HttpHeaders headers = new HttpHeaders();
        // 设置headers
        headers.setContentType(MediaType.APPLICATION_JSON);

        // 使用 ImmutableMap 和 Map.of 代替 new HashMap<>()
        // zh2Hant为简体转繁体
        Map<String, Object> requestMap = ImmutableMap.of(
                "content", ImmutableMap.of(KEY, content),
                "convertTypes", new String[] {"zh2Hant"}
        );

        try{
            HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
            ResponseEntity<Object> resEntity = this.restTemplate.exchange(REQUEST_URL, HttpMethod.POST, requestEntity, Object.class);
            JSONObject result = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            if (null != result && result.getIntValue("status") == HttpStatus.OK.value()) {
                // 获取 lang 节点下的 zh_TW 值
                Object langData = result.getJSONObject("response").getJSONObject("data").getOrDefault("lang", null);
                if (null == langData) {
                    Object responseData = result.getJSONObject("response").getJSONObject("data").get(KEY);
                    LanguageUtil.processLocaleLanguage(responseData,"zh_TW");
                    processJson(responseData);
                    return responseData.toString();
                }else {
                    return result.getJSONObject("response").getJSONObject("data").getJSONObject("lang").getJSONObject(KEY).getString("zh_TW");
                }
            }
        } catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}",e);
        }
        return ChineseUtils.toTraditional(JSON.toJSONString(content));
    }*/

    // 将内容转换为繁体
    public String translateContentToTw(Object content)  {
        HttpPost httpPost = new HttpPost(requestUrl);

        // 设置headers
        httpPost.setHeader("Content-Type",MediaType.APPLICATION_JSON.toString());

        // 设置请求体
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", ImmutableMap.of(KEY, content));
        requestBody.put("convertTypes", new String[] {"zh2Hant"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(),
                ContentType.create("application/json", Charsets.UTF_8));
        httpPost.setEntity(requestEntity);

        try{
            // 发送请求
            HttpResponse response = dwHttpClient.execute(httpPost,new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value()) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String responseString = EntityUtils.toString(entity, "UTF-8");
                    JSONObject result = JSON.parseObject(responseString);
                    // 获取 lang 节点下的 zh_TW 值
                    Object langData = result.getJSONObject("response").getJSONObject("data").getOrDefault("lang", null);
                    if (null == langData) {
                        Object responseData = result.getJSONObject("response").getJSONObject("data").get(KEY);
                        LanguageUtil.processLocaleLanguage(responseData,"zh_TW");
                        processJson(responseData);
                        return responseData.toString();
                    }else {
                        return result.getJSONObject("response").getJSONObject("data").getJSONObject("lang").getJSONObject(KEY).getString("zh_TW");
                    }
                }
            }
        } catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}",e);
        }
        return ChineseUtils.toTraditional(JSON.toJSONString(content));
    }

    public String translateContent(Object content) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(requestUrl);

        // 设置headers
        httpPost.setHeader("Content-Type",MediaType.APPLICATION_JSON.toString());

        // 设置请求体
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", ImmutableMap.of(KEY, content));
        requestBody.put("convertTypes", new String[] {"zh2Hant", "zh2Hans"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(),
                ContentType.create("application/json", Charsets.UTF_8));
        httpPost.setEntity(requestEntity);

        try{
            // 发送请求
            HttpResponse response = dwHttpClient.execute(httpPost,new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value()) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String responseString = EntityUtils.toString(entity, "UTF-8");
                    JSONObject result = JSON.parseObject(responseString);
                    // 获取 lang 节点下的 zh_TW 值
                    Object responseData = result.getJSONObject("response").getJSONObject("data").get(KEY);
                    return responseData.toString();
                }
            }
        } catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}",e);
        }
        throw new DWBusinessException("数据转多语言出现问题");
    }

    public JSONObject translateContent(String key, Object content, String[] translateTypes) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(requestUrl);

        // 设置headers
        httpPost.setHeader("Content-Type",MediaType.APPLICATION_JSON.toString());

        // 设置请求体
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", ImmutableMap.of(key, content));
        requestBody.put("convertTypes", translateTypes);
        StringEntity requestEntity = new StringEntity(requestBody.toString(),
                ContentType.create("application/json", Charsets.UTF_8));
        httpPost.setEntity(requestEntity);

        try{
            // 发送请求
            HttpResponse response = dwHttpClient.execute(httpPost,new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value()) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String responseString = EntityUtils.toString(entity, "UTF-8");
                    JSONObject result = JSON.parseObject(responseString);
                    // 获取 lang 节点
                    return result.getJSONObject("response").getJSONObject("data").getJSONObject("lang");
                }
            }
        } catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}",e);
        }
        throw new DWBusinessException("数据转多语言出现问题");
    }


    /**
     * 递归处理 JSON 对象或数组  去掉lang和language
     */
    private static void processJson(Object json) {
        if (json instanceof JSONObject) {
            // 如果是 JSON 对象，就检查它是否包含指定字段，如果存在，就删除它
            JSONObject jsonObj = (JSONObject) json;
            if (jsonObj.containsKey("lang")) {
                jsonObj.remove("lang");
            }
            if (jsonObj.containsKey("language")) {
                jsonObj.remove("language");
            }

            // 继续递归处理当前对象的所有子节点
            jsonObj.forEach((key, value) -> processJson(value));
        } else if (json instanceof JSONArray) {
            // 如果是 JSON 数组，就递归处理数组中的每一个元素
            JSONArray jsonArray = (JSONArray) json;
            jsonArray.forEach(DataMapTranslateUtils::processJson);
        }
    }

    public Object translateSmartDataContent(Object content) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(requestKmUrl);

        // 设置headers
        httpPost.setHeader("Content-Type",MediaType.APPLICATION_JSON.toString());

        // 设置请求体
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", ImmutableMap.of(KEY, content));
        requestBody.put("convertTypes", new String[] {"zh2Hant", "zh2Hans"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(),
                ContentType.create("application/json", Charsets.UTF_8));
        httpPost.setEntity(requestEntity);

        try{
            // 发送请求
            HttpResponse response = dwHttpClient.execute(httpPost,new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value()) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String responseString = EntityUtils.toString(entity, "UTF-8");
                    JSONObject result = JSON.parseObject(responseString);
                    // 获取 lang 节点下的 zh_TW 值
                    return result.getJSONObject("response").getJSONObject("data").get(KEY);
//                    return responseData;
                }
            }
        } catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}",e);
        }
        throw new DWBusinessException("数据转多语言出现问题");
    }

}
