package com.digiwin.athena.datamap.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;
@Component
@Slf4j
public class DataMapUtils {


    public static HttpClient httpclient = null;

    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)
            .setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();

    @Autowired(required = false)
    @Qualifier(HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN)
    HttpRoutePlanner initHttpRoutePlanner;

    static HttpRoutePlanner httpRoutePlanner;

    @PostConstruct
    public void init() {
        httpRoutePlanner = initHttpRoutePlanner;
    }

    public static DapResponse request(String url, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        String json = requestString(url, httpMethod, params);
        if (null != json) {
            result = JSON.parseObject(json, DapResponse.class);
        }
        return result;
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params)  {
        return requestString(url, httpMethod, params, null);
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params, Map<String, String> headers)  {
        String result = null;
        if (headers == null) {
            headers = new HashMap<>();
        }
            try {
                URL u = new URL(url);
                String kghost = u.getHost();
                headers.put("Host", kghost);
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }

            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (null == token) {
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String) DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null == securityToken) {
                securityToken = (String) DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
                headers.put("digi-middleware-auth-user", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if (null != securityToken) {
                headers.put("security-token", securityToken);
            }
            // headers.put("digi-middleware-auth-app", appToken);
            if ("post".equalsIgnoreCase(httpMethod)) {
                log.info("Utils requestString beginning... 入参：{}，{}，{}", url, headers, params);
                result = postJson(url, headers, params);
                log.info("Utils requestString ending... 结果：{}", result);

            } else {
                result = DataMapUtils.get(url, headers, params);
            }

        return result;
    }

    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager() {

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };

                sslContext.init(null, new TrustManager[]{tm}, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            httpclient = HttpClients.custom().setMaxConnPerRoute(384).setMaxConnTotal(1024).setSSLContext(sslContext).setRoutePlanner(httpRoutePlanner)
                    // .disableAutomaticRetries()
                    .build();
        }
        return httpclient;
    }



    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList<Header> hs = new ArrayList<>();
            headers.forEach((k, v) -> {
                hs.add(new BasicHeader(k, v));
            });
            return hs.toArray(new Header[]{});
        }
        return null;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params)  {
        String result = null;

        HttpResponse response = get0(url, toHeader(headers), params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpClientUtils.closeQuietly(response);
        return result;
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) {
        T result = JSON.parseObject(get(url, headers, params), c);
        return result;
    }


    public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params)  {

        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v.toString();
                    sb.append(k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
                } catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage(), e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);
        get.setHeaders(headers);
        get.setConfig(requestConfig);
        HttpResponse response = null;
        if (log.isInfoEnabled()) {
            log.info("get url=" + url + ",headers=" + JSON.toJSONString(headers) + ",params=" + params);
        }
        try {
            response = getHttpClient().execute(get);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params)  {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity(myEntity);
        HttpResponse response = null;
        if (log.isInfoEnabled()) {
            log.info("post to:" + url + ",and request body=" + jsonbody + " and header=" + headers);
        }
        try {
            response = getHttpClient().execute(httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        } finally {
            HttpClientUtils.closeQuietly(response);
        }
        if (log.isInfoEnabled()) {
            log.info("response from :" + url + ",response body=" + result);
        }

        return result;
    }




    public static String join(List<?> list, String sep) {
        if (null == sep) {
            sep = ",";
        }
        if (null != list && list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int len = list.size();
            int last = len - 1;
            for (int i = 0; i < len; i++) {
                sb.append(list.get(i));
                if (i < last) {
                    sb.append(sep);
                }
            }
            return sb.toString();
        }

        return null;
    }




    public static void requiredHeaders(HttpHeaders headers) {
        try {
            HttpServletRequest request =
                    ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = ServiceUtils.getToken();
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (null == routerKey) {
                routerKey = (String) DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == securityToken) {
                securityToken = (String) DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (!StringUtils.isEmpty(routerKey)) {
                headers.set("routerKey", routerKey);
            }
            if (!StringUtils.isEmpty(token)) {
                headers.set("token", token);
                headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, token);
            }
            if (!StringUtils.isEmpty(locale)) {
                headers.set("locale", locale);
            }
            if (!StringUtils.isEmpty(securityToken)) {
                headers.set("security-token", securityToken);
            }
        } catch (Exception e) {
            log.error("requiredHeaders error", e);
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * 合并两个对象数据
     *
     * @param source    源数据
     * @param target    目标数据
     * @param clazz     对象类型
     * @param needField 正则表达式，用于过滤需要合并的字段
     * @param <T>
     * @return
     */
    public static <T> T mergeObject(T source, T target, Class<T> clazz, String needField, Boolean forceReplace) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Arrays.stream(declaredFields).filter(v -> v.getName().matches(needField)).forEach(v -> {
            try {
                // 私有属性设置为可访问
                v.setAccessible(true);
                Object strSource = v.get(source);
                Object strTarget = v.get(target);
                // 目标数据字段不存在的则直接跳过不处理
                if (!ObjectUtil.isEmpty(strTarget)) {
                    if (forceReplace) {
                        strSource = strTarget;
                    } else {
                        if (!ObjectUtil.isEmpty(strSource)) {
                            // 源数据字段也存在且不包含目标数据，在后面追加，包含则不处理
                            if (!String.valueOf(strSource).contains(String.valueOf(target))) {
                                strSource = strSource + "\n" + strTarget;
                            }
                        } else {
                            // 源数据不存在直接赋值
                            strSource = strTarget;
                        }
                    }
                }
                v.set(source, strSource);
            } catch (IllegalAccessException e) {
                log.error("合并对象失败", e);
                log.error("入参：source【{}】，target【{}】，clazz【{}】，needField【{}】", source, target, clazz, needField);
            }
        });
        return source;
    }

    /**
     * 从pageView里获取列表的layoutId
     *
     * @param pageView
     * @return
     */
    public static String getTableLayoutId(PageView pageView) {
        // 默认的pages
        JSONObject pages = JSONObject.parseObject(JSON.toJSONString(pageView.getPages()));
        JSONArray layouts;
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        // 有些数据中含dataStates层，有些没有，此处做兼容
        if (dataStates != null && !dataStates.isEmpty()) {
            layouts = dataStates.getJSONObject(0).getJSONArray("layout");
        } else {
            layouts = pages.getJSONObject("task-detail").getJSONArray("layout");
        }
        if (layouts != null && !layouts.isEmpty()) {
            String layoutId = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                // 过滤出Table列表
                if ("ATHENA_TABLE".equals(layout.getString("type"))) {
                    return true;
                }
                return false;
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                return layout.getString("id");
            }).get();
            return layoutId;
        }
        // 找不到layout时赋默认值
        return "default";
    }

    /**
     * 从pageView里获取下拉表格的layoutId
     *
     * @param pageView
     * @return
     */
    public static String getSelectorLayoutId(PageView pageView, String fieldName) {
        // 默认的pages
        JSONObject pages = JSONObject.parseObject(JSON.toJSONString(pageView.getPages()));
        JSONArray layouts;
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        // 有些数据中含dataStates层，有些没有，此处做兼容
        if (dataStates != null && !dataStates.isEmpty()) {
            layouts = dataStates.getJSONObject(0).getJSONArray("layout");
        } else {
            layouts = pages.getJSONObject("task-detail").getJSONArray("layout");
        }
        if (layouts != null && !layouts.isEmpty()) {
            String layoutId = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                // 过滤出Table列表
                if ("ATHENA_TABLE".equals(layout.getString("type"))) {
                    return true;
                }
                return false;
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                JSONArray columnDefs = layout.getJSONArray("columnDefs");
                String columnDefId = columnDefs.stream().filter(t -> {
                    JSONObject columnDef = JSONObject.parseObject(JSON.toJSONString(t));
                    JSONObject column = JSONObject.parseObject(JSON.toJSONString(columnDef.getJSONArray("columns").get(0)));
                    if (fieldName.equals(column.getString("schema"))) {
                        return true;
                    }
                    return false;
                }).findFirst().map(u -> {
                    JSONObject columnDef = JSONObject.parseObject(JSON.toJSONString(u));
                    JSONObject column = JSONObject.parseObject(JSON.toJSONString(columnDef.getJSONArray("columns").get(0)));
                    return column.getString("id");
                }).get();
                return columnDefId;
            }).get();
            return layoutId;
        }
        // 找不到layout时赋默认值
        return "default";
    }

    /**
     * 从pageView里获取下拉表格主键和表名称
     *
     * @param pageView
     * @return
     */
    public static String getTableDataKey(PageView pageView) {
        // 默认的pages
        JSONObject pages = JSONObject.parseObject(JSON.toJSONString(pageView.getPages()));
        JSONArray layouts;
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        // 有些数据中含dataStates层，有些没有，此处做兼容
        if (dataStates != null && !dataStates.isEmpty()) {
            layouts = dataStates.getJSONObject(0).getJSONArray("layout");
        } else {
            layouts = pages.getJSONObject("task-detail").getJSONArray("layout");
        }
        if (layouts != null && !layouts.isEmpty()) {
            String tableDataKey = layouts.stream().filter(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                // 过滤出Table列表
                if ("ATHENA_TABLE".equals(layout.getString("type")) &&
                        !CollectionUtils.isEmpty(layout.getJSONArray("columnDefs"))) {
                    return true;
                }
                return false;
            }).findFirst().map(v -> {
                JSONObject layout = JSONObject.parseObject(JSON.toJSONString(v));
                return layout.getString("schema");
            }).get();
            return tableDataKey;
        }
        // 找不到layout时赋默认值
        return "default";
    }

}
