package com.digiwin.athena.repository.neo4j;


import com.digiwin.athena.kg.monitorRule.MonitorRule;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface MonitorRuleRepository extends Neo4jRepository<MonitorRule,Long> {
    /**
     *  通过code属性查询MonitorRule(可以是单个MonitorRule，也可以是一个List集合)，
     * 	注意：spring-data-neo4j 支持方法命名约定查询 findBy{属性名}，findBy后面的属性名一定要MonitorRule类里存在，否则会报错
     *
     * @param ruleId
     * @param tenantVersion
     * @return
     */
    List<MonitorRule> findByCodeAndVersion(String ruleId, String tenantVersion);

    List<MonitorRule> findByVersion(String tenantVersion);

    //@Query("MATCH (t:TenantEntity {ifCommon:true,version:$0})-[:USE]->(rule:MonitorRule) where rule.version = $0 return rule")
    @Query("MATCH (rule:MonitorRule{commonApp:true}) where rule.version = $0 return rule")
    List<MonitorRule> getCommonByVersion(String tenantVersion);

    @Deprecated
    @Query("MATCH (rule:CustomizationMonitorRule) where rule.code = $0 " +
            "and rule.level = 'tenant' and rule.levelId = $1 and rule.version = $2 and rule.type = 'add' " +
            "return rule")
    List<MonitorRule> getAddedCustomByCode(String ruleId, String tenantId, String tenantVersion);

    @Query("MATCH (m:Mechanism)-[:Contains]->(rule:MonitorRule) " +
            "where m.key=$0 " +
            "return rule.code")
    List<String> getCodeByMechainismCode(String mechainismCode);

    @Query("MATCH (m:Mechanism{version:$1})-[:Contains]->(rule:MonitorRule) " +
            "where m.key=$0 " +
            "return rule.code")
    List<String> getCodeByMechainismCode(String mechainismCode, String tenantVersion);

//    @Query("MATCH (t:TenantEntity {tenantId:$2})-[:USE]->(rule:MonitorRule) where rule.code in $0 and rule.version = $1 and rule.autoRun = true return rule " +
//            "UNION " +
//            "MATCH (t:TenantEntity {ifCommon:true,version:$1})-[:USE]->(rule:MonitorRule) where rule.code in $0 and rule.version = $1 and rule.autoRun = true return rule")
    @Query("MATCH (rule:MonitorRule) where rule.code in $0 and rule.version = $1 and rule.autoRun = true and (rule.tenantId in ['SYSTEM',$2] or rule.tenantId is null or $2 in rule.inclusionTenant) return rule ")
    List<MonitorRule> queryAutoRunMonitorRuleList(List<String> ruleIdList, String tenantVersion, String tenantId);

    //根据租户获取关联的侦测code
//    @Query("MATCH (t:TenantEntity {tenantId:$0})-[:USE]->(rule:MonitorRule{version:$1}) return rule.code " +
//            "UNION " +
//            "MATCH (t:TenantEntity {ifCommon:true,version:$1})-[:USE]->(rule:MonitorRule{version:$1}) return rule.code")
//    List<String> getCodeByTenant(String tenantId, String tenantVersion);

//    @Deprecated
//    @Query("MATCH (t:TenantEntity {tenantId:$0})-[:USE]->(rule:MonitorRule) where rule.nameSpace = $1 or rule.relation_namespace = $1 return rule.code")
//    List<String> getCodeByTenantAndAppNameSpace(String tenantId, String namespace);

//    @Deprecated
//    @Query("MATCH (t:TenantEntity {tenantId:$0})-[:USE]->(rule:MonitorRule) where rule.athena_namespace = $1 return rule.code")
//    List<String> getCodeByTenantAndAppCode(String tenantId, String appCode);

    @Query("MATCH (rule:MonitorRule) return distinct rule.code as code , rule.category as category, rule.backtrackDate as backtrackDate, rule.dataCheck as dataCheck")
    List<Map> getAllMonitorRuleCodes();
}
