package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.domain.neo4j.TenantEntity;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-07 14:02
 **/
@Repository
public interface TenantEntityRepository extends Neo4jRepository<TenantEntity, Long> {

    @Query("match(te:TenantEntity) return te")
    List<TenantEntity> allTenantEntity();

    @Query("match(te:TenantEntity{tenantId:$0}) return te")
    TenantEntity tenantEntity(String tenantId);

    // @Query("match(te:AppEntity{code:$0}) return te")
    // AppEntity appEntity(String code);
    //
    // @Query("match(te:AppEntity) return te")
    // List<AppEntity> queryAllAppEntity();

}
