/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.actions.adapters;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.actions.ErpAdapter;
import com.digiwin.athena.domain.erp.Erp2DataDTO;
import com.digiwin.athena.domain.erp.Erp2FormField;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncBill;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.erp.NameValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractErpAdapter
implements ErpAdapter {
    private static final String ZH_TW = "zh_TW";
    private static final String EN_US = "en_US";
    private static final String ZH_CN = "zh_CN";

    @Override
    public ErpSyncRecord erpProject(Erp2DataDTO dto, List<ErpSyncRecord> records, Erp2FormInfo erp2FormInfo) throws DWBusinessException {
        Map<String, Object> current = this.fillMapByData(dto, erp2FormInfo);
        this.subFillData(dto, records, erp2FormInfo, current);
        ArrayList<ErpSyncRecord> records1 = new ArrayList<ErpSyncRecord>();
        for (ErpSyncRecord record : records) {
            Map<String, Object> form = this.fillMapByForm(record, erp2FormInfo);
            int score = this.dataMatch(current, form);
            if (score < 1) continue;
            record.setScore(Integer.valueOf(score));
            records1.add(record);
        }
        if (records1.size() > 0) {
            Collections.sort(records1, (r1, r2) -> r2.getScore() - r1.getScore());
            return (ErpSyncRecord)records1.get(0);
        }
        return null;
    }

    protected abstract void subFillData(Erp2DataDTO var1, List<ErpSyncRecord> var2, Erp2FormInfo var3, Map<String, Object> var4) throws DWBusinessException;

    protected Map<String, Object> fillMapByData(Erp2DataDTO dto, Erp2FormInfo erp2FormInfo) {
        HashMap<String, Object> current = new HashMap<String, Object>();
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            if (!Boolean.TRUE.equals(field.getAsUniKey()) || StringUtils.isEmpty((CharSequence)field.getPath())) continue;
            current.put(field.getKey(), this.getValue(dto.getData(), field.getPath()));
        }
        return current;
    }

    protected Map<String, Object> fillMapByForm(ErpSyncRecord record, Erp2FormInfo erp2FormInfo) {
        HashMap<String, Object> current = new HashMap<String, Object>();
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            NameValue nameValue;
            if (!Boolean.TRUE.equals(field.getAsUniKey()) || null == (nameValue = (NameValue)record.getFormData().get(field.getKey())) || null == nameValue.getValue()) continue;
            current.put(field.getKey(), nameValue.getValue());
        }
        return current;
    }

    protected int dataMatch(Map<String, Object> data, Map<String, Object> recordForm) {
        int count = 0;
        for (Map.Entry<String, Object> entry : recordForm.entrySet()) {
            String str;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (null == value || value instanceof String && StringUtils.isEmpty((CharSequence)(str = (String)value))) continue;
            Object value2 = data.get(key);
            if (value.equals(value2)) {
                ++count;
                continue;
            }
            return -1;
        }
        return count;
    }

    protected Object getValue(Object root, String path) {
        return JSONPath.eval((Object)root, (String)path);
    }

    protected ErpSyncRecord dataMatch(List<Map<String, Object>> data, Map<String, Object> recordForm) {
        int num = 0;
        HashMap<Integer, Map<String, Object>> count = new HashMap<Integer, Map<String, Object>>();
        for (Map<String, Object> records : data) {
            for (Map.Entry<String, Object> entry : recordForm.entrySet()) {
                String str;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (null == value || value instanceof String && StringUtils.isEmpty((CharSequence)(str = (String)value))) continue;
                Object value2 = records.get(key);
                if (!value.equals(value2)) break;
                ++num;
            }
            count.put(num, records);
        }
        Set set = count.keySet();
        Object[] obj = set.toArray();
        Arrays.sort(obj);
        return (ErpSyncRecord)count.get(Integer.parseInt(obj[obj.length - 1].toString()));
    }

    protected void multilingualSettings(ErpSyncBill bill) {
        if (null == bill || bill.getProgram_name().isEmpty()) {
            return;
        }
        Map programName = bill.getProgram_name();
        programName.put(ZH_TW, bill.getProgram_name().get(ZH_TW.toLowerCase()));
        programName.put(EN_US, bill.getProgram_name().get(EN_US.toLowerCase()));
        programName.put(ZH_CN, bill.getProgram_name().get(ZH_CN.toLowerCase()));
        bill.setProgram_name(programName);
    }
}

