/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.configuration;

import cn.hutool.core.util.ClassUtil;
import com.digiwin.athena.domain.common.TenantObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@EnableMongoRepositories(basePackages={"com.digiwin.athena.datamap.repoMongo"})
public class DataMapModuleConfiguration {
    public static Map<String, Class> codeToClass = new HashMap<String, Class>();
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;

    @PostConstruct
    public void scanTenantObjects() {
        Set classes = ClassUtil.scanPackageBySuper((String)"com.digiwin.athena.entity", TenantObject.class);
        for (Class c : classes) {
            codeToClass.put(this.mongoTemplate.getCollectionName(c), c);
        }
        System.out.println("codeToClass==" + codeToClass);
    }
}

