/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.configuration;

import com.digiwin.athena.kmservice.constants.DataMapDb;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.client.MongoClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class MultiMongoSourceConfiguration {
    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier(value="mappingMongoConverterSystem")
    MongoConverter converter;

    @Bean(value={"dataMapSystem"})
    public MongoTemplate dataMapSystem(MongoClient mongo) throws Exception {
        SimpleMongoClientDatabaseFactory mongoDbFactory = new SimpleMongoClientDatabaseFactory(mongo, DataMapDb.DATAMAP.getValue());
        System.out.println("systemdb...." + mongoDbFactory.getMongoDatabase().getName());
        return new MongoTemplate((MongoDatabaseFactory)mongoDbFactory, this.converter);
    }

    @Bean(value={"dataMapTenant"})
    public MongoTemplate dataMapTenant(MongoClient mongo) throws Exception {
        SimpleMongoClientDatabaseFactory mongoDbFactory = new SimpleMongoClientDatabaseFactory(mongo, DataMapDb.DATAMAPTENANT.getValue());
        System.out.println("tenantdb...." + mongoDbFactory.getMongoDatabase().getName());
        return new MongoTemplate((MongoDatabaseFactory)mongoDbFactory, this.converter);
    }

    @Bean(value={"kgSystem"})
    public MongoTemplate kgSystem() {
        SimpleMongoClientDatabaseFactory mongoDbFactorySys = new SimpleMongoClientDatabaseFactory(this.mongo, KnowledgeGraphDb.SYSTEM.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate((MongoDatabaseFactory)mongoDbFactorySys, this.converter);
        return mongoTemplateSys;
    }

    @Bean(value={"kgTenant"})
    public MongoTemplate kgTenant() {
        SimpleMongoClientDatabaseFactory mongoDbFactorySys = new SimpleMongoClientDatabaseFactory(this.mongo, KnowledgeGraphDb.TENANT.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate((MongoDatabaseFactory)mongoDbFactorySys, this.converter);
        return mongoTemplateSys;
    }

    @Bean(value={"presetMongoTemplate"})
    public MongoTemplate presetMongoTemplate() {
        SimpleMongoClientDatabaseFactory mongoDbFactory = new SimpleMongoClientDatabaseFactory(this.mongo, "preset");
        MongoTemplate presetMongoTemplate = new MongoTemplate((MongoDatabaseFactory)mongoDbFactory, this.converter);
        return presetMongoTemplate;
    }
}

