/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.engine.service.check;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.service.check.MechanismCheckHandler;
import com.digiwin.athena.datamap.engine.service.utils.ScriptEngineUtil;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpressionCheckHandler
implements MechanismCheckHandler {
    private static final Logger log = LoggerFactory.getLogger(ExpressionCheckHandler.class);

    @Override
    public boolean accept(CheckWidget condition) {
        return "expression".equalsIgnoreCase(condition.getType());
    }

    @Override
    public boolean check(CheckWidget condition, Map obj) {
        try {
            String expression = condition.getExpression();
            boolean checkResult = ExpressionCheckHandler.executeConditionEvaluator(expression, obj);
            return checkResult;
        }
        catch (Exception e) {
            log.error(e.toString());
            return false;
        }
    }

    public static boolean executeConditionEvaluator(String conditionScript, Map<String, Object> mergedVariables) throws DWBusinessException {
        String script = "";
        script = script + " if(" + conditionScript + "){  \n";
        script = script + "  return true;\n";
        script = script + " }else {  \n";
        script = script + "  return false;  \n";
        script = script + " } \n";
        return (Boolean)ScriptEngineUtil.getInstance().executeScript(script, mergedVariables);
    }

    public static void main(String[] args) throws DWBusinessException {
        HashMap<String, Object> data1 = new HashMap<String, Object>();
        data1.put("doc_no", "doc01");
        data1.put("doc_name", "\u8bf7\u8d2d\u53551");
        data1.put("type", 0);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("item", data1);
        boolean res = ExpressionCheckHandler.executeConditionEvaluator("(($(item).type==0)  && ($(item).doc_no=='doc01')) ", param);
        System.out.println(res);
    }
}

