/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.engine.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.service.check.MechanismCheckHandler;
import com.digiwin.athena.datamap.mechanism.paradigm.DataMapParadigmService;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MechHelpService {
    @Autowired
    List<MechanismCheckHandler> checkHandlers;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    DataMapParadigmService dataMapParadigmService;

    public boolean check(CheckWidget condition, Map data) {
        for (MechanismCheckHandler handler : this.checkHandlers) {
            if (!handler.accept(condition)) continue;
            return handler.check(condition, data);
        }
        return false;
    }

    public MechanismDecision getMechDecisionByDataSourceCode(String datasourcceCode) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("dataSource.code").is((Object)datasourcceCode));
        MechanismDecision decision = (MechanismDecision)this.dataPickService.tenantTemplate().findOne(query, MechanismDecision.class);
        return decision;
    }

    public List<MechanismDecisionTarget> getSuggestTargetsByIds(List<String> ids) {
        List targets = this.dataPickService.tenantTemplate().find(Query.query((CriteriaDefinition)Criteria.where((String)"targetId").in(ids)), MechanismDecisionTarget.class);
        return targets;
    }

    public String paradigmExpression(String mechanismCode, String dataCode) {
        String expression = this.dataMapParadigmService.getExpression(mechanismCode, dataCode);
        return expression;
    }
}

