/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.kg;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class DataMapMongoEntityBaseDAO {
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    KmService kmService;
    private String DEFAULT_TENANT_ID = "SYSTEM";

    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        return this.findOne(keyConditions, this.kmService.tenantVersion(), c);
    }

    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return this.findOne(keyConditions, tenantVersion, c, null);
    }

    public <T extends TenantObject> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        List queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        for (TenantObject result : queryResults) {
            if (this.DEFAULT_TENANT_ID.equals(result.getTenantId()) || result.getTenantId() == null) continue;
            return (T)result;
        }
        if (queryResults.size() > 0) {
            return (T)((TenantObject)queryResults.get(0));
        }
        return null;
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        return this.find(keyConditions, listKey, list, this.kmService.tenantVersion(), c, activityMap);
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        return this.find(keyConditions, listKey, list, tenantVersion, c, null, activityMap);
    }

    public <T extends TenantObject> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, String collectionName, Map<String, Activity> activityMap) throws DWBusinessException {
        List queryResults;
        String tenantId = ServiceUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        criteria.and(listKey).in(list);
        List list2 = queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        if (CollectionUtils.isEmpty((Collection)queryResults)) {
            return new HashMap<String, List<T>>();
        }
        Map<String, List<T>> groupedQueryResults = this.getGroupedQueryResults(keyConditions, listKey, queryResults, c);
        HashMap result = new HashMap();
        groupedQueryResults.forEach((k, v) -> {
            String groupedKey = k.substring(k.lastIndexOf("&") + 1);
            List<Object> keyList = CollectionUtils.isEmpty((Collection)((Collection)result.get(groupedKey))) ? new LinkedList() : (List)result.get(groupedKey);
            Activity activity = (Activity)activityMap.get(groupedKey);
            boolean ifCommon = activity != null && "common".equalsIgnoreCase(activity.getAthena_namespace());
            boolean added = false;
            for (TenantObject item : v) {
                if (!ifCommon && (this.DEFAULT_TENANT_ID.equals(item.getTenantId()) || item.getTenantId() == null)) continue;
                keyList.add(item);
                added = true;
                if (ifCommon) continue;
                break;
            }
            if (!added && v.size() > 0) {
                keyList.add(v.get(0));
            }
            result.put(groupedKey, keyList);
        });
        return result;
    }

    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        return this.find(keyConditions, this.kmService.tenantVersion(), c);
    }

    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return this.find(keyConditions, tenantVersion, c, null);
    }

    public <T extends TenantObject> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        List queryResults;
        String tenantId = ServiceUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        List list = queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        if (CollectionUtils.isEmpty((Collection)queryResults)) {
            return new ArrayList();
        }
        Map<String, List<T>> groupedQueryResults = this.getGroupedQueryResults(keyConditions, queryResults, c);
        LinkedList result = new LinkedList();
        groupedQueryResults.values().forEach(group -> {
            boolean added = false;
            for (TenantObject item : group) {
                if (this.DEFAULT_TENANT_ID.equals(item.getTenantId()) || item.getTenantId() == null) continue;
                result.add(item);
                added = true;
                break;
            }
            if (!added && group.size() > 0) {
                result.add(group.get(0));
            }
        });
        return result;
    }

    private <T extends TenantObject> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, String listKey, List<T> queryResults, Class<T> c) {
        List queryResultMapList = JSON.parseArray((String)JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().collect(Collectors.groupingBy(e -> this.buildKey(keyConditions.keySet(), listKey, (Map)e)));
        HashMap groupedQueryObjResults = new HashMap();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put((String)k, JSON.parseArray((String)JSON.toJSONString((Object)list), (Class)c)));
        return groupedQueryObjResults;
    }

    private String buildKey(Collection normalKey, String listKey, Map result) {
        String normalKeyStr = String.valueOf(normalKey.stream().map(item -> String.valueOf(result.get(item))).collect(Collectors.joining("&")));
        return StringUtils.isEmpty((CharSequence)normalKeyStr) ? String.valueOf(result.get(listKey)) : normalKeyStr + "&" + result.get(listKey);
    }

    private <T extends TenantObject> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, List<T> queryResults, Class<T> c) {
        List queryResultMapList = JSON.parseArray((String)JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().collect(Collectors.groupingBy(e -> keyConditions.keySet().stream().map(item -> String.valueOf(e.get(item))).collect(Collectors.joining("&"))));
        HashMap groupedQueryObjResults = new HashMap();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put((String)k, JSON.parseArray((String)JSON.toJSONString((Object)list), (Class)c)));
        return groupedQueryObjResults;
    }
}

