/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.activitybuilder.ActivityBuildService;
import com.digiwin.athena.datamap.mechanism.checkhandlers.CheckHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MechanismHelpService {
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    @Lazy
    List<ActivityBuildService> activityBuildServices;
    @Autowired
    @Lazy
    List<CheckHandler> checkHandlers;
    @Autowired
    PluginService pluginService;

    public void unapplyCommon(BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of((String)context.getTenantId(), (String)context.getPluginId());
        this.pluginService.postRemovePlugin(binding);
    }

    public List<Activity> parseActivity(ActivityWidget ma, MechanismParseContext context) {
        List<Object> activities = null;
        for (ActivityBuildService buildService : this.activityBuildServices) {
            if (!buildService.accept(ma)) continue;
            activities = buildService.build(ma, context);
            break;
        }
        if (null == activities) {
            activities = new ArrayList();
        }
        return activities;
    }

    public String toExpression(CheckWidget check, MechanismParseContext context) {
        String expression = null;
        if (null == check) {
            return null;
        }
        for (CheckHandler handler : this.checkHandlers) {
            if (!handler.accept(check)) continue;
            expression = handler.expression(check);
            break;
        }
        expression = this.replaceMechanismVariable(expression, context, true);
        return expression;
    }

    public String replaceMechanismVariable(String content, MechanismParseContext context, boolean isScript) {
        if (null != content && CollectionUtils.isNotEmpty((Collection)context.getBo().getRegisterParams()) && context.getBindingContext().getMechanismVariables().size() > 0) {
            for (String key : context.getBo().getRegisterParams()) {
                String template = "\\$\\(" + key + "\\)";
                Object value = context.getBindingContext().getMechanismVariables().get(key);
                if (null == value) continue;
                if (isScript && value instanceof String) {
                    content = content.replaceAll(template, "'" + value.toString() + "'");
                    continue;
                }
                content = content.replaceAll(template, value.toString());
            }
        }
        return content;
    }

    public String uid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public <T> T convert(Object obj, Class<T> c) {
        if (null == obj) {
            return null;
        }
        Object t = this.dataPickService.convert(obj, c);
        return (T)t;
    }

    public static void main(String[] args) {
        String str = "aaa$(aa)bbb";
        String template = "\\$\\(aa\\)";
        System.out.println(str.replaceAll(template, "-"));
    }
}

