/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.activitybuilder.ActivityBuildService;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.activity.TaskInitiateActivityWidget;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class TaskInitiateBuildService
implements ActivityBuildService {
    private static final Logger log = LoggerFactory.getLogger(TaskInitiateBuildService.class);
    @Autowired
    private DataMapPickService dataPickService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;

    @Override
    public boolean accept(ActivityWidget ma) {
        return "taskInitiate".equalsIgnoreCase(ma.getType());
    }

    @Override
    public List<Activity> build(ActivityWidget ma, MechanismParseContext context) {
        TaskInitiateActivityWidget convert = (TaskInitiateActivityWidget)this.dataPickService.convert(ma, TaskInitiateActivityWidget.class);
        SourceWidget sourceWidget = context.getBo().getCheckSource();
        if ("taskSource".equalsIgnoreCase(sourceWidget.getType())) {
            this.taskInitiateWhenTaskSource(convert, context);
        } else if ("projectSource".equalsIgnoreCase(sourceWidget.getType())) {
            this.taskInitiateWhenProjectSource(convert, context);
        } else if ("scheduleSource".equalsIgnoreCase(sourceWidget.getType())) {
            this.taskInitiateWhenScheduleSource(convert, context);
        }
        return new ArrayList<Activity>();
    }

    private void taskInitiateWhenTaskSource(TaskInitiateActivityWidget convert, MechanismParseContext context) {
        try {
            String dataCode = context.getSourceWidget().getTarget();
            Task sourceTask = (Task)this.dataPickService.findByCode(dataCode, Task.class);
            if (sourceTask == null) {
                throw new RuntimeException("taskInitiate error, not found sourceTask:" + dataCode);
            }
            List stateMaps = sourceTask.getStateMaps();
            StateMap sourceStateMap = (StateMap)stateMaps.get(0);
            this.taskInitiateWithNewFrom(sourceStateMap.getInput(), convert, context);
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("taskInitiate error:" + e.getMessage());
        }
    }

    private void taskInitiateWhenProjectSource(TaskInitiateActivityWidget convert, MechanismParseContext context) {
        try {
            String dataCode = context.getSourceWidget().getTarget();
            Project sourceProject = (Project)this.dataPickService.findBetter(dataCode, Project.class);
            if (sourceProject == null) {
                throw new RuntimeException("taskInitiate error, not found sourceProject:" + dataCode);
            }
            DataState init = sourceProject.getInit();
            String code = init.getCode();
            this.taskInitiateWithNewFrom(code, convert, context);
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("taskInitiate error:" + e.getMessage());
        }
    }

    private void taskInitiateWhenScheduleSource(TaskInitiateActivityWidget convert, MechanismParseContext context) {
        try {
            String startState = context.getStartState();
            this.taskInitiateWithNewFrom(startState, convert, context);
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("taskInitiate error:" + e.getMessage());
        }
    }

    private void taskInitiateWithNewFrom(String newFrom, TaskInitiateActivityWidget convert, MechanismParseContext context) throws DWBusinessException {
        String version = this.dataPickService.tenantVersion();
        String tenantId = ServiceUtils.getTenantId();
        Query queryTenant = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)convert.getCode()).and("tenantId").is((Object)tenantId));
        Task targetTenantTask = (Task)this.dataPickService.tenantTemplate().findOne(queryTenant, Task.class, this.dataPickService.tenantCol(Task.class));
        if (targetTenantTask == null) {
            Task targetSystemTask = (Task)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)convert.getCode()).and("tenantId").is((Object)"SYSTEM").and("version").lte((Object)version)), Task.class);
            if (targetSystemTask == null) {
                throw new RuntimeException("taskInitiate error, not found targetSystemTask:" + convert.getCode());
            }
            List sysFrom = targetSystemTask.getFrom();
            List sysStateMaps = targetSystemTask.getStateMaps();
            StateMap targetStateMap = new StateMap();
            targetStateMap.setInput(newFrom);
            targetStateMap.setGroup(context.getBindingContext().getPluginId());
            targetStateMap.setOutput(((StateMap)sysStateMaps.get(0)).getOutput());
            sysStateMaps.add(targetStateMap);
            sysFrom.add(targetStateMap.getInput());
            Task task1 = new Task();
            task1.setCode(targetSystemTask.getCode());
            task1.setFrom(sysFrom);
            task1.setTo(targetSystemTask.getTo());
            task1.setStateMaps(sysStateMaps);
            task1.setVersion("1.0");
            task1.setTenantId(tenantId);
            task1.setPluginId(context.getBindingContext().getPluginId());
            task1.setMilestone(targetSystemTask.getMilestone());
            this.dataPickService.save((TenantObject)task1, Task.class);
        } else {
            Optional<StateMap> any;
            List from = targetTenantTask.getFrom();
            List stateMaps1 = targetTenantTask.getStateMaps();
            if (CollectionUtils.isEmpty((Collection)stateMaps1)) {
                Task targetSystemTask = (Task)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)convert.getCode()).and("tenantId").is((Object)"SYSTEM").and("version").lte((Object)version)), Task.class);
                if (targetSystemTask == null) {
                    throw new RuntimeException("taskInitiate error, not found targetSystemTask:" + convert.getCode());
                }
                from = targetSystemTask.getFrom();
                stateMaps1 = targetSystemTask.getStateMaps();
            }
            if ((any = stateMaps1.stream().filter(e -> StringUtils.equals((CharSequence)e.getGroup(), (CharSequence)context.getBindingContext().getPluginId())).findAny()).isPresent()) {
                StateMap stateMap = any.get();
                if (newFrom != stateMap.getInput()) {
                    stateMap.setInput(newFrom);
                    from.remove(newFrom);
                    from.add(newFrom);
                }
            } else {
                StateMap targetStateMap = new StateMap();
                targetStateMap.setInput(newFrom);
                targetStateMap.setGroup(context.getBindingContext().getPluginId());
                targetStateMap.setOutput(((StateMap)stateMaps1.get(0)).getOutput());
                stateMaps1.add(targetStateMap);
                from.add(newFrom);
            }
            targetTenantTask.setFrom(from);
            targetTenantTask.setStateMaps(stateMaps1);
            targetTenantTask.setPluginId(context.getBindingContext().getPluginId());
            this.dataPickService.saveTenantObject((TenantObject)targetTenantTask, Task.class);
        }
    }
}

