/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.config.ActivityType;
import com.digiwin.athena.config.GroupCondition;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.component.AbstractComponentHandler;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.ControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.paradigm.DataMapParadigmService;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.AssignAbilityBo;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.FieldMapInfo;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.bo.ParadigmCondition;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.activity.GatewayWidget;
import com.digiwin.athena.mechanism.widgets.activity.VariableSetActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.GatewayFlowPath;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class AbstractAbilityComponentHandler
extends AbstractComponentHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAbilityComponentHandler.class);
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    List<ControlSourceHandler> sourceHandlers;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapParadigmService dataMapParadigmService;
    private static final String defaultDataCode = "requisitions";

    @Override
    public Object doHandlerApply(MechanismComponentDTO dto, BindingContext context) throws Exception {
        if (ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(dto.getType())) {
            ControlAbilityBO bo = this.convert(dto.getAbility(), ControlAbilityBO.class);
            this.apply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType())) {
            DecisionAbilityBO bo = this.convert(dto.getAbility(), DecisionAbilityBO.class);
            this.apply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType())) {
            LimitAbilityBo bo = this.convert(dto.getAbility(), LimitAbilityBo.class);
            bo.setCode(dto.getPluginId());
            bo.setDataViewCode(dto.getDataViewCode());
            this.apply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType())) {
            AssignAbilityBo bo = this.convert(dto.getAbility(), AssignAbilityBo.class);
            this.apply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType())) {
            DriveAbilityBo bo = this.convert(dto.getAbility(), DriveAbilityBo.class);
            this.apply((MechanismAbility)bo, context);
        }
        return context.getResult();
    }

    @Override
    public Object doHandlerUnApply(MechanismComponentDTO dto, BindingContext context) throws DWException {
        if (ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(dto.getType())) {
            ControlAbilityBO bo = this.convert(dto.getAbility(), ControlAbilityBO.class);
            this.unapply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType())) {
            DecisionAbilityBO bo = this.convert(dto.getAbility(), DecisionAbilityBO.class);
            this.unapply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType())) {
            LimitAbilityBo bo = this.convert(dto.getAbility(), LimitAbilityBo.class);
            this.unapply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType())) {
            AssignAbilityBo bo = this.convert(dto.getAbility(), AssignAbilityBo.class);
            this.unapply((MechanismAbility)bo, context);
        } else if (ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType())) {
            DriveAbilityBo bo = this.convert(dto.getAbility(), DriveAbilityBo.class);
            this.unapply((MechanismAbility)bo, context);
        }
        return context.getResult();
    }

    public abstract void apply(MechanismAbility var1, BindingContext var2) throws Exception;

    public abstract void unapply(MechanismAbility var1, BindingContext var2) throws DWException;

    protected <T> T convert(Object obj, Class<T> c) {
        return this.mechanismHelpService.convert(obj, c);
    }

    public MechanismParseContext buildTaskFlow(MechanismAbility runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        String pluginId = bindingContext.getPluginId();
        String tenantId = bindingContext.getTenantId();
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        if ("tdd".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        Task task1 = new Task();
        task1.setCode(this.mechanismHelpService.uid());
        task1.setFlowCode(this.mechanismHelpService.uid());
        task1.setMasterCode(runnableAbility.getCheckSource().getTarget());
        task1.setName("\u673a\u5236\u4efb\u52a1");
        task1.setType("business");
        task1.setPattern("MECHANISM");
        task1.setCategory("PROCESS");
        task1.setExecuteType("AUTO");
        task1.setName(runnableAbility.getName());
        task1.setVersion("1.0");
        task1.setTenantId(tenantId);
        task1.setPluginId(pluginId);
        task1.setAssistantType("MECHANISM");
        task1.setPriority(Integer.valueOf(98));
        task1.setMilestone(Boolean.valueOf(false));
        task1.setAtmcDatas(new ArrayList());
        parseContext.setTask(task1);
        parseContext.setDataCode(runnableAbility.getCheckSource().getDataCode());
        this.parseSource(runnableAbility.getCheckSource(), parseContext);
        FlowGraph flow1 = this.basicFlow(task1.getFlowCode());
        flow1.setTenantId(tenantId);
        flow1.setPluginId(pluginId);
        FlowLink lastLink = new FlowLink();
        lastLink.setFrom(flow1.getStartNodeId());
        flow1.getLinks().add(lastLink);
        parseContext.setFlow(flow1);
        String dataCode = parseContext.getDataCode();
        String startState = null;
        String endState = null;
        Task taskMaster = null;
        if (null != task1.getMasterCode() && null != (taskMaster = (Task)this.dataPickService.findByCode(task1.getMasterCode(), Task.class))) {
            List from = taskMaster.getFrom();
            String firstState = (String)from.get(0);
            startState = (String)from.get(from.size() - 1);
            DataState dataState = (DataState)this.dataPickService.findByCode(firstState, DataState.class);
            dataCode = dataState.getDataCode();
        }
        if (null == startState) {
            startState = this.newState(dataCode, parseContext);
        }
        Task paradigmTask = this.paradigmTask(dataCode, parseContext);
        StateMap mstateMap = new StateMap();
        if (null != paradigmTask) {
            StateMap stateMap = new StateMap();
            stateMap.setInput(startState);
            String end0 = this.newState(dataCode, parseContext);
            String end1 = this.newState(dataCode, parseContext);
            stateMap.getOutput().put("end0", end0);
            stateMap.getOutput().put("end1", end1);
            paradigmTask.getStateMaps().add(stateMap);
            paradigmTask.getFrom();
            paradigmTask.getTo();
            this.dataPickService.saveTenantObject((TenantObject)paradigmTask, Task.class);
            mstateMap.setInput(end1);
            mstateMap.getOutput().put("end0", end0);
            endState = end0;
        } else {
            mstateMap.setInput(startState);
            String end0 = this.newState(dataCode, parseContext);
            mstateMap.getOutput().put("end0", end0);
            endState = end0;
        }
        mstateMap.getOutput().put("end_noout", this.mechanismHelpService.uid());
        mstateMap.getOutput().put(flow1.getNooutEndNodeId(), this.mechanismHelpService.uid());
        task1.getStateMaps().add(mstateMap);
        parseContext.setStartState(startState);
        parseContext.setEndState(endState);
        if (null != runnableAbility.getPreActivities()) {
            lastLink = this.applyActivities(lastLink, runnableAbility.getPreActivities(), parseContext);
        }
        parseContext.setLastLink(lastLink);
        if (null != taskMaster) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)taskMaster.getCode()).and("tenantId").is((Object)tenantId));
            List from = taskMaster.getFrom();
            from.add(endState);
            Task tenantTask = new Task();
            tenantTask.setCode(taskMaster.getCode());
            tenantTask.setTenantId(tenantId);
            tenantTask.setVersion(taskMaster.getVersion());
            tenantTask.setFrom(from);
            tenantTask.setPluginId(pluginId);
            this.setStateMaps(taskMaster, tenantTask, startState, endState);
            this.dataPickService.save((TenantObject)tenantTask, Task.class);
        }
        if (null != task1.getMasterCode()) {
            PluginRecord record = new PluginRecord();
            record.setTenantId(tenantId);
            record.setPluginId(pluginId);
            record.setMasterCode(task1.getMasterCode());
            record.setMechanismCode(parseContext.getBindingContext().getMechanismCode());
            record.setInputState(startState);
            record.setOutputState(endState);
            this.dataPickService.tenantTemplate().save((Object)record);
        }
        return parseContext;
    }

    protected MechanismParseContext buildContext(MechanismAbility runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        if ("tdd".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        if ("adp".equals(runnableAbility.getCheckSource().getSourcePage())) {
            return parseContext;
        }
        return parseContext;
    }

    private void setStateMaps(Task taskMaster, Task tenantTask, String startState, String endState) {
        List mstateStateMap = taskMaster.getStateMaps();
        Optional<StateMap> first = mstateStateMap.stream().filter(stateMap -> Objects.equals(startState, stateMap.getInput())).findFirst();
        if (first.isPresent()) {
            StateMap stateMap2 = new StateMap();
            BeanUtil.copyProperties((Object)first.get(), (Object)stateMap2, (String[])new String[0]);
            stateMap2.setInput(endState);
            mstateStateMap.add(stateMap2);
            tenantTask.setStateMaps(mstateStateMap);
        }
    }

    public void removeStates(PluginBindingPo binding) {
    }

    public void buildGateway1(SingleStrategyWidget check, MechanismParseContext parseContext) {
        if (null != check) {
            FlowLink lastLink = parseContext.getLastLink();
            FlowLink defaultCondition = null;
            if (null != check.getCondition()) {
                if (null != check.getCondition().getVariables()) {
                    lastLink = this.applyVariables(lastLink, check.getCondition().getVariables(), parseContext);
                    parseContext.setLastLink(lastLink);
                }
                FlowGraph flow1 = parseContext.getFlow();
                String gatewayId = "gateway_" + this.mechanismHelpService.uid();
                FlowNode node2 = new FlowNode();
                node2.setId(gatewayId);
                node2.setType("gateway");
                node2.setGateType("exclusive");
                flow1.getNodes().add(node2);
                lastLink.setTo(gatewayId);
                FlowLink link1 = new FlowLink();
                link1.setFrom(gatewayId);
                String cond = this.mechanismHelpService.toExpression(check.getCondition(), parseContext);
                link1.setCondition(cond);
                link1.setSeq(Integer.valueOf(0));
                flow1.getLinks().add(link1);
                lastLink = link1;
                defaultCondition = new FlowLink();
                defaultCondition.setFrom(gatewayId);
                defaultCondition.setTo(flow1.getEndNodeId());
                defaultCondition.setSeq(Integer.valueOf(1));
                flow1.getLinks().add(defaultCondition);
            }
            if (null != check.getPositiveTarget()) {
                List widgets = new ArrayList();
                ActivityPlanWidget planWidget1 = this.convert(check.getPositiveTarget(), ActivityPlanWidget.class);
                if (null != planWidget1 && null != planWidget1.getActivityWidget()) {
                    widgets = planWidget1.getActivityWidget();
                }
                lastLink = this.applyActivities(lastLink, widgets, parseContext);
            }
            if (CollectionUtils.isNotEmpty((Collection)parseContext.getBo().getPostActivities()) && null != defaultCondition) {
                VariableSetActivityWidget emptyWidget = new VariableSetActivityWidget();
                emptyWidget.setType("variableSet");
                HashMap config = new HashMap();
                ArrayList<MechanismVariable> list = new ArrayList<MechanismVariable>();
                MechanismVariable v1 = new MechanismVariable();
                v1.setData_name("test0001");
                v1.setData_type("number");
                v1.setPath("return 1");
                list.add(v1);
                config.put("variables", list);
                emptyWidget.setConfig(config);
                lastLink = this.applyActivities(lastLink, Arrays.asList(emptyWidget), parseContext);
                defaultCondition.setTo(lastLink.getFrom());
            }
            parseContext.setLastLink(lastLink);
        }
    }

    public String newState(String dataCode, MechanismParseContext parseContext) {
        if (null == dataCode) {
            dataCode = defaultDataCode;
        }
        String state = this.mechanismHelpService.uid();
        DataState state1 = new DataState();
        state1.setCode(state);
        state1.setDataCode(dataCode);
        state1.setTenantId(parseContext.getBindingContext().getTenantId());
        state1.setPluginId(parseContext.getBindingContext().getPluginId());
        this.dataPickService.saveTenantObject((TenantObject)state1, DataState.class);
        return state;
    }

    public void endTaskFlow(FlowLink lastLink, MechanismParseContext context) {
        if (CollectionUtils.isNotEmpty((Collection)context.getBo().getPostActivities())) {
            lastLink = this.applyActivities(lastLink, context.getBo().getPostActivities(), context);
        }
        Task task = context.getTask();
        task.setName("\u673a\u5236\u4efb\u52a1");
        FlowGraph flow = context.getFlow();
        lastLink.setTo(flow.getEndNodeId());
        if (flow.getNodes().size() > 3) {
            task.getFrom();
            task.getTo();
            this.dataPickService.saveTenantObject((TenantObject)task, Task.class);
            this.dataPickService.saveTenantObject((TenantObject)flow, FlowGraph.class);
        }
    }

    public FlowGraph basicFlow(String code) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(code);
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setLinks(new ArrayList());
        flowGraph.setNodes(new ArrayList());
        String startNodeId = "start_" + this.mechanismHelpService.uid();
        String endNodeId = "end_" + this.mechanismHelpService.uid();
        String endNodeId2 = "end_" + this.mechanismHelpService.uid();
        flowGraph.setStartNodeId(startNodeId);
        flowGraph.setEndNodeId(endNodeId);
        flowGraph.setNooutEndNodeId(endNodeId2);
        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        endNode.setDataKey("end0");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        FlowNode endNode2 = new FlowNode();
        endNode2.setId(endNodeId2);
        endNode2.setDataKey("end_noout");
        endNode2.setType("end");
        flowGraph.getNodes().add(endNode2);
        return flowGraph;
    }

    public void parseSource(SourceWidget checkSource, MechanismParseContext context) throws DWBusinessException {
        if (null == checkSource || null == checkSource.getType()) {
            return;
        }
        for (ControlSourceHandler sourceHandler : this.sourceHandlers) {
            if (!sourceHandler.accept(checkSource)) continue;
            sourceHandler.parse(checkSource, context);
            break;
        }
    }

    public FlowLink applyActivities(FlowLink lastLink, List<? extends ActivityWidget> mechanismActivities, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        FlowGraph flow1 = parseContext.getFlow();
        if (null == mechanismActivities) {
            return lastFlowLink;
        }
        for (ActivityWidget activityWidget : mechanismActivities) {
            if (activityWidget instanceof GatewayWidget) {
                lastFlowLink = this.applyGatewayActivity(lastFlowLink, (GatewayWidget)activityWidget, parseContext);
                continue;
            }
            List<Activity> activities = this.mechanismHelpService.parseActivity(activityWidget, parseContext);
            for (Activity activity1 : activities) {
                activity1.setCode(this.mechanismHelpService.uid());
                activity1.setTenantId(parseContext.getBindingContext().getTenantId());
                activity1.setPluginId(parseContext.getBindingContext().getPluginId());
                activity1.setVersion("1.0");
                String nodeId = "activity_" + this.mechanismHelpService.uid();
                FlowNode node1 = new FlowNode();
                node1.setId(nodeId);
                node1.setType("activity");
                node1.setActivityCode(activity1.getCode());
                flow1.getNodes().add(node1);
                lastFlowLink.setTo(nodeId);
                FlowLink link1 = new FlowLink();
                link1.setFrom(nodeId);
                flow1.getLinks().add(link1);
                lastFlowLink = link1;
                this.dataPickService.saveTenantObject((TenantObject)activity1, Activity.class);
            }
        }
        return lastFlowLink;
    }

    protected FlowLink applyGatewayActivity(FlowLink lastLink, GatewayWidget widget, MechanismParseContext parseContext) {
        if (CollectionUtils.isEmpty((Collection)widget.getFlowPaths())) {
            return lastLink;
        }
        FlowGraph flow1 = parseContext.getFlow();
        String gatewayId = "gateway_" + this.mechanismHelpService.uid();
        FlowNode node2 = new FlowNode();
        node2.setId(gatewayId);
        node2.setType("gateway");
        node2.setGateType("exclusive");
        flow1.getNodes().add(node2);
        lastLink.setTo(gatewayId);
        int seq = 0;
        for (GatewayFlowPath flowPath : widget.getFlowPaths()) {
            if (null == flowPath.getCondition()) continue;
            FlowLink condLink = new FlowLink();
            condLink.setFrom(gatewayId);
            String cond = this.mechanismHelpService.toExpression(flowPath.getCondition(), parseContext);
            condLink.setCondition(cond);
            condLink.setSeq(Integer.valueOf(seq));
            flow1.getLinks().add(condLink);
            FlowLink condLast = this.applyActivities(condLink, flowPath.getActivityWidgetList(), parseContext);
            if (Boolean.TRUE.equals(flowPath.getNotOutput())) {
                condLast.setTo(flow1.getNooutEndNodeId());
            } else {
                condLast.setTo(flow1.getEndNodeId());
            }
            if (condLink != condLast) {
                flow1.getLinks().add(condLast);
            }
            ++seq;
        }
        FlowLink link1 = new FlowLink();
        link1.setFrom(gatewayId);
        link1.setSeq(Integer.valueOf(99));
        flow1.getLinks().add(link1);
        lastLink = link1;
        return lastLink;
    }

    public FlowLink applyVariables(FlowLink lastLink, List<MechanismVariable> variables, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        if (null != variables && variables.size() > 0) {
            for (MechanismVariable variable : variables) {
                variable.setPath(variable.wrapperedPath());
            }
            VariableSetActivityWidget checkSet = new VariableSetActivityWidget();
            checkSet.setVariables(variables);
            checkSet.setType(ActivityType.variableSet.name());
            lastFlowLink = this.applyActivities(lastFlowLink, Arrays.asList(checkSet), parseContext);
        }
        return lastFlowLink;
    }

    public FlowLink buildGateway(FlowLink lastLink, CheckWidget condition, MechanismParseContext parseContext) {
        FlowLink lastFlowLink = lastLink;
        if (null == condition) {
            return lastFlowLink;
        }
        FlowGraph flow1 = parseContext.getFlow();
        String gatewayId = "gateway_" + this.mechanismHelpService.uid();
        FlowNode node2 = new FlowNode();
        node2.setId(gatewayId);
        node2.setType("gateway");
        node2.setGateType("exclusive");
        flow1.getNodes().add(node2);
        lastFlowLink.setTo(gatewayId);
        FlowLink link1 = new FlowLink();
        link1.setFrom(gatewayId);
        String cond = this.mechanismHelpService.toExpression(condition, parseContext);
        link1.setCondition(cond);
        link1.setSeq(Integer.valueOf(0));
        flow1.getLinks().add(link1);
        lastFlowLink = link1;
        FlowLink defaultCondition = new FlowLink();
        defaultCondition.setFrom(gatewayId);
        defaultCondition.setTo(flow1.getEndNodeId());
        defaultCondition.setSeq(Integer.valueOf(1));
        flow1.getLinks().add(defaultCondition);
        if (CollectionUtils.isNotEmpty((Collection)parseContext.getBo().getPostActivities())) {
            VariableSetActivityWidget emptyWidget = new VariableSetActivityWidget();
            emptyWidget.setType("variableSet");
            lastFlowLink = this.applyActivities(lastLink, Arrays.asList(emptyWidget), parseContext);
            defaultCondition.setTo(lastLink.getFrom());
        }
        return lastFlowLink;
    }

    public Task paradigmTask(String dataCode, MechanismParseContext parseContext) throws DWBusinessException {
        if (null == dataCode || null == parseContext.getBindingContext().getMechanismCode()) {
            return null;
        }
        ParadigmCondition paradigmCondition = this.dataMapParadigmService.getParadigmConditionByMechanismCode(parseContext.getBindingContext().getMechanismCode());
        if (null == paradigmCondition || null == paradigmCondition.getConditions() || null == paradigmCondition.getFieldMapsTo()) {
            return null;
        }
        String tenantId = parseContext.getBindingContext().getTenantId();
        String pluginId = parseContext.getBindingContext().getPluginId();
        HashMap<String, String> keyMaps = new HashMap<String, String>();
        block0: for (Map.Entry en : paradigmCondition.getFieldMapsTo().entrySet()) {
            for (FieldMapInfo info : (List)en.getValue()) {
                if (!dataCode.equals(info.getData_name())) continue;
                keyMaps.put((String)en.getKey(), info.getField());
                continue block0;
            }
        }
        String expression = DataMapParadigmService.parseParadigmCondition(paradigmCondition, keyMaps, null);
        if (null == expression) {
            log.warn("paradigm expression is null,by paradigmCondition:" + paradigmCondition);
            return null;
        }
        Task task1 = new Task();
        task1.setCode(this.mechanismHelpService.uid());
        task1.setFlowCode(this.mechanismHelpService.uid());
        task1.setType("business");
        task1.setPattern("PARADIGM");
        task1.setCategory("PROCESS");
        task1.setExecuteType("AUTO");
        task1.setName("\u8303\u5f0f\u4efb\u52a1");
        task1.setVersion("1.0");
        task1.setTenantId(tenantId);
        task1.setPluginId(pluginId);
        task1.setAssistantType("MECHANISM");
        task1.setPriority(Integer.valueOf(99));
        task1.setMilestone(Boolean.valueOf(false));
        task1.setAtmcDatas(new ArrayList());
        task1.getConfig().put("_mechanismCode", parseContext.getBindingContext().getMechanismCode());
        task1.getConfig().put("_dataCode", dataCode);
        FlowGraph flow1 = this.basicFlow(task1.getFlowCode());
        flow1.setTenantId(tenantId);
        flow1.setPluginId(pluginId);
        flow1.getNodes().forEach(node -> node.setDataKey(null));
        Activity createData = new Activity();
        createData.setCode(this.mechanismHelpService.uid());
        createData.setPattern("PARADIGM");
        createData.setPluginId(pluginId);
        createData.setTenantId(tenantId);
        createData.setType("createData");
        createData.getConfig().put("_mechanismCode", parseContext.getBindingContext().getMechanismCode());
        createData.getConfig().put("_dataCode", dataCode);
        createData.getConfig().put("dataVariable", "data");
        createData.getConfig().put("groupType", "ByCondition");
        ArrayList<GroupCondition> conditions = new ArrayList<GroupCondition>();
        GroupCondition condition1 = new GroupCondition();
        condition1.setSeq(Integer.valueOf(0));
        condition1.setDataKey("end1");
        condition1.setCondition(expression);
        condition1.setName("\u5224\u65ad\u6210\u529f");
        conditions.add(condition1);
        GroupCondition condition2 = new GroupCondition();
        condition2.setSeq(Integer.valueOf(1));
        condition2.setDataKey("end0");
        condition2.setName("\u9ed8\u8ba4");
        conditions.add(condition2);
        createData.getConfig().put("conditions", conditions);
        FlowNode createDataNode = new FlowNode();
        createDataNode.setId("createDataNode");
        createDataNode.setType("activity");
        createDataNode.setActivityCode(createData.getCode());
        flow1.getNodes().add(createDataNode);
        FlowLink link1 = new FlowLink();
        link1.setFrom(flow1.getStartNodeId());
        link1.setTo(createDataNode.getId());
        flow1.getLinks().add(link1);
        FlowLink link2 = new FlowLink();
        link2.setFrom(createDataNode.getId());
        link2.setTo(flow1.getEndNodeId());
        flow1.getLinks().add(link2);
        this.dataPickService.saveTenantObject((TenantObject)createData, Activity.class);
        this.dataPickService.saveTenantObject((TenantObject)flow1, FlowGraph.class);
        return task1;
    }
}

