/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.component.AbstractAbilityComponentHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class DriveAbilityHandler
extends AbstractAbilityComponentHandler {
    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        this.unapply(ability, context);
        DriveAbilityBo bo = (DriveAbilityBo)ability;
        MechanismParseContext parseContext = this.buildTaskFlow((MechanismAbility)bo, context);
        this.buildGateway1(bo.getChoose(), parseContext);
        this.endTaskFlow(parseContext.getLastLink(), parseContext);
        this.buildProject(bo.getProjectCode(), parseContext);
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of((String)context.getTenantId(), (String)context.getPluginId());
        this.pluginService.postRemovePlugin(binding);
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismDrive.name().equalsIgnoreCase(dto.getType());
    }

    public void buildProject(String code, MechanismParseContext context) {
        Task task = context.getTask();
        Project project = new Project();
        project.setCode(code);
        project.setTenantId(context.getBindingContext().getTenantId());
        project.setPluginId(context.getBindingContext().getPluginId());
        project.setExecuteType("mainline");
        project.setType("BUSINESS");
        project.setName("\u673a\u5236\u9a71\u52a8\u9879\u76ee");
        DataState dataState1 = new DataState();
        dataState1.setCode(context.getStartState());
        dataState1.setDataCode(context.getDataCode());
        project.setInit(dataState1);
        DataState dataState2 = new DataState();
        dataState2.setCode(context.getEndState());
        dataState2.setDataCode(context.getDataCode());
        project.setEnd(dataState2);
        UserDefinition charge = new UserDefinition();
        charge.setChoosePolicy("single");
        ArrayList<Identity> identities = new ArrayList<Identity>();
        charge.setIdentities(identities);
        Identity identity = new Identity();
        identity.setPerformerType("duty");
        identity.setPerformerValue((Object)"athena_buyers");
        identities.add(identity);
        project.setPersonInCharge(charge);
        this.dataPickService.saveTenantObject((TenantObject)project, Project.class);
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}

