/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.component.AbstractAbilityComponentHandler;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitCommonUtil;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class LimitAbilityHandler
extends AbstractAbilityComponentHandler {
    private static final Logger log = LoggerFactory.getLogger(LimitAbilityHandler.class);
    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    LimitCommonUtil limitCommonUtil;
    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    ReminderLimitHandler reminderLimitHandler;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws Exception {
        this.unapply(ability, context);
        LimitAbilityBo bo = (LimitAbilityBo)ability;
        MechanismParseContext parseContext = this.buildContext((MechanismAbility)bo, context);
        String taskCode = bo.getCheckSource().getTarget();
        String pageCode = null;
        if (parseContext.getSourceWidget().getType().equalsIgnoreCase("taskSource")) {
            Task task = (Task)this.dataPickService.findBetter(taskCode, Task.class);
            pageCode = task == null ? null : task.getPageCode();
        } else if (parseContext.getSourceWidget().getType().equalsIgnoreCase("projectSource")) {
            pageCode = "start_" + bo.getCheckSource().getTarget();
        }
        if (this.preHandleReminder(ability, context)) {
            this.limitCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());
            this.setActionParams(parseContext, bo);
            return;
        }
        if (null != pageCode) {
            PageView pageView = (PageView)this.dataPickService.findBetter(pageCode, PageView.class);
            HooksInfo hooksInfoAll = new HooksInfo();
            if (null != pageView) {
                JudgeBasisParser judgeBasisParser = this.mechanismParserFactory.getJudgeParserByType(MechanismEnum.ConditionType.LIMIT_CONDITION.getCode());
                if (null != judgeBasisParser) {
                    judgeBasisParser.parse(ability, pageView, context, hooksInfoAll);
                } else {
                    log.error("LimitAbilityHandler.apply \u83b7\u53d6JudgeParser\u5931\u8d25\uff0c\u5165\u53c2{}", (Object)context);
                }
                this.limitCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());
                this.limitCommonUtil.addMechanismParameter(bo, parseContext, hooksInfoAll, pageView);
                this.dataPickService.saveTenantObject((TenantObject)pageView, PageView.class);
            }
        }
    }

    private void setActionParams(MechanismParseContext parseContext, LimitAbilityBo bo) {
        try {
            log.info("Route==>LimitAbilityHandler method=setActionParams ability:{}", (Object)JSON.toJSONString((Object)bo));
            List strategies = bo.getStrategies();
            if (CollectionUtils.isEmpty((Collection)strategies)) {
                log.info("Route==>LimitAbilityHandler method=setActionParams strategies isEmpty ability:{}", (Object)JSON.toJSONString((Object)bo));
                return;
            }
            SingleStrategyWidget singleStrategyWidget = (SingleStrategyWidget)strategies.get(0);
            PlanWidget positiveTarget = singleStrategyWidget.getPositiveTarget();
            if (Objects.isNull(positiveTarget)) {
                log.info("Route==>LimitAbilityHandler method=setActionParams positiveTarget isNull ability:{}", (Object)JSON.toJSONString((Object)bo));
                return;
            }
            Object message = ((ReminderPlan)positiveTarget).getMessage();
            if (parseContext.getSourceWidget().getType().equalsIgnoreCase("taskSource")) {
                BindingContext bindingContext = parseContext.getBindingContext();
                SourceWidget sourceWidget = parseContext.getSourceWidget();
                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setType("TM_VARIABLE");
                tenantObjectAdaptation.setCode(sourceWidget.getTarget());
                tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
                tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
                tenantObjectAdaptation.setPath("$.pages.task-detail.dataStates[0].submitActions[0].actionParams");
                ActionParam actionParam = new ActionParam();
                actionParam.setType("TM_VARIABLE");
                actionParam.setValue((Object)(message + ""));
                actionParam.setName(message + "");
                tenantObjectAdaptation.setValue((Object)actionParam);
                tenantObjectAdaptation.setDateType("array");
                tenantObjectAdaptation.setOp("add");
                tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
                tenantObjectAdaptation.setExt(new HashMap());
                this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataPickService.tableTenantObjectAdaptation(PageView.class));
            } else if (parseContext.getSourceWidget().getType().equalsIgnoreCase("dataEntrySource") && !StringUtils.isEmpty((Object)bo.getDataViewCode())) {
                BindingContext bindingContext = parseContext.getBindingContext();
                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setType("TM_VARIABLE");
                tenantObjectAdaptation.setCode(bo.getDataViewCode());
                tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
                tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
                tenantObjectAdaptation.setPath("$.elements..submitActions[0].actionParams");
                ActionParam actionParam = new ActionParam();
                actionParam.setType("TM_VARIABLE");
                actionParam.setValue((Object)(message + ""));
                actionParam.setName(message + "");
                tenantObjectAdaptation.setValue((Object)actionParam);
                tenantObjectAdaptation.setDateType("array");
                tenantObjectAdaptation.setOp("add");
                tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
                tenantObjectAdaptation.setExt(new HashMap());
                this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataPickService.tableTenantObjectAdaptation(PageUIElement.class));
            }
        }
        catch (Exception e) {
            log.error("Route==>LimitAbilityHandler method=setActionParams error:", (Throwable)e);
        }
    }

    private boolean preHandleReminder(MechanismAbility ability, BindingContext context) {
        boolean result = false;
        LimitAbilityBo bo = (LimitAbilityBo)ability;
        this.presetLibraryService.cleanRule(bo.getCode());
        try {
            Optional<SingleStrategyWidget> first;
            List strategies = bo.getStrategies();
            if (null != strategies && (first = strategies.stream().filter(widget -> widget.getPositiveTarget() != null && MechanismPlanType.reminderPlan.name().equalsIgnoreCase(widget.getPositiveTarget().getType())).findFirst()).isPresent()) {
                MechanismParseContext parseContext = this.buildParseContext(bo, context);
                parseContext.getBindingContext().setMechanismVersion(context.getMechanismVersion());
                for (SingleStrategyWidget widget2 : strategies) {
                    if (null != widget2.getCondition() && null != widget2.getCondition().getVariables()) {
                        FlowLink lastLink = this.applyVariables(parseContext.getLastLink(), widget2.getCondition().getVariables(), parseContext);
                        parseContext.setLastLink(lastLink);
                    }
                    if (widget2.getPositiveTarget() == null || !MechanismPlanType.reminderPlan.name().equalsIgnoreCase(widget2.getPositiveTarget().getType())) continue;
                    this.reminderLimitHandler.handler(widget2, parseContext);
                    result = true;
                }
            }
        }
        catch (Exception e) {
            log.error("LimitAbilityHandler.preHandleReminder failed", (Throwable)e);
            return true;
        }
        return result;
    }

    private MechanismParseContext buildParseContext(LimitAbilityBo runnableAbility, BindingContext bindingContext) {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo((MechanismAbility)runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());
        return parseContext;
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        Query query;
        PluginBindingPo binding = PluginBindingPo.of((String)context.getTenantId(), (String)context.getPluginId());
        this.pluginService.postRemovePlugin(binding);
        LimitAbilityBo bo = (LimitAbilityBo)ability;
        if ("dataEntrySource".equals(bo.getCheckSource().getType())) {
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)context.getPluginId()).and("tenantId").is((Object)context.getTenantId()).and("code").is((Object)bo.getDataViewCode()));
            this.dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageUIElement.class));
        }
        if ("taskSource".equals(bo.getCheckSource().getType())) {
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)context.getPluginId()).and("tenantId").is((Object)context.getTenantId()).and("code").is((Object)bo.getCheckSource().getTarget()));
            this.dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(bo.getCheckSource().getType())) {
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)context.getPluginId()).and("tenantId").is((Object)context.getTenantId()).and("code").is((Object)bo.getCheckSource().getTarget()));
            this.dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(dto.getType()) && "2.0".equalsIgnoreCase(dto.getMechanismVersion());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        Boolean parseResult = this.mechanismParserFactory.getLimitConditionParserByType(apiInfoDTO.getLimitConditionType()).parse(apiInfoDTO);
        if (Boolean.TRUE.compareTo(parseResult) == 1) {
            log.info("LimitAbilityHandler.parseScene getLimitConditionParserByType\u5224\u65ad\u672a\u901a\u8fc7\uff01\u76f4\u63a5\u8fd4\u56de");
            return null;
        }
        try {
            return this.mechanismParserFactory.getLimitActionParserByType(apiInfoDTO.getLimitActionType()).parse(apiInfoDTO);
        }
        catch (Exception e) {
            log.error("LimitAbilityHandler parseScene failed, e={}", (Throwable)e);
            return null;
        }
    }
}

