/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.controlSourcehandlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.AbstractControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.impl.ProjectService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.common.MechanismCheckSourceType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ProjectSourceWidget;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ProjectSourceHandler
extends AbstractControlSourceHandler {
    @Autowired
    DataPickService dataPickService;
    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    ProjectService projectService;
    @Autowired
    MechanismHelpService mechanismHelpService;

    @Override
    public boolean accept(SourceWidget source) {
        return MechanismCheckSourceType.projectSource.name().equals(source.getType());
    }

    @Override
    public void parse(SourceWidget source, MechanismParseContext context) throws DWBusinessException {
        Task task1 = context.getTask();
        ProjectSourceWidget projectSourceWidget = (ProjectSourceWidget)this.dataPickService.convert((Object)source, ProjectSourceWidget.class);
        context.setSourceWidget((SourceWidget)projectSourceWidget);
        String projectCode = projectSourceWidget.getTarget();
        Project project = (Project)this.dataPickService.findByCode(projectCode, Project.class);
        if (null != project) {
            Task taskMaster3;
            if (null == context.getDataCode()) {
                context.setDataCode(project.getInit().getDataCode());
            }
            HashMap<String, List<String>> query = new HashMap<String, List<String>>();
            query.put("from", Arrays.asList(project.getInit().getCode()));
            List tasks = this.dataPickService.find(BasicQuery.of(query, null), Task.class);
            if (CollectionUtils.isNotEmpty((Collection)tasks)) {
                Task taskMaster = (Task)tasks.get(0);
                task1.setMasterCode(taskMaster.getCode());
            }
            if (Boolean.TRUE.equals(project.getManualAble()) && null != (taskMaster3 = this.projectService.manualProjectPageTask(projectCode))) {
                context.setProjectPageTarget(taskMaster3.getCode());
            }
        }
    }
}

