/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.JSFunctions;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.widgets.config.MechanismCheckConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsExpressionConverter {
    @Autowired
    JSFunctions jsFunctions;
    @Autowired
    List<JsExpressionParser> parsers;

    public JsExpression convert(MechanismConditionConfig conditionConfig, BindingContext context) throws DWBusinessException {
        for (JsExpressionParser parser : this.parsers) {
            if (!parser.accept(conditionConfig)) continue;
            return parser.parse(conditionConfig, context);
        }
        return null;
    }

    public JsExpression convert(MechanismCheckConfig checkConfig, BindingContext context) throws DWBusinessException {
        if (null != checkConfig && null != checkConfig.getGroups()) {
            return this.convertByGroups(checkConfig.getGroups(), context);
        }
        return null;
    }

    public JsExpression convertByGroups(List<MechanismConditionGroup> groups, BindingContext context) throws DWBusinessException {
        if (groups.isEmpty()) {
            return null;
        }
        HashSet<String> functions = new HashSet<String>();
        HashSet<DynamicFunction> dynamicFunction = new HashSet<DynamicFunction>();
        ArrayList<String> orExpression = new ArrayList<String>();
        for (MechanismConditionGroup group : groups) {
            ArrayList<JsExpression> expressions = new ArrayList<JsExpression>();
            for (MechanismConditionConfig condition : group.getConditions()) {
                JsExpression exp = this.convert(condition, context);
                if (null == exp || null == exp.getExpression()) continue;
                expressions.add(exp);
                functions.addAll(exp.getFunction());
                dynamicFunction.addAll(exp.getDynamicFunction());
            }
            if (expressions.size() <= 0) continue;
            StringBuilder sb = new StringBuilder();
            int len = expressions.size();
            for (int i = 0; i < len; ++i) {
                JsExpression expression = (JsExpression)expressions.get(i);
                sb.append("(").append(expression.getExpression()).append(")");
                if (i >= len - 1) continue;
                sb.append(" && ");
            }
            orExpression.add(sb.toString());
        }
        JsExpression jsExpression = new JsExpression();
        jsExpression.setFunction(functions);
        jsExpression.setDynamicFunction(dynamicFunction);
        if (orExpression.size() == 1) {
            jsExpression.setExpression((String)orExpression.get(0));
        } else {
            StringBuilder sb = new StringBuilder();
            int len = orExpression.size();
            for (int i = 0; i < len; ++i) {
                String expression = (String)orExpression.get(i);
                sb.append("(").append(expression).append(")");
                if (i >= len - 1) continue;
                sb.append(" || ");
            }
            jsExpression.setExpression(sb.toString());
        }
        return jsExpression;
    }

    public String functionExpression(Set<String> functionNames) {
        StringBuilder sb = new StringBuilder();
        for (String name : functionNames) {
            String fun = this.jsFunctions.function(name);
            if (null == fun) continue;
            sb.append(fun).append(";");
        }
        return sb.toString();
    }

    public String dynamicFunctionExpression(Set<DynamicFunction> functions) {
        StringBuilder sb = new StringBuilder();
        for (DynamicFunction function : functions) {
            String name = function.getFunctionName();
            String fun = this.jsFunctions.function(name);
            if (null == fun) continue;
            Map<String, String> parameter = function.getParameter();
            if (!parameter.isEmpty()) {
                for (Map.Entry<String, String> entry : parameter.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    fun = fun.replaceAll(key, value);
                }
            }
            sb.append(fun).append(";");
        }
        return sb.toString();
    }
}

