/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import org.springframework.stereotype.Service;

@Service
public class DateExpressionParser
implements JsExpressionParser {
    @Override
    public boolean accept(MechanismConditionConfig config) {
        return "date".equalsIgnoreCase(config.getLeft().getData_type());
    }

    @Override
    public JsExpression parse(MechanismConditionConfig config, BindingContext context) throws DWBusinessException {
        String op;
        StringBuilder sb = new StringBuilder();
        switch (op = config.getOpType()) {
            case "eq": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" == ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            case "gt": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" > ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            case "gte": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" >= ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            case "lt": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" < ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            case "lte": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" <= ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            case "between": {
                sb.append(this.fieldParse(config.getLeft(), context)).append(" >= ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getFrom()));
                sb.append(" && ");
                sb.append(this.fieldParse(config.getLeft(), context)).append(" <= ").append(this.targetParse(config.getRight().getCurrentType(), config.getRight().getTo()));
                break;
            }
            default: {
                throw new DWBusinessException("not support opType:" + op);
            }
        }
        JsExpression jsExpression = new JsExpression();
        jsExpression.setExpression(sb.toString());
        jsExpression.getFunction().add("parseDate");
        jsExpression.getFunction().add("nowTime");
        return jsExpression;
    }

    private String fieldParse(MechanismVariable left, BindingContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("parseDate(").append(this.pathExpr(left.getData_name(), context)).append(",'").append(left.getFormat()).append("')");
        return sb.toString();
    }

    private String targetParse(String currentType, MechanismVariable to) throws DWBusinessException {
        Integer value = null;
        if (to.getValue() instanceof Number) {
            value = (Integer)to.getValue();
        } else if (to.getValue() instanceof String) {
            value = Integer.parseInt((String)to.getValue());
        } else {
            throw new DWBusinessException("value is not integer or string :" + to.getValue());
        }
        long addTime = 0L;
        switch (to.getUnit()) {
            case "day": {
                addTime = value * 24 * 3600 * 1000;
                break;
            }
            case "week": {
                addTime = value * 24 * 3600 * 1000 * 7;
                break;
            }
            case "month": {
                addTime = value * 24 * 3600 * 1000 * 30;
                break;
            }
        }
        if (null == currentType) {
            currentType = "currentDay";
        }
        switch (currentType) {
            case "currentDay": {
                return "nowTime()+" + addTime;
            }
            case "currentWeek": {
                break;
            }
            case "currentMonth": {
                break;
            }
            default: {
                throw new DWBusinessException("not support currentType:" + currentType);
            }
        }
        return null;
    }
}

