/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction.CustomFuncParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CountDisParser
implements CustomFuncParser {
    private static final Logger log = LoggerFactory.getLogger(CountDisParser.class);

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.COUNT_DIS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.COUNT_DIS.getOutputType();
    }

    @Override
    public Long parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        long countValue = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            return metaDataObj.get((Object)dataName);
        }).filter(v -> v != null).distinct().count();
        return countValue;
    }
}

