/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction.CustomFuncParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExistParser
implements CustomFuncParser {
    private static final Logger log = LoggerFactory.getLogger(ExistParser.class);

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.EXIST.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.EXIST.getOutputType();
    }

    @Override
    public Boolean parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        Object condValueObj = mechanismVariable.getMechanismFunction().getFunctionValue();
        if (condValueObj == null) {
            return Boolean.FALSE;
        }
        long count = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            Object sourceValueObj = metaDataObj.get((Object)dataName);
            if (sourceValueObj != null) {
                return sourceValueObj.toString();
            }
            return null;
        }).filter(v -> !StringUtils.isEmpty((CharSequence)v) && StringUtils.equalsIgnoreCase((CharSequence)condValueObj.toString(), (CharSequence)v)).count();
        return count > 0L;
    }
}

