/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.CustomFunctionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.config.DecisionScene;
import com.digiwin.athena.mechanism.widgets.config.DecisionTarget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ConditionParser
implements JudgeBasisParser {
    private static final Logger log = LoggerFactory.getLogger(ConditionParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    CustomFunctionParser customFunctionParser;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.ConditionType.PRIMARY.getCode().equalsIgnoreCase(type) || MechanismEnum.ConditionType.HIGH_GRADE.getCode().equalsIgnoreCase(type);
    }

    @Override
    public void parse(MechanismAbility ability, PageView pageView, BindingContext context, HooksInfo hooksInfoAll) {
        DecisionAbilityBO bo = (DecisionAbilityBO)ability;
        context.getMechanismVariables().put("hookSelectorInitDataFieldParam", bo.getVariable().getData_name());
        if (CollectionUtils.isEmpty((Collection)bo.getDecisionOption().getScenes())) {
            log.error("\u65e0\u573a\u666f\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)ability);
            return;
        }
        String layoutId = DataMapUtils.getTableLayoutId(pageView);
        HashMap<String, Object> apiInfo = new HashMap<String, Object>();
        HashMap<String, Object> paramsInfo = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> req = new HashMap<String, HashMap<String, Object>>();
        String tableDataKey = DataMapUtils.getTableDataKey(pageView);
        Object dataSourceTable = pageView.getDataSources().get(tableDataKey);
        if (dataSourceTable == null) {
            dataSourceTable = pageView.getDataSources().values().iterator().next();
        }
        Object dataKeys = JsonPath.read(dataSourceTable, (String)"$.dataKeys", (Predicate[])new Predicate[0]);
        try {
            MechanismConditionConfig mechanismCondition = (MechanismConditionConfig)((MechanismConditionGroup)((DecisionScene)bo.getDecisionOption().getScenes().get(0)).getCheck().getGroups().get(0)).getConditions().get(0);
            HooksParser hooksParser = this.mechanismParserFactory.getHooksParserByConfig(mechanismCondition);
            if (null == hooksParser) {
                log.error("ApiParser.parseScene \u83b7\u53d6HooksParser\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)bo);
            }
            HooksInfo hooksInfo = hooksParser.parse(mechanismCondition, context, pageView, null);
            hooksInfoAll.getDynamicFunctions().addAll(hooksInfo.getDynamicFunctions());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790pageView\u83b7\u53d6\u51b3\u7b56\u6761\u4ef6\u5931\u8d25\uff0c\u53c2\u6570scenes\uff1a{}", (Object)bo);
            return;
        }
        paramsInfo.put("api", "/mechanism/postQueryApiResult");
        paramsInfo.put("requestJson", new Object());
        paramsInfo.put("ability", ability);
        paramsInfo.put("abilityType", "MechanismDecision");
        paramsInfo.put("keyFieldNameList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataKeys)));
        paramsInfo.put("isNeedEsp", Boolean.FALSE);
        req.put("req", paramsInfo);
        apiInfo.put("params", req);
        apiInfo.put("type", "api");
        hooksInfoAll.getApiList().add(apiInfo);
        HashMap<String, Object> callApiParams = new HashMap<String, Object>();
        callApiParams.put("hookCallApiAppType", MechanismEnum.ConditionType.STANDARD.getCode());
        callApiParams.put("hookCallApiFieldParam", bo.getVariable().getData_name());
        callApiParams.put("hookCallApiApiListParam", hooksInfoAll.getApiList());
        callApiParams.put("hookCallApiKeyFieldNameList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataKeys)));
        callApiParams.put("hookCallApiTableDataKey", tableDataKey);
        hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction().setFunctionName("hookCallApi").setHookName("gridReadyHook").setSourceId(layoutId).setParameter(callApiParams));
        hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction().setFunctionName("hookCallParamPrepare").setHookName("afterViewInitHook").setSourceId(layoutId).setParameter(callApiParams));
    }

    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        DecisionAbilityBO bo = this.mechanismHelpService.convert(apiInfoDTO.getAbility(), DecisionAbilityBO.class);
        if (CollectionUtils.isEmpty((Collection)bo.getDecisionOption().getScenes())) {
            log.error("\u65e0\u573a\u666f\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)apiInfoDTO);
            return null;
        }
        if (ObjectUtils.isEmpty((Object)apiInfoDTO.getTableData())) {
            log.error("\u65e0\u573a\u8868\u683c\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)apiInfoDTO);
            return null;
        }
        JSONArray metaDataList = JSON.parseArray((String)JSON.toJSONString((Object)apiInfoDTO.getTableData()));
        HashMap<String, Object> accordTableDataMap = new HashMap<String, Object>();
        for (int i = 1; i <= bo.getDecisionOption().getScenes().size(); ++i) {
            DecisionScene decisionScene = (DecisionScene)bo.getDecisionOption().getScenes().get(i - 1);
            List targets = decisionScene.getTargets();
            List groups = decisionScene.getCheck().getGroups();
            accordTableDataMap.putAll(this.parseSingleScene(groups, metaDataList, apiInfoDTO, targets));
        }
        return accordTableDataMap.values();
    }

    public Map<String, Object> parseSingleScene(List<MechanismConditionGroup> groups, JSONArray metaDataList, MechanismApiInfoDTO apiInfoDTO, List<DecisionTarget> targets) {
        LinkedList keyFieldNameList = new LinkedList();
        if (apiInfoDTO != null) {
            keyFieldNameList.addAll(apiInfoDTO.getKeyFieldNameList());
        }
        HashMap<String, Object> accordSceneDataMap = new HashMap<String, Object>();
        if (apiInfoDTO == null && CollectionUtils.isEmpty(groups)) {
            accordSceneDataMap.put("list", metaDataList);
            return accordSceneDataMap;
        }
        JSONArray accordSceneDataArray = new JSONArray();
        for (int i = 0; i < groups.size(); ++i) {
            List conditions = groups.get(i).getConditions();
            JSONArray accordDataArray = new JSONArray();
            accordDataArray.addAll((Collection)metaDataList);
            for (int j = 0; j < conditions.size(); ++j) {
                String dataType;
                JSONArray tempAccordDataArray;
                MechanismConditionConfig conditionConfig = (MechanismConditionConfig)conditions.get(j);
                if (MechanismEnum.ConditionType.HIGH_GRADE.getCode().equalsIgnoreCase(conditionConfig.getType())) {
                    this.customFunctionParser.preParseLeftCond(conditionConfig.getLeft(), accordDataArray);
                }
                if (CollectionUtils.isEmpty((Collection)(tempAccordDataArray = this.mechanismParserFactory.getFieldTypeParserByConfig(dataType = conditionConfig.getLeft().getData_type()).parse(conditionConfig, accordDataArray)))) {
                    accordDataArray.clear();
                    break;
                }
                accordDataArray.clear();
                accordDataArray.addAll((Collection)tempAccordDataArray);
            }
            if (apiInfoDTO == null) {
                accordSceneDataArray.addAll((Collection)accordDataArray);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)accordDataArray)) continue;
            accordDataArray.stream().forEach(k -> {
                JSONObject rowData = JSON.parseObject((String)JSON.toJSONString((Object)k));
                JSONObject accordRowData = new JSONObject();
                JSONObject keyObj = new JSONObject();
                accordRowData.put("key", (Object)keyObj);
                accordRowData.put("field_value", (Object)targets);
                accordRowData.put("row_data", k);
                StringBuilder priKeyValue = new StringBuilder();
                for (int n = 0; n < keyFieldNameList.size(); ++n) {
                    keyObj.put((String)keyFieldNameList.get(n), rowData.get(keyFieldNameList.get(n)));
                    priKeyValue.append(rowData.get(keyFieldNameList.get(n)));
                }
                accordSceneDataMap.put(priKeyValue.toString(), accordRowData);
            });
        }
        if (apiInfoDTO == null) {
            accordSceneDataMap.put("list", accordSceneDataArray);
        }
        return accordSceneDataMap;
    }
}

