/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.CustomFunctionParser;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.service.impl.DataMapMechanismService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LimitConditionParser
implements JudgeBasisParser {
    private static final Logger log = LoggerFactory.getLogger(LimitConditionParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    CustomFunctionParser customFunctionParser;
    @Autowired
    ReminderLimitHandler reminderLimitHandler;
    @Autowired
    DataMapMechanismService dataMapMechanismService;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.ConditionType.LIMIT_CONDITION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public void parse(MechanismAbility ability, PageView pageView, BindingContext context, HooksInfo hooksInfoAll) {
        LimitAbilityBo bo = (LimitAbilityBo)ability;
        context.getMechanismVariables().put("hookSelectorInitDataFieldParam", bo);
        if (CollectionUtils.isEmpty((Collection)bo.getStrategies())) {
            log.error("\u65e0\u573a\u666f\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)ability);
            return;
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            HashMap<String, Object> paramsInfo = new HashMap<String, Object>();
            HashMap<String, HashMap<String, Object>> req = new HashMap<String, HashMap<String, Object>>();
            HashMap<String, Object> apiInfo = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> apiList = new ArrayList<HashMap<String, Object>>();
            if (null == pageView.getDataSources() || pageView.getDataSources().isEmpty()) {
                return;
            }
            Object dataSourceTable = pageView.getDataSources().values().iterator().next();
            Object dataKeys = JsonPath.read(dataSourceTable, (String)"$.dataKeys", (Predicate[])new Predicate[0]);
            MechanismConditionConfig mechanismCondition = new MechanismConditionConfig();
            SingleStrategyWidget limitSingleStrategy = (SingleStrategyWidget)bo.getStrategies().get(0);
            PlanWidget positiveTarget = limitSingleStrategy.getPositiveTarget();
            paramsInfo.put("api", "/mechanism/postQueryApiResult");
            paramsInfo.put("requestJson", new Object());
            paramsInfo.put("ability", this.buildAbility(bo));
            paramsInfo.put("abilityType", "MechanismLimit");
            paramsInfo.put("limitConditionType", positiveTarget.getConditionType());
            paramsInfo.put("limitActionType", positiveTarget.getActionType());
            paramsInfo.put("keyFieldNameList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataKeys)));
            paramsInfo.put("operationTypes", ability.getCheckSource().getOperationTypes());
            paramsInfo.put("watchFields", ability.getCheckSource().getWatchFields());
            paramsInfo.put("isNeedEsp", Boolean.FALSE);
            req.put("req", paramsInfo);
            apiInfo.put("params", req);
            apiInfo.put("type", "api");
            apiList.add(apiInfo);
            parameters.put("hookTableDataKey", pageView.getDataSources().keySet().iterator().next());
            parameters.put("hookApiList", apiList);
            parameters.put("hookKeyFieldNameList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataKeys)));
            parameters.put("hookCapacityCode", ability.getCode());
            parameters.put("hookOperationTypes", ability.getCheckSource().getOperationTypes());
            parameters.put("hookWatchFields", ability.getCheckSource().getWatchFields());
            mechanismCondition.setMetaFieldType(limitSingleStrategy.getActionHookType());
            HooksParser hooksParser = this.mechanismParserFactory.getHooksParserByConfig(mechanismCondition);
            if (null == hooksParser) {
                log.error("LimitConditionParser.parseScene \u83b7\u53d6HooksParser\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)bo);
            }
            hooksParser.buildParameters(ability, parameters);
            HooksInfo hooksInfo = hooksParser.parse(mechanismCondition, context, pageView, parameters);
            hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction().setFunctionName("initKmHookLibr").setHookName("afterViewInitHook").setSourceId(DataMapUtils.getTableLayoutId(pageView)).setParameter(new HashMap<String, Object>()));
            hooksInfoAll.getDynamicFunctions().addAll(hooksInfo.getDynamicFunctions());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790pageView\u83b7\u53d6\u51b3\u7b56\u6761\u4ef6\u5931\u8d25\uff0c\u53c2\u6570scenes\uff1a{}", (Object)bo, (Object)e);
        }
    }

    private JSONObject buildAbility(LimitAbilityBo bo) {
        PlanWidget positiveTarget = ((SingleStrategyWidget)bo.getStrategies().get(0)).getPositiveTarget();
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)positiveTarget));
        jsonObject.put("ruleContent", null);
        JSONObject jsonObject1 = JSONObject.parseObject((String)JSON.toJSONString((Object)bo));
        jsonObject1.getJSONArray("strategies").getJSONObject(0).put("positiveTarget", (Object)jsonObject);
        return jsonObject1;
    }
}

