/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.RightCondTypeParser;
import com.digiwin.athena.mechanism.bo.MechanismFunctionBO;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CustomFunctionParser
implements RightCondTypeParser {
    private static final Logger log = LoggerFactory.getLogger(CustomFunctionParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.CUSTOM_FUNCTION.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        try {
            MechanismVariable right = conditionConfig.getRight();
            if (!ObjectUtils.isEmpty((Object)right.getFrom().getMechanismFunction().getFunction())) {
                MechanismFunctionBO mechanismFunctionFrom = right.getFrom().getMechanismFunction();
                String functionNameFrom = mechanismFunctionFrom.getFunction();
                Object parseResultFrom = this.mechanismParserFactory.getCustomFuncParserByName(functionNameFrom).parse(right.getFrom(), metaDataList);
                right.getFrom().setFunctionValue(parseResultFrom);
                right.getFrom().setFunctionValueType(mechanismFunctionFrom.getOutputType());
            }
            MechanismFunctionBO mechanismFunctionTo = right.getTo().getMechanismFunction();
            String functionNameTo = mechanismFunctionTo.getFunction();
            Object parseResultTo = this.mechanismParserFactory.getCustomFuncParserByName(functionNameTo).parse(right.getTo(), metaDataList);
            right.getTo().setFunctionValue(parseResultTo);
            right.getTo().setFunctionValueType(mechanismFunctionTo.getOutputType());
        }
        catch (Exception e) {
            log.error("CustomFunctionParser.preParse \u5931\u8d25\uff0ce={}", (Throwable)e);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        if (ObjectUtils.isEmpty((Object)metaDataObj) && ObjectUtils.isEmpty((Object)metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        if (ObjectUtils.isEmpty((Object)config.getOpenWindowActionId())) {
            MechanismFunctionBO mechanismFunction = config.getRight().getMechanismFunction();
            String functionName = mechanismFunction.getFunction();
            Object parseResult = this.mechanismParserFactory.getCustomFuncParserByName(functionName).parse(config.getRight(), metaDataList);
            Object value = config.getRight().getTo().getValue();
            boolean equals = StringUtils.equals((CharSequence)(parseResult != null ? String.valueOf(parseResult) : null), (CharSequence)(parseResult != null ? String.valueOf(value) : null));
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE).setMetaDataList((JSONArray)(equals ? metaDataList : null));
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
    }

    public CustomFuncResult preParseLeftCond(MechanismVariable left, JSONArray metaDataList) {
        MechanismFunctionBO mechanismFunction = left.getMechanismFunction();
        String functionName = mechanismFunction.getFunction();
        Object parseResult = this.mechanismParserFactory.getCustomFuncParserByName(functionName).parse(left, metaDataList);
        left.setFunctionValue(parseResult);
        left.setFunctionValueType(mechanismFunction.getOutputType());
        left.setData_type(mechanismFunction.getOutputType());
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
    }
}

